/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.SingleAspectChangeSupport;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.WritableListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListValueModel<E>
extends AbstractModel
implements WritableListValueModel<E>,
List<E> {
    protected List<E> list;

    public SimpleListValueModel(List<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    public SimpleListValueModel() {
        this(new ArrayList());
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new SingleAspectChangeSupport(this, ListChangeListener.class, "list values");
    }

    @Override
    public Iterator<E> iterator() {
        return new LocalIterator<E>(this.list.iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new LocalListIterator<E>(this.list.listIterator());
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public void setListValues(Iterable<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list.clear();
        CollectionTools.addAll(this.list, list);
        this.fireListChanged("list values", this.list);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.addItemToList(o, this.list, "list values");
    }

    @Override
    public boolean remove(Object o) {
        return this.removeItemFromList(o, this.list, "list values");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addItemsToList(c, this.list, "list values");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addItemsToList(index, c, this.list, "list values");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeItemsFromList(c, this.list, "list values");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.retainItemsInList(c, this.list, "list values");
    }

    @Override
    public void clear() {
        this.clearList(this.list, "list values");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof List && o instanceof ListValueModel) {
            ArrayList<E> l1 = CollectionTools.list(this.list);
            ArrayList l2 = CollectionTools.list(((List)o).iterator());
            return l1.equals(l2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public E set(int index, E element) {
        return this.setItemInList(index, element, this.list, "list values");
    }

    @Override
    public void add(int index, E element) {
        this.addItemToList(index, element, this.list, "list values");
    }

    @Override
    public E remove(int index) {
        return this.removeItemFromList(index, this.list, "list values");
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LocalListIterator<E>(this.list.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public void move(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.list, "list values");
    }

    public void move(int targetIndex, int sourceIndex, int length) {
        this.moveItemsInList(targetIndex, sourceIndex, length, this.list, "list values");
    }

    public void remove(int index, int length) {
        this.removeItemsFromList(index, length, this.list, "list values");
    }

    @Override
    public void set(int index, List<E> elements) {
        this.setItemsInList(index, elements, this.list, "list values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private int index = -1;
        private T next;

        LocalIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.next = this.iterator.next();
            ++this.index;
            return this.next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            SimpleListValueModel.this.fireItemRemoved("list values", this.index, this.next);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private int last = -1;
        private int next = 0;
        private T current;

        LocalListIterator(ListIterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.current = this.iterator.next();
            this.last = this.next++;
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            this.current = this.iterator.previous();
            this.last = --this.next;
            return this.current;
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void set(T o) {
            this.iterator.set(o);
            SimpleListValueModel.this.fireItemReplaced("list values", this.last, o, this.current);
        }

        @Override
        public void add(T o) {
            this.iterator.add(o);
            SimpleListValueModel.this.fireItemAdded("list values", this.next, o);
        }

        @Override
        public void remove() {
            this.iterator.remove();
            SimpleListValueModel.this.fireItemRemoved("list values", this.last, this.current);
        }
    }
}

