/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.impl.postgres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.insightech.er.editor.model.dbimport.ImportFromDBManagerBase;

public class PostgresTableImportManager
extends ImportFromDBManagerBase {
    protected String getTableNameWithSchema(String schema, String tableName) {
        return this.dbSetting.getTableNameWithSchema("\"" + tableName + "\"", schema);
    }

    protected String getViewDefinitionSQL(String schema) {
        if (schema != null) {
            return "SELECT definition FROM pg_views WHERE schemaname = ? and viewname = ? ";
        }
        return "SELECT definition FROM pg_views WHERE viewname = ? ";
    }

    protected ImportFromDBManagerBase.ColumnData createColumnData(ResultSet columnSet) throws SQLException {
        ImportFromDBManagerBase.ColumnData columnData = super.createColumnData(columnSet);
        String type = columnData.type.toLowerCase();
        if (type.startsWith("time")) {
            columnData.size = columnData.decimalDegits == 6 ? 0 : columnData.decimalDegits;
            columnData.decimalDegits = 0;
        } else if (type.equals("numeric") && columnData.size == 131089 && columnData.decimalDegits == 0) {
            columnData.size = 0;
        }
        return columnData;
    }

    protected void cashOtherColumnData(String tableName, String schema, ImportFromDBManagerBase.ColumnData columnData) throws SQLException {
        if (columnData.type.equals("interval")) {
            String restrictType = this.getRestrictType(tableName, schema, columnData);
            columnData.size = restrictType != null && restrictType.indexOf("(") != -1 ? columnData.decimalDegits : 0;
            columnData.type = restrictType;
            columnData.decimalDegits = 0;
        }
    }

    private String getRestrictType(String tableName, String schema, ImportFromDBManagerBase.ColumnData columnData) throws SQLException {
        String type = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.con.prepareStatement("select atttypmod from pg_attribute inner join pg_stat_user_tables  on pg_stat_user_tables.relid = pg_attribute.attrelid  where pg_stat_user_tables.relname = ?  and pg_stat_user_tables.schemaname=?  and pg_attribute.attname = ?");
            ps.setString(1, tableName);
            ps.setString(2, schema);
            ps.setString(3, columnData.columnName);
            rs = ps.executeQuery();
            if (rs.next()) {
                int atttypmod = rs.getInt("atttypmod");
                type = atttypmod == 196607 ? "interval month" : (atttypmod == 327679 ? "interval year" : (atttypmod == 458751 ? "interval year to month" : (atttypmod == 589823 ? "interval day" : (atttypmod == 0x400FFFF ? "interval hour" : (atttypmod == 67698687 ? "interval day to hour" : (atttypmod == 0x800FFFF ? "interval minute" : (atttypmod == 201916415 ? "interval day to minute" : (atttypmod == 0xC00FFFF ? "interval hour to minute" : (atttypmod == 0x1000FFFF ? "interval second" : (atttypmod >= 0x10000001 && atttypmod <= 0x10000006 ? "interval second(p)" : (atttypmod == 402718719 ? "interval minute to second" : (atttypmod >= 0x18000001 && atttypmod <= 402653190 ? "interval minute to second(p)" : (atttypmod == 469827583 ? "interval hour to second" : (atttypmod >= 0x1C000001 && atttypmod <= 469762054 ? "interval hour to second(p)" : (atttypmod == 470351871 ? "interval day to second" : (atttypmod >= 470286337 && atttypmod <= 470286342 ? "interval day to second(p)" : (atttypmod >= 2147418113 && atttypmod <= 2147418118 ? "interval(p)" : "interval")))))))))))))))));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return type;
    }
}

