/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.db.sqltype;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.util.Check;
import org.insightech.er.util.POIUtils;

public class SqlTypeFactory {
    public static void load() throws IOException, ClassNotFoundException {
        InputStream in = SqlTypeFactory.class.getResourceAsStream("/SqlType.xls");
        try {
            HSSFWorkbook workBook = POIUtils.readExcelBook(in);
            HSSFSheet sheet = workBook.getSheetAt(0);
            HashMap<String, Map<SqlType, String>> dbAliasMap = new HashMap<String, Map<SqlType, String>>();
            HashMap<String, Map<SqlType.TypeKey, SqlType>> dbSqlTypeMap = new HashMap<String, Map<SqlType.TypeKey, SqlType>>();
            HSSFRow headerRow = sheet.getRow(0);
            int colNum = 4;
            while (colNum < headerRow.getLastCellNum()) {
                String dbId = POIUtils.getCellValue(sheet, 0, colNum);
                LinkedHashMap aliasMap = new LinkedHashMap();
                dbAliasMap.put(dbId, aliasMap);
                LinkedHashMap sqlTypeMap = new LinkedHashMap();
                dbSqlTypeMap.put(dbId, sqlTypeMap);
                ++colNum;
            }
            SqlType.setDBAliasMap(dbAliasMap, dbSqlTypeMap);
            int rowNum = 1;
            while (rowNum <= sheet.getLastRowNum()) {
                HSSFRow row = sheet.getRow(rowNum);
                String sqlTypeId = POIUtils.getCellValue(sheet, rowNum, 0);
                if (Check.isEmpty(sqlTypeId)) {
                    break;
                }
                Class<?> javaClass = Class.forName(POIUtils.getCellValue(sheet, rowNum, 1));
                boolean needArgs = POIUtils.getBooleanCellValue(sheet, rowNum, 2);
                boolean fullTextIndexable = POIUtils.getBooleanCellValue(sheet, rowNum, 3);
                SqlType sqlType = new SqlType(sqlTypeId, javaClass, needArgs, fullTextIndexable);
                int colNum2 = 4;
                while (colNum2 < row.getLastCellNum()) {
                    String dbId = POIUtils.getCellValue(sheet, 0, colNum2);
                    if (Check.isEmpty(dbId)) {
                        dbId = POIUtils.getCellValue(sheet, 0, colNum2 - 1);
                        String key = POIUtils.getCellValue(sheet, rowNum, colNum2);
                        if (!Check.isEmpty(key)) {
                            sqlType.addToSqlTypeMap(key, dbId);
                        }
                    } else {
                        Map aliasMap = (Map)dbAliasMap.get(dbId);
                        if (POIUtils.getCellColor(sheet, rowNum, colNum2) != 10) {
                            String alias = POIUtils.getCellValue(sheet, rowNum, colNum2);
                            if (Check.isEmpty(alias)) {
                                alias = sqlTypeId;
                            }
                            aliasMap.put(sqlType, alias);
                            if (POIUtils.getCellColor(sheet, rowNum, colNum2) == 40) {
                                sqlType.addToSqlTypeMap(alias, dbId);
                            }
                        }
                    }
                    ++colNum2;
                }
                ++rowNum;
            }
        }
        finally {
            in.close();
        }
    }

    public static void main(String[] args) {
        SqlType.main(null);
    }
}

