/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.SelectionManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.ResourceString;
import org.insightech.er.Resources;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.controller.editpart.element.AbstractModelEditPart;
import org.insightech.er.editor.controller.editpart.element.node.NodeElementEditPart;
import org.insightech.er.editor.controller.editpolicy.ERDiagramLayoutEditPolicy;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ViewableModel;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERDiagramEditPart
extends AbstractModelEditPart {
    private static boolean updateable = true;

    public static void setUpdateable(boolean enabled) {
        updateable = enabled;
    }

    public static boolean isUpdateable() {
        return updateable;
    }

    @Override
    public void deactivate() {
        try {
            super.deactivate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected IFigure createFigure() {
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new FreeformLayout());
        return layer;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ERDiagramLayoutEditPolicy());
    }

    protected List getModelChildren() {
        ArrayList<ViewableModel> modelChildren = new ArrayList<ViewableModel>();
        ERDiagram diagram = (ERDiagram)this.getModel();
        modelChildren.addAll(diagram.getDiagramContents().getSettings().getCategorySetting().getSelectedCategories());
        modelChildren.add(diagram.getDiagramContents().getSettings().getModelProperties());
        modelChildren.addAll(diagram.getDiagramContents().getContents().getNodeElementList());
        if (diagram.getChangeTrackingList().isCalculated()) {
            modelChildren.addAll(diagram.getChangeTrackingList().getRemovedNodeElementSet());
        }
        return modelChildren;
    }

    @Override
    public void doPropertyChange(PropertyChangeEvent event) {
        if ("consumed".equals(event.getPropagationId())) {
            return;
        }
        if (event.getPropertyName().equals("contents")) {
            this.refreshChildren();
        } else if (event.getPropertyName().equals("all")) {
            this.refresh();
            this.refreshRelations();
            List nodeElementList = (List)event.getNewValue();
            if (nodeElementList != null) {
                this.getViewer().deselectAll();
                SelectionManager selectionManager = this.getViewer().getSelectionManager();
                Map<NodeElement, EditPart> modelToEditPart = this.getModelToEditPart();
                for (NodeElement nodeElement : nodeElementList) {
                    selectionManager.appendSelection(modelToEditPart.get(nodeElement));
                }
            }
        } else if (event.getPropertyName().equals("color")) {
            this.refreshVisuals();
        } else if (event.getPropertyName().equals("database")) {
            this.changeDatabase(event);
        } else if (event.getPropertyName().equals("initDatabase")) {
            ERDiagram diagram = (ERDiagram)this.getModel();
            diagram.restoreDatabase(DBManagerFactory.getAllDBList().get(0));
        } else if (event.getPropertyName().equals("settings")) {
            this.changeSettings();
        }
    }

    public void refreshRelations() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodeElementEditPart)) continue;
            NodeElementEditPart part = (NodeElementEditPart)child;
            part.refreshConnections();
        }
    }

    public void refreshVisuals() {
        ERDiagram element = (ERDiagram)this.getModel();
        int[] color = element.getColor();
        if (color != null) {
            Color bgColor = Resources.getColor(color);
            this.getViewer().getControl().setBackground(bgColor);
        }
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodeElementEditPart)) continue;
            NodeElementEditPart part = (NodeElementEditPart)child;
            part.refreshVisuals();
        }
    }

    private void changeSettings() {
        ERDiagram diagram = (ERDiagram)this.getModel();
        Settings settings = diagram.getDiagramContents().getSettings();
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodeElementEditPart)) continue;
            NodeElementEditPart part = (NodeElementEditPart)child;
            part.changeSettings(settings);
        }
    }

    private void changeDatabase(PropertyChangeEvent event) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 292);
        messageBox.setText(ResourceString.getResourceString("dialog.title.change.database"));
        messageBox.setMessage(ResourceString.getResourceString("dialog.message.change.database"));
        if (messageBox.open() == 32) {
            event.setPropagationId("consumed");
        } else {
            ERDiagram diagram = (ERDiagram)this.getModel();
            diagram.restoreDatabase(String.valueOf(event.getOldValue()));
        }
    }

    private Map<NodeElement, EditPart> getModelToEditPart() {
        HashMap<NodeElement, EditPart> modelToEditPart = new HashMap<NodeElement, EditPart>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            modelToEditPart.put((NodeElement)editPart.getModel(), editPart);
            ++i;
        }
        return modelToEditPart;
    }
}

