/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.ddl.validator.rule.all;

import java.util.HashSet;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.ddl.validator.ValidateResult;
import org.insightech.er.editor.model.dbexport.ddl.validator.rule.BaseRule;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;

public class DuplicatedPhysicalNameRule
extends BaseRule {
    public boolean validate(ERDiagram diagram) {
        ValidateResult validateResult;
        String name;
        HashSet<String> nameSet = new HashSet<String>();
        for (ERTable table : diagram.getDiagramContents().getContents().getTableSet()) {
            name = table.getNameWithSchema(diagram.getDatabase()).toLowerCase();
            if (nameSet.contains(name)) {
                validateResult = new ValidateResult();
                validateResult.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.name")) + " [TABLE] " + name);
                validateResult.setLocation(table.getLogicalName());
                validateResult.setSeverity(1);
                validateResult.setObject(table);
                this.addError(validateResult);
            }
            nameSet.add(name);
            if ("MySQL".equals(diagram.getDatabase())) continue;
            for (Index index : table.getIndexes()) {
                String indexName = index.getName().toLowerCase();
                if (nameSet.contains(indexName)) {
                    ValidateResult validateResult2 = new ValidateResult();
                    validateResult2.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.name")) + " [INDEX] " + indexName + " on table [" + table.getLogicalName() + "]");
                    validateResult2.setLocation(indexName);
                    validateResult2.setSeverity(1);
                    validateResult2.setObject(index.getTable());
                    this.addError(validateResult2);
                }
                nameSet.add(indexName);
            }
        }
        for (Sequence sequence : diagram.getDiagramContents().getSequenceSet()) {
            name = sequence.getNameWithSchema(diagram.getDatabase()).toLowerCase();
            if (nameSet.contains(name)) {
                validateResult = new ValidateResult();
                validateResult.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.name")) + " [SEQUENCE] " + name);
                validateResult.setLocation(name);
                validateResult.setSeverity(1);
                validateResult.setObject(sequence);
                this.addError(validateResult);
            }
            nameSet.add(name);
        }
        for (View view : diagram.getDiagramContents().getContents().getViewSet()) {
            name = view.getNameWithSchema(diagram.getDatabase()).toLowerCase();
            if (nameSet.contains(name)) {
                validateResult = new ValidateResult();
                validateResult.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.name")) + " [VIEW] " + name);
                validateResult.setLocation(name);
                validateResult.setSeverity(1);
                validateResult.setObject(view);
                this.addError(validateResult);
            }
            nameSet.add(name);
        }
        for (Trigger trigger : diagram.getDiagramContents().getTriggerSet()) {
            name = trigger.getNameWithSchema(diagram.getDatabase()).toLowerCase();
            if (nameSet.contains(name)) {
                validateResult = new ValidateResult();
                validateResult.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.name")) + " [TRIGGER] " + name);
                validateResult.setLocation(name);
                validateResult.setSeverity(1);
                validateResult.setObject(trigger);
                this.addError(validateResult);
            }
            nameSet.add(name);
        }
        return true;
    }
}

