/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.ddl.validator.rule.table.impl;

import java.util.HashSet;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.dbexport.ddl.validator.ValidateResult;
import org.insightech.er.editor.model.dbexport.ddl.validator.rule.table.TableRule;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.util.Format;

public class DuplicatedColumnNameRule
extends TableRule {
    public boolean validate(ERTable table) {
        HashSet<String> columnNameSet = new HashSet<String>();
        for (Column column : table.getColumns()) {
            if (column instanceof ColumnGroup) {
                ColumnGroup columnGroup = (ColumnGroup)column;
                for (NormalColumn normalColumn : columnGroup.getColumns()) {
                    String columnName = Format.null2blank(normalColumn.getPhysicalName()).toLowerCase();
                    if (columnNameSet.contains(columnName)) {
                        ValidateResult result = new ValidateResult();
                        result.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.column.name1")) + table.getPhysicalName() + ResourceString.getResourceString("error.validate.duplicated.column.name2") + columnName);
                        result.setLocation(table.getLogicalName());
                        result.setSeverity(1);
                        result.setObject(table);
                        this.addError(result);
                    }
                    columnNameSet.add(columnName);
                }
                continue;
            }
            if (!(column instanceof NormalColumn)) continue;
            NormalColumn normalColumn = (NormalColumn)column;
            String columnName = normalColumn.getPhysicalName();
            if (columnNameSet.contains(columnName)) {
                ValidateResult result = new ValidateResult();
                result.setMessage(String.valueOf(ResourceString.getResourceString("error.validate.duplicated.column.name1")) + table.getPhysicalName() + ResourceString.getResourceString("error.validate.duplicated.column.name2") + columnName);
                result.setLocation(table.getLogicalName());
                result.setSeverity(1);
                result.setObject(table);
                this.addError(result);
            }
            columnNameSet.add(columnName);
        }
        return true;
    }
}

