/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.excel.sheet_generator;

import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.dbexport.excel.ExportToExcelManager;
import org.insightech.er.editor.model.dbexport.excel.sheet_generator.AbstractSheetGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.util.Format;
import org.insightech.er.util.POIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSheetGenerator
extends AbstractSheetGenerator {
    private static final String KEYWORD_LOGICAL_INDEX_MATRIX = "$LIDX";
    private static final String KEYWORD_PHYSICAL_INDEX_MATRIX = "$PIDX";
    private static final String KEYWORD_LOGICAL_COMPLEX_UNIQUE_KEY_MATRIX = "$LCUK";
    private static final String KEYWORD_PHYSICAL_COMPLEX_UNIQUE_KEY_MATRIX = "$PCUK";
    private static final String KEYWORD_TABLE_CONSTRAINT = "$TCON";
    private static final String[] FIND_KEYWORDS_OF_FK_COLUMN = new String[]{"$LFKN", "$PFKN"};
    private AbstractSheetGenerator.ColumnTemplate columnTemplate;
    private AbstractSheetGenerator.ColumnTemplate fkColumnTemplate;
    private AbstractSheetGenerator.MatrixCellStyle physicalIndexMatrixCellStyle;
    private AbstractSheetGenerator.MatrixCellStyle logicalIndexMatrixCellStyle;
    private AbstractSheetGenerator.MatrixCellStyle physicalComplexUniqueKeyMatrixCellStyle;
    private AbstractSheetGenerator.MatrixCellStyle logicalComplexUniqueKeyMatrixCellStyle;

    protected void clear() {
        this.columnTemplate = null;
        this.fkColumnTemplate = null;
        this.physicalIndexMatrixCellStyle = null;
        this.logicalIndexMatrixCellStyle = null;
        this.physicalComplexUniqueKeyMatrixCellStyle = null;
        this.logicalComplexUniqueKeyMatrixCellStyle = null;
    }

    @Override
    public void generate(IProgressMonitor monitor, HSSFWorkbook workbook, int sheetNo, boolean useLogicalNameAsSheetName, Map<String, Integer> sheetNameMap, Map<String, ObjectModel> sheetObjectMap, ERDiagram diagram, Map<String, ExportToExcelManager.LoopDefinition> loopDefinitionMap) {
        this.clear();
        List<ERTable> nodeSet = null;
        nodeSet = diagram.getCurrentCategory() != null ? diagram.getCurrentCategory().getTableContents() : diagram.getDiagramContents().getContents().getTableSet().getList();
        for (ERTable table : nodeSet) {
            String name = null;
            name = useLogicalNameAsSheetName ? table.getLogicalName() : table.getPhysicalName();
            HSSFSheet newSheet = TableSheetGenerator.createNewSheet(workbook, sheetNo, name, sheetNameMap);
            sheetObjectMap.put(workbook.getSheetName(workbook.getSheetIndex((Sheet)newSheet)), table);
            this.setTableData(workbook, newSheet, table);
            monitor.worked(1);
        }
    }

    public void setTableData(HSSFWorkbook workbook, HSSFSheet sheet, ERTable table) {
        POIUtils.CellLocation fkCellLocation;
        POIUtils.replace(sheet, "$LTN", this.getValue(this.keywordsValueMap, "$LTN", table.getLogicalName()));
        POIUtils.replace(sheet, "$PTN", this.getValue(this.keywordsValueMap, "$PTN", table.getPhysicalName()));
        POIUtils.replace(sheet, "$TDSC", this.getValue(this.keywordsValueMap, "$TDSC", table.getDescription()));
        POIUtils.replace(sheet, KEYWORD_TABLE_CONSTRAINT, this.getValue(this.keywordsValueMap, KEYWORD_TABLE_CONSTRAINT, table.getConstraint()));
        POIUtils.CellLocation cellLocation = POIUtils.findCell(sheet, FIND_KEYWORDS_OF_COLUMN);
        if (cellLocation != null) {
            int rowNum = cellLocation.r;
            HSSFRow templateRow = sheet.getRow(rowNum);
            if (this.columnTemplate == null) {
                this.columnTemplate = this.loadColumnTemplate(workbook, sheet, cellLocation);
            }
            int order = 1;
            for (NormalColumn normalColumn : table.getExpandedColumns()) {
                HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
                this.setColumnData(this.keywordsValueMap, this.columnTemplate, row, normalColumn, table, order);
                ++order;
            }
            this.setCellStyle(this.columnTemplate, sheet, cellLocation.r, rowNum - cellLocation.r, templateRow.getFirstCellNum());
        }
        if ((fkCellLocation = POIUtils.findCell(sheet, FIND_KEYWORDS_OF_FK_COLUMN)) != null) {
            int rowNum = fkCellLocation.r;
            HSSFRow templateRow = sheet.getRow(rowNum);
            if (this.fkColumnTemplate == null) {
                this.fkColumnTemplate = this.loadColumnTemplate(workbook, sheet, fkCellLocation);
            }
            int order = 1;
            for (NormalColumn normalColumn : table.getExpandedColumns()) {
                if (!normalColumn.isForeignKey()) continue;
                HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
                this.setColumnData(this.keywordsValueMap, this.fkColumnTemplate, row, normalColumn, table, order);
                ++order;
            }
            this.setCellStyle(this.fkColumnTemplate, sheet, fkCellLocation.r, rowNum - fkCellLocation.r, templateRow.getFirstCellNum());
        }
        this.setIndexMatrix(workbook, sheet, table);
        this.setComplexUniqueKeyMatrix(workbook, sheet, table);
    }

    private void setIndexMatrix(HSSFWorkbook workbook, HSSFSheet sheet, ERTable table) {
        POIUtils.CellLocation physicalIndexCellLocation;
        POIUtils.CellLocation logicalIndexCellLocation = POIUtils.findCell(sheet, KEYWORD_LOGICAL_INDEX_MATRIX);
        if (logicalIndexCellLocation != null) {
            if (this.logicalIndexMatrixCellStyle == null) {
                this.logicalIndexMatrixCellStyle = this.createMatrixCellStyle(workbook, sheet, logicalIndexCellLocation);
            }
            this.setIndexMatrix(workbook, sheet, table, logicalIndexCellLocation, this.logicalIndexMatrixCellStyle, true);
        }
        if ((physicalIndexCellLocation = POIUtils.findCell(sheet, KEYWORD_PHYSICAL_INDEX_MATRIX)) != null) {
            if (this.physicalIndexMatrixCellStyle == null) {
                this.physicalIndexMatrixCellStyle = this.createMatrixCellStyle(workbook, sheet, physicalIndexCellLocation);
            }
            this.setIndexMatrix(workbook, sheet, table, physicalIndexCellLocation, this.physicalIndexMatrixCellStyle, false);
        }
    }

    private void setComplexUniqueKeyMatrix(HSSFWorkbook workbook, HSSFSheet sheet, ERTable table) {
        POIUtils.CellLocation physicalCellLocation;
        POIUtils.CellLocation logicalCellLocation = POIUtils.findCell(sheet, KEYWORD_LOGICAL_COMPLEX_UNIQUE_KEY_MATRIX);
        if (logicalCellLocation != null) {
            if (this.logicalComplexUniqueKeyMatrixCellStyle == null) {
                this.logicalComplexUniqueKeyMatrixCellStyle = this.createMatrixCellStyle(workbook, sheet, logicalCellLocation);
            }
            this.setComplexUniqueKeyMatrix(workbook, sheet, table, logicalCellLocation, this.logicalComplexUniqueKeyMatrixCellStyle, true);
        }
        if ((physicalCellLocation = POIUtils.findCell(sheet, KEYWORD_PHYSICAL_COMPLEX_UNIQUE_KEY_MATRIX)) != null) {
            if (this.physicalComplexUniqueKeyMatrixCellStyle == null) {
                this.physicalComplexUniqueKeyMatrixCellStyle = this.createMatrixCellStyle(workbook, sheet, physicalCellLocation);
            }
            this.setComplexUniqueKeyMatrix(workbook, sheet, table, physicalCellLocation, this.physicalComplexUniqueKeyMatrixCellStyle, false);
        }
    }

    private void setIndexMatrixColor(HSSFWorkbook workbook, HSSFCellStyle indexStyle) {
        indexStyle.setFillForegroundColor((short)9);
        HSSFFont font = workbook.getFontAt(indexStyle.getFontIndex());
        font.setColor((short)8);
    }

    private AbstractSheetGenerator.MatrixCellStyle createMatrixCellStyle(HSSFWorkbook workbook, HSSFSheet sheet, POIUtils.CellLocation matrixCellLocation) {
        int matrixRowNum = matrixCellLocation.r;
        int matrixColumnNum = matrixCellLocation.c;
        HSSFRow matrixHeaderTemplateRow = sheet.getRow(matrixRowNum);
        HSSFCell matrixHeaderTemplateCell = matrixHeaderTemplateRow.getCell(matrixColumnNum);
        AbstractSheetGenerator.MatrixCellStyle matrixCellStyle = new AbstractSheetGenerator.MatrixCellStyle();
        matrixCellStyle.headerTemplateCellStyle = matrixHeaderTemplateCell.getCellStyle();
        matrixCellStyle.style11 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, false, true, true, false);
        matrixCellStyle.style12 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, false, true, true, true);
        matrixCellStyle.style13 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, false, false, true, true);
        matrixCellStyle.style21 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, true, true, false);
        matrixCellStyle.style22 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, true, true, true);
        this.setIndexMatrixColor(workbook, matrixCellStyle.style22);
        matrixCellStyle.style23 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, false, true, true);
        this.setIndexMatrixColor(workbook, matrixCellStyle.style23);
        matrixCellStyle.style31 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, true, false, false);
        matrixCellStyle.style32 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, true, false, true);
        this.setIndexMatrixColor(workbook, matrixCellStyle.style32);
        matrixCellStyle.style33 = this.createMatrixCellStyle(workbook, matrixCellStyle.headerTemplateCellStyle, true, false, false, true);
        this.setIndexMatrixColor(workbook, matrixCellStyle.style33);
        return matrixCellStyle;
    }

    private HSSFCellStyle createMatrixCellStyle(HSSFWorkbook workbook, HSSFCellStyle matrixHeaderTemplateCellStyle, boolean top, boolean right, boolean bottom, boolean left) {
        HSSFCellStyle cellStyle = POIUtils.copyCellStyle(workbook, matrixHeaderTemplateCellStyle);
        if (top) {
            cellStyle.setBorderTop((short)1);
        }
        if (right) {
            cellStyle.setBorderRight((short)1);
        }
        if (bottom) {
            cellStyle.setBorderBottom((short)1);
        }
        if (left) {
            cellStyle.setBorderLeft((short)1);
        }
        return cellStyle;
    }

    private void setIndexMatrix(HSSFWorkbook workbook, HSSFSheet sheet, ERTable table, POIUtils.CellLocation cellLocation, AbstractSheetGenerator.MatrixCellStyle matrixCellStyle, boolean isLogical) {
        int rowNum = cellLocation.r;
        int columnNum = cellLocation.c;
        HSSFRow headerTemplateRow = sheet.getRow(rowNum);
        HSSFCell headerTemplateCell = headerTemplateRow.getCell(columnNum);
        int num = table.getIndexes().size();
        if (num == 0) {
            HSSFCell cell;
            headerTemplateRow.removeCell((Cell)headerTemplateCell);
            HSSFRow row = sheet.getRow(rowNum - 1);
            if (row != null && (cell = row.getCell(columnNum)) != null) {
                cell.getCellStyle().setBorderBottom(headerTemplateCell.getCellStyle().getBorderBottom());
            }
            return;
        }
        HSSFRow headerRow = sheet.createRow(rowNum++);
        int i = 0;
        while (i < num + 1) {
            HSSFCell cell = headerRow.createCell(columnNum + i);
            if (i == 0) {
                cell.setCellStyle(matrixCellStyle.style11);
            } else {
                Index index = table.getIndexes().get(i - 1);
                HSSFRichTextString text = new HSSFRichTextString(index.getName());
                cell.setCellValue((RichTextString)text);
                if (i != num) {
                    cell.setCellStyle(matrixCellStyle.style12);
                } else {
                    cell.setCellStyle(matrixCellStyle.style13);
                }
            }
            ++i;
        }
        int columnSize = table.getExpandedColumns().size();
        int j = 0;
        while (j < columnSize) {
            NormalColumn normalColumn = table.getExpandedColumns().get(j);
            HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
            int i2 = 0;
            while (i2 < num + 1) {
                HSSFCell cell = row.createCell(columnNum + i2);
                if (i2 == 0) {
                    String columnName = null;
                    columnName = isLogical ? normalColumn.getLogicalName() : normalColumn.getPhysicalName();
                    HSSFRichTextString text = new HSSFRichTextString(columnName);
                    cell.setCellValue((RichTextString)text);
                    cell.setCellStyle(headerTemplateCell.getCellStyle());
                    if (j != columnSize - 1) {
                        cell.setCellStyle(matrixCellStyle.style21);
                    } else {
                        cell.setCellStyle(matrixCellStyle.style31);
                    }
                } else {
                    Index index = table.getIndexes().get(i2 - 1);
                    List<NormalColumn> indexColumnList = index.getColumns();
                    int indexNo = indexColumnList.indexOf(normalColumn);
                    if (indexNo != -1) {
                        cell.setCellValue((double)(indexNo + 1));
                    }
                    if (i2 != num) {
                        if (j != columnSize - 1) {
                            cell.setCellStyle(matrixCellStyle.style22);
                        } else {
                            cell.setCellStyle(matrixCellStyle.style32);
                        }
                    } else if (j != columnSize - 1) {
                        cell.setCellStyle(matrixCellStyle.style23);
                    } else {
                        cell.setCellStyle(matrixCellStyle.style33);
                    }
                }
                ++i2;
            }
            ++j;
        }
    }

    private void setComplexUniqueKeyMatrix(HSSFWorkbook workbook, HSSFSheet sheet, ERTable table, POIUtils.CellLocation cellLocation, AbstractSheetGenerator.MatrixCellStyle matrixCellStyle, boolean isLogical) {
        int rowNum = cellLocation.r;
        int columnNum = cellLocation.c;
        HSSFRow headerTemplateRow = sheet.getRow(rowNum);
        HSSFCell headerTemplateCell = headerTemplateRow.getCell(columnNum);
        int num = table.getComplexUniqueKeyList().size();
        if (num == 0) {
            HSSFCell cell;
            headerTemplateRow.removeCell((Cell)headerTemplateCell);
            HSSFRow row = sheet.getRow(rowNum - 1);
            if (row != null && (cell = row.getCell(columnNum)) != null) {
                cell.getCellStyle().setBorderBottom(headerTemplateCell.getCellStyle().getBorderBottom());
            }
            return;
        }
        HSSFRow headerRow = sheet.createRow(rowNum++);
        int i = 0;
        while (i < num + 1) {
            HSSFCell cell = headerRow.createCell(columnNum + i);
            if (i == 0) {
                cell.setCellStyle(matrixCellStyle.style11);
            } else {
                ComplexUniqueKey complexUniqueKey = table.getComplexUniqueKeyList().get(i - 1);
                HSSFRichTextString text = new HSSFRichTextString(Format.null2blank(complexUniqueKey.getUniqueKeyName()));
                cell.setCellValue((RichTextString)text);
                if (i != num) {
                    cell.setCellStyle(matrixCellStyle.style12);
                } else {
                    cell.setCellStyle(matrixCellStyle.style13);
                }
            }
            ++i;
        }
        int columnSize = table.getExpandedColumns().size();
        int j = 0;
        while (j < columnSize) {
            NormalColumn normalColumn = table.getExpandedColumns().get(j);
            HSSFRow row = POIUtils.insertRow(sheet, rowNum++);
            int i2 = 0;
            while (i2 < num + 1) {
                HSSFCell cell = row.createCell(columnNum + i2);
                if (i2 == 0) {
                    String columnName = null;
                    columnName = isLogical ? normalColumn.getLogicalName() : normalColumn.getPhysicalName();
                    HSSFRichTextString text = new HSSFRichTextString(columnName);
                    cell.setCellValue((RichTextString)text);
                    cell.setCellStyle(headerTemplateCell.getCellStyle());
                    if (j != columnSize - 1) {
                        cell.setCellStyle(matrixCellStyle.style21);
                    } else {
                        cell.setCellStyle(matrixCellStyle.style31);
                    }
                } else {
                    ComplexUniqueKey complexUniqueKey = table.getComplexUniqueKeyList().get(i2 - 1);
                    List<NormalColumn> targetColumnList = complexUniqueKey.getColumnList();
                    int indexNo = targetColumnList.indexOf(normalColumn);
                    if (indexNo != -1) {
                        cell.setCellValue((double)(indexNo + 1));
                    }
                    if (i2 != num) {
                        if (j != columnSize - 1) {
                            cell.setCellStyle(matrixCellStyle.style22);
                        } else {
                            cell.setCellStyle(matrixCellStyle.style32);
                        }
                    } else if (j != columnSize - 1) {
                        cell.setCellStyle(matrixCellStyle.style23);
                    } else {
                        cell.setCellStyle(matrixCellStyle.style33);
                    }
                }
                ++i2;
            }
            ++j;
        }
    }

    @Override
    public String getTemplateSheetName() {
        return "table_template";
    }

    @Override
    public String[] getKeywords() {
        return new String[]{"$LTN", "$PTN", "$TDSC", KEYWORD_TABLE_CONSTRAINT, "$ORD", "$LCN", "$PCN", "$TYP", "$LEN", "$DEC", "$PK", "$NN", "$UK", "$FK", "$LRFTC", "$PRFTC", "$LRFT", "$PRFT", "$LRFC", "$PRFC", "$INC", "$DEF", "$CDSC", KEYWORD_LOGICAL_INDEX_MATRIX, KEYWORD_PHYSICAL_INDEX_MATRIX, "$LFKN", "$PFKN"};
    }

    @Override
    public int getKeywordsColumnNo() {
        return 0;
    }

    @Override
    public int count(ERDiagram diagram) {
        return diagram.getDiagramContents().getContents().getTableSet().getList().size();
    }
}

