/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbimport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.insightech.er.editor.model.dbimport.DBObject;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectSet
implements Serializable {
    private static final long serialVersionUID = 5632573903492090359L;
    private Map<String, List<DBObject>> schemaDbObjectListMap = new TreeMap<String, List<DBObject>>();
    private List<DBObject> tablespaceList = new ArrayList<DBObject>();
    private List<DBObject> noteList = new ArrayList<DBObject>();
    private List<DBObject> groupList = new ArrayList<DBObject>();

    public Map<String, List<DBObject>> getSchemaDbObjectListMap() {
        return this.schemaDbObjectListMap;
    }

    public List<DBObject> getTablespaceList() {
        return this.tablespaceList;
    }

    public List<DBObject> getNoteList() {
        return this.noteList;
    }

    public List<DBObject> getGroupList() {
        return this.groupList;
    }

    public void addAll(List<DBObject> dbObjectList) {
        for (DBObject dbObject : dbObjectList) {
            this.add(dbObject);
        }
    }

    public void add(DBObject dbObject) {
        if ("tablespace".equals(dbObject.getType())) {
            this.tablespaceList.add(dbObject);
        } else if ("note".equals(dbObject.getType())) {
            this.noteList.add(dbObject);
        } else if ("group".equals(dbObject.getType())) {
            this.groupList.add(dbObject);
        } else {
            String schema = Format.null2blank(dbObject.getSchema());
            List<DBObject> dbObjectList = this.schemaDbObjectListMap.get(schema);
            if (dbObjectList == null) {
                dbObjectList = new ArrayList<DBObject>();
                this.schemaDbObjectListMap.put(schema, dbObjectList);
            }
            dbObjectList.add(dbObject);
        }
    }
}

