/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.node.table;

import java.util.ArrayList;
import java.util.List;
import org.insightech.er.ResourceString;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.ObjectModel;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.ColumnHolder;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.CopyIndex;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableProperties;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TablePropertiesHolder;
import org.insightech.er.editor.model.diagram_contents.element.node.table.properties.TableViewProperties;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.CopyComplexUniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERTable
extends TableView
implements TablePropertiesHolder,
ColumnHolder,
ObjectModel {
    private static final long serialVersionUID = 11185865758118654L;
    public static final String NEW_PHYSICAL_NAME = ResourceString.getResourceString("new.table.physical.name");
    public static final String NEW_LOGICAL_NAME = ResourceString.getResourceString("new.table.logical.name");
    private String constraint;
    private String primaryKeyName;
    private String option;
    private List<Index> indexes = new ArrayList<Index>();
    private List<ComplexUniqueKey> complexUniqueKeyList = new ArrayList<ComplexUniqueKey>();

    public NormalColumn getAutoIncrementColumn() {
        for (Column column : this.columns) {
            NormalColumn normalColumn;
            if (!(column instanceof NormalColumn) || !(normalColumn = (NormalColumn)column).isAutoIncrement()) continue;
            return normalColumn;
        }
        return null;
    }

    @Override
    public TableViewProperties getTableViewProperties() {
        this.tableViewProperties = DBManagerFactory.getDBManager(this.getDiagram()).createTableProperties((TableProperties)this.tableViewProperties);
        return this.tableViewProperties;
    }

    public TableViewProperties getTableViewProperties(String database) {
        this.tableViewProperties = DBManagerFactory.getDBManager(database).createTableProperties((TableProperties)this.tableViewProperties);
        return this.tableViewProperties;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    @Override
    public ERTable copyData() {
        ERTable to = new ERTable();
        to.setConstraint(this.getConstraint());
        to.setPrimaryKeyName(this.getPrimaryKeyName());
        to.setOption(this.getOption());
        super.copyTableViewData(to);
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (Index fromIndex : this.getIndexes()) {
            indexes.add(new CopyIndex(to, fromIndex, to.getColumns()));
        }
        to.setIndexes(indexes);
        ArrayList<ComplexUniqueKey> complexUniqueKeyList = new ArrayList<ComplexUniqueKey>();
        for (ComplexUniqueKey complexUniqueKey : this.getComplexUniqueKeyList()) {
            complexUniqueKeyList.add(new CopyComplexUniqueKey(complexUniqueKey, to.getColumns()));
        }
        to.complexUniqueKeyList = complexUniqueKeyList;
        to.tableViewProperties = (TableProperties)this.getTableViewProperties().clone();
        return to;
    }

    @Override
    public void restructureData(TableView to) {
        ERTable table = (ERTable)to;
        table.setConstraint(this.getConstraint());
        table.setPrimaryKeyName(this.getPrimaryKeyName());
        table.setOption(this.getOption());
        super.restructureData(to);
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (Index fromIndex : this.getIndexes()) {
            CopyIndex copyIndex = (CopyIndex)fromIndex;
            Index restructuredIndex = copyIndex.getRestructuredIndex(table);
            indexes.add(restructuredIndex);
        }
        table.setIndexes(indexes);
        ArrayList<ComplexUniqueKey> complexUniqueKeyList = new ArrayList<ComplexUniqueKey>();
        for (ComplexUniqueKey complexUniqueKey : this.getComplexUniqueKeyList()) {
            CopyComplexUniqueKey copyComplexUniqueKey = (CopyComplexUniqueKey)complexUniqueKey;
            if (copyComplexUniqueKey.isRemoved(this.getNormalColumns())) continue;
            ComplexUniqueKey restructuredComplexUniqueKey = copyComplexUniqueKey.restructure();
            complexUniqueKeyList.add(restructuredComplexUniqueKey);
        }
        table.complexUniqueKeyList = complexUniqueKeyList;
        table.tableViewProperties = (TableProperties)this.tableViewProperties.clone();
    }

    public int getPrimaryKeySize() {
        int count = 0;
        for (Column column : this.columns) {
            NormalColumn normalColumn;
            if (!(column instanceof NormalColumn) || !(normalColumn = (NormalColumn)column).isPrimaryKey()) continue;
            ++count;
        }
        return count;
    }

    public List<NormalColumn> getPrimaryKeys() {
        ArrayList<NormalColumn> primaryKeys = new ArrayList<NormalColumn>();
        for (Column column : this.columns) {
            NormalColumn normalColumn;
            if (!(column instanceof NormalColumn) || !(normalColumn = (NormalColumn)column).isPrimaryKey()) continue;
            primaryKeys.add(normalColumn);
        }
        return primaryKeys;
    }

    public boolean isReferable() {
        if (this.getPrimaryKeySize() > 0) {
            return true;
        }
        if (this.complexUniqueKeyList.size() > 0) {
            return true;
        }
        for (Column column : this.columns) {
            NormalColumn normalColumn;
            if (!(column instanceof NormalColumn) || !(normalColumn = (NormalColumn)column).isUniqueKey()) continue;
            return true;
        }
        return false;
    }

    public Index getIndex(int index) {
        return this.indexes.get(index);
    }

    public void removeIndex(int index) {
        this.indexes.remove(index);
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> indexes) {
        this.indexes = indexes;
        if (this.getDiagram() != null) {
            this.firePropertyChange("indexes", null, null);
            this.getDiagram().getDiagramContents().getIndexSet().update();
        }
    }

    public void setComplexUniqueKeyList(List<ComplexUniqueKey> complexUniqueKeyList) {
        this.complexUniqueKeyList = complexUniqueKeyList;
    }

    public List<ComplexUniqueKey> getComplexUniqueKeyList() {
        return this.complexUniqueKeyList;
    }

    public void setTableViewProperties(TableProperties tableProperties) {
        this.tableViewProperties = tableProperties;
    }

    @Override
    public ERTable clone() {
        ERTable clone = (ERTable)super.clone();
        TableProperties cloneTableProperties = (TableProperties)this.getTableViewProperties().clone();
        clone.tableViewProperties = cloneTableProperties;
        return clone;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public void setConstraint(String constraint) {
        this.constraint = constraint;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public static boolean isRecursive(TableView source, TableView target) {
        for (Relation relation : source.getIncomingRelations()) {
            TableView temp = relation.getSourceTableView();
            if (temp.equals(source)) continue;
            if (temp.equals(target)) {
                return true;
            }
            if (!ERTable.isRecursive(temp, target)) continue;
            return true;
        }
        return false;
    }

    public Relation createRelation() {
        boolean referenceForPK = false;
        ComplexUniqueKey referencedComplexUniqueKey = null;
        NormalColumn referencedColumn = null;
        if (this.getPrimaryKeySize() > 0) {
            referenceForPK = true;
        } else if (this.getComplexUniqueKeyList().size() > 0) {
            referencedComplexUniqueKey = this.getComplexUniqueKeyList().get(0);
        } else {
            for (NormalColumn normalColumn : this.getNormalColumns()) {
                if (!normalColumn.isUniqueKey()) continue;
                referencedColumn = normalColumn;
                break;
            }
        }
        return new Relation(referenceForPK, referencedComplexUniqueKey, referencedColumn);
    }

    @Override
    public String getObjectType() {
        return "table";
    }
}

