/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.dbimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.model.AbstractModel;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbimport.DBObject;
import org.insightech.er.editor.model.dbimport.DBObjectSet;
import org.insightech.er.editor.model.diagram_contents.DiagramContents;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.diagram_contents.element.node.note.Note;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.UniqueWord;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.Word;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.SequenceSet;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.Tablespace;
import org.insightech.er.editor.model.diagram_contents.not_element.tablespace.TablespaceSet;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.Trigger;
import org.insightech.er.editor.model.diagram_contents.not_element.trigger.TriggerSet;
import org.insightech.er.editor.model.edit.CopyManager;
import org.insightech.er.editor.persistent.Persistent;
import org.insightech.er.editor.view.action.dbimport.AbstractImportAction;
import org.insightech.er.editor.view.dialog.dbimport.AbstractSelectImportedObjectDialog;
import org.insightech.er.editor.view.dialog.dbimport.SelectImportedObjectFromFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFromFileAction
extends AbstractImportAction {
    public static final String ID = ImportFromFileAction.class.getName();
    private ERDiagram loadedDiagram;

    public ImportFromFileAction(ERDiagramEditor editor) {
        super(ID, ResourceString.getResourceString("action.title.import.file"), editor);
        this.setImageDescriptor(Activator.getImageDescriptor("TABLE"));
    }

    protected DBObjectSet preImport() throws Exception {
        String fileName = this.getLoadFilePath((IEditorPart)this.getEditorPart());
        if (fileName == null) {
            return null;
        }
        Persistent persistent = Persistent.getInstance();
        Path path = new Path(fileName);
        InputStream in = null;
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file == null || !file.exists()) {
                File realFile = path.toFile();
                if (realFile == null || !realFile.exists()) {
                    Activator.showErrorDialog("error.import.file");
                    return null;
                }
                in = new FileInputStream(realFile);
            } else {
                if (!file.isSynchronized(1)) {
                    file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
                in = file.getContents();
            }
            this.loadedDiagram = persistent.load(in);
        }
        finally {
            in.close();
        }
        return this.getAllObjects(this.loadedDiagram);
    }

    protected AbstractSelectImportedObjectDialog createSelectImportedObjectDialog(DBObjectSet dbObjectSet) {
        ERDiagram diagram = this.getDiagram();
        return new SelectImportedObjectFromFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), diagram, dbObjectSet);
    }

    protected String getLoadFilePath(IEditorPart editorPart) {
        IFile file = ((IFileEditorInput)editorPart.getEditorInput()).getFile();
        FileDialog fileDialog = new FileDialog(editorPart.getEditorSite().getShell(), 4096);
        IProject project = file.getProject();
        fileDialog.setFilterPath(project.getLocation().toString());
        String[] filterExtensions = this.getFilterExtensions();
        fileDialog.setFilterExtensions(filterExtensions);
        return fileDialog.open();
    }

    protected String[] getFilterExtensions() {
        return new String[]{"*.erm"};
    }

    private DBObjectSet getAllObjects(ERDiagram loadedDiagram) {
        DBObject dbObject;
        DBObjectSet dbObjects = new DBObjectSet();
        for (ERTable table : loadedDiagram.getDiagramContents().getContents().getTableSet()) {
            dbObject = new DBObject(table.getTableViewProperties().getSchema(), table.getName(), "table");
            dbObject.setModel(table);
            dbObjects.add(dbObject);
        }
        for (View view : loadedDiagram.getDiagramContents().getContents().getViewSet()) {
            dbObject = new DBObject(view.getTableViewProperties().getSchema(), view.getName(), "view");
            dbObject.setModel(view);
            dbObjects.add(dbObject);
        }
        for (Note note : loadedDiagram.getDiagramContents().getContents().getNoteSet()) {
            dbObject = new DBObject(null, note.getName(), "note");
            dbObject.setModel(note);
            dbObjects.add(dbObject);
        }
        for (Sequence sequence : loadedDiagram.getDiagramContents().getSequenceSet()) {
            dbObject = new DBObject(sequence.getSchema(), sequence.getName(), "sequence");
            dbObject.setModel(sequence);
            dbObjects.add(dbObject);
        }
        for (Trigger trigger : loadedDiagram.getDiagramContents().getTriggerSet()) {
            dbObject = new DBObject(trigger.getSchema(), trigger.getName(), "trigger");
            dbObject.setModel(trigger);
            dbObjects.add(dbObject);
        }
        for (Tablespace tablespace : loadedDiagram.getDiagramContents().getTablespaceSet()) {
            dbObject = new DBObject(null, tablespace.getName(), "tablespace");
            dbObject.setModel(tablespace);
            dbObjects.add(dbObject);
        }
        for (ColumnGroup columnGroup : loadedDiagram.getDiagramContents().getGroups()) {
            dbObject = new DBObject(null, columnGroup.getName(), "group");
            dbObject.setModel(columnGroup);
            dbObjects.add(dbObject);
        }
        return dbObjects;
    }

    protected void loadData(List<DBObject> selectedObjectList, boolean useCommentAsLogicalName, boolean mergeWord, boolean mergeGroup) {
        Object tableView;
        HashSet<AbstractModel> selectedSets = new HashSet<AbstractModel>();
        for (DBObject dbObject : selectedObjectList) {
            selectedSets.add(dbObject.getModel());
        }
        DiagramContents contents = this.loadedDiagram.getDiagramContents();
        GroupSet columnGroupSet = contents.getGroups();
        Iterator<ColumnGroup> iter = columnGroupSet.iterator();
        while (iter.hasNext()) {
            ColumnGroup columnGroup = iter.next();
            if (selectedSets.contains(columnGroup)) continue;
            iter.remove();
        }
        this.importedColumnGroups = columnGroupSet.getGroupList();
        SequenceSet sequenceSet = contents.getSequenceSet();
        Iterator<Sequence> iter2 = sequenceSet.iterator();
        while (iter2.hasNext()) {
            Sequence sequence = iter2.next();
            if (selectedSets.contains(sequence)) continue;
            iter2.remove();
        }
        this.importedSequences = sequenceSet.getSequenceList();
        TriggerSet triggerSet = contents.getTriggerSet();
        Iterator<Trigger> iter3 = triggerSet.iterator();
        while (iter3.hasNext()) {
            Trigger trigger = iter3.next();
            if (selectedSets.contains(trigger)) continue;
            iter3.remove();
        }
        this.importedTriggers = triggerSet.getTriggerList();
        TablespaceSet tablespaceSet = contents.getTablespaceSet();
        Iterator<Tablespace> iter4 = tablespaceSet.iterator();
        while (iter4.hasNext()) {
            Tablespace tablespace = iter4.next();
            if (selectedSets.contains(tablespace)) continue;
            iter4.remove();
        }
        this.importedTablespaces = tablespaceSet.getTablespaceList();
        NodeSet nodeSet = contents.getContents();
        List<NodeElement> nodeElementList = nodeSet.getNodeElementList();
        Iterator<NodeElement> iter5 = nodeElementList.iterator();
        while (iter5.hasNext()) {
            NodeElement nodeElement = iter5.next();
            if (selectedSets.contains(nodeElement)) continue;
            iter5.remove();
        }
        NodeSet selectedNodeSet = new NodeSet();
        HashMap<UniqueWord, Word> dictionary = new HashMap<UniqueWord, Word>();
        if (mergeWord) {
            for (Word word : this.getDiagram().getDiagramContents().getDictionary().getWordList()) {
                dictionary.put(new UniqueWord(word), word);
            }
        }
        for (NodeElement nodeElement : nodeElementList) {
            if (mergeWord && nodeElement instanceof TableView) {
                tableView = (TableView)nodeElement;
                for (NormalColumn normalColumn : ((TableView)tableView).getNormalColumns()) {
                    UniqueWord uniqueWord;
                    Word replaceWord;
                    Word word = normalColumn.getWord();
                    if (word == null || (replaceWord = (Word)dictionary.get(uniqueWord = new UniqueWord(word))) == null) continue;
                    normalColumn.setWord(replaceWord);
                }
            }
            selectedNodeSet.addNodeElement(nodeElement);
        }
        for (NodeElement nodeElement : selectedNodeSet) {
            if (!(nodeElement instanceof TableView)) continue;
            tableView = (TableView)nodeElement;
            Iterator<Column> iter6 = ((TableView)tableView).getColumns().iterator();
            while (iter6.hasNext()) {
                Column column = iter6.next();
                if (!(column instanceof ColumnGroup) || this.importedColumnGroups.contains(column)) continue;
                iter6.remove();
            }
        }
        if (mergeGroup) {
            HashMap<String, ColumnGroup> groupMap = new HashMap<String, ColumnGroup>();
            for (ColumnGroup columnGroup : this.getDiagram().getDiagramContents().getGroups()) {
                groupMap.put(columnGroup.getGroupName(), columnGroup);
            }
            Iterator iter7 = this.importedColumnGroups.iterator();
            while (iter7.hasNext()) {
                ColumnGroup columnGroup = (ColumnGroup)iter7.next();
                ColumnGroup replaceColumnGroup = (ColumnGroup)groupMap.get(columnGroup.getGroupName());
                if (replaceColumnGroup == null) continue;
                iter7.remove();
                for (NodeElement nodeElement : selectedNodeSet) {
                    if (!(nodeElement instanceof TableView)) continue;
                    TableView tableView2 = (TableView)nodeElement;
                    tableView2.replaceColumnGroup(columnGroup, replaceColumnGroup);
                }
            }
        }
        CopyManager copyManager = new CopyManager();
        NodeSet copyList = copyManager.copyNodeElementList(selectedNodeSet);
        this.importedNodeElements = copyList.getNodeElementList();
    }

    @Override
    public void execute(Event event) throws Exception {
        DBObjectSet dbObjectSet = this.preImport();
        if (dbObjectSet != null) {
            AbstractSelectImportedObjectDialog importDialog = this.createSelectImportedObjectDialog(dbObjectSet);
            int result = importDialog.open();
            if (result == 0) {
                this.loadData(importDialog.getSelectedDbObjects(), importDialog.isUseCommentAsLogicalName(), importDialog.isMergeWord(), importDialog.isMergeGroup());
                this.showData();
            } else if (result == 14) {
                this.execute(event);
            }
        }
    }
}

