/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.contributor;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.ERDiagramMultiPageEditor;
import org.insightech.er.editor.model.ViewableModel;

public abstract class ComboContributionItem
extends ContributionItem {
    private Combo combo;
    private ToolItem toolitem;
    private IWorkbenchPage workbenchPage;

    public ComboContributionItem(String id, IWorkbenchPage workbenchPage) {
        super(id);
        this.workbenchPage = workbenchPage;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 12);
        this.setData(this.combo);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List selectedEditParts = ((IStructuredSelection)ComboContributionItem.this.workbenchPage.getSelection()).toList();
                CompoundCommand compoundCommand = new CompoundCommand();
                for (Object editPart : selectedEditParts) {
                    ViewableModel viewableModel;
                    Command command;
                    Object model = ((EditPart)editPart).getModel();
                    if (!(model instanceof ViewableModel) || (command = ComboContributionItem.this.createCommand(viewableModel = (ViewableModel)model)) == null) continue;
                    compoundCommand.add(command);
                }
                if (!compoundCommand.getCommands().isEmpty()) {
                    ComboContributionItem.this.executeCommand((Command)compoundCommand);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.toolitem.setWidth(this.computeWidth((Control)this.combo));
        return this.combo;
    }

    protected abstract Command createCommand(ViewableModel var1);

    private int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    protected abstract void setData(Combo var1);

    private void executeCommand(Command command) {
        ERDiagramMultiPageEditor multiPageEditor = (ERDiagramMultiPageEditor)this.workbenchPage.getActiveEditor();
        ERDiagramEditor editor = (ERDiagramEditor)multiPageEditor.getActiveEditor();
        editor.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
    }

    public void setText(String text) {
        if (this.combo != null && !this.combo.isDisposed() && text != null) {
            this.combo.setText(text);
        }
    }

    public String getText() {
        return this.combo.getText();
    }
}

