/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.contributor;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.AlignmentRetargetAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.MatchHeightRetargetAction;
import org.eclipse.gef.ui.actions.MatchWidthRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.ViewableModel;
import org.insightech.er.editor.view.action.dbexport.ExportToDBAction;
import org.insightech.er.editor.view.action.edit.ChangeBackgroundColorAction;
import org.insightech.er.editor.view.action.line.HorizontalLineAction;
import org.insightech.er.editor.view.action.line.VerticalLineAction;
import org.insightech.er.editor.view.action.option.notation.LockEditAction;
import org.insightech.er.editor.view.action.option.notation.TooltipAction;
import org.insightech.er.editor.view.action.zoom.ZoomAdjustAction;
import org.insightech.er.editor.view.action.zoom.ZoomAdjustRetargetAction;
import org.insightech.er.editor.view.contributor.FontNameContributionItem;
import org.insightech.er.editor.view.contributor.FontSizeContributionItem;

public class ERDiagramActionBarContributor
extends ActionBarContributor {
    private ZoomComboContributionItem zoomComboContributionItem;

    public ERDiagramActionBarContributor(ZoomComboContributionItem zoomComboContributionItem) {
        this.zoomComboContributionItem = zoomComboContributionItem;
    }

    protected void buildActions() {
        this.addRetargetAction(new RetargetAction(ActionFactory.SELECT_ALL.getId(), "selectAll"));
        this.addRetargetAction(new RetargetAction(ActionFactory.PRINT.getId(), "print"));
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction(new RetargetAction(ActionFactory.COPY.getId(), "copy"));
        this.addRetargetAction(new RetargetAction(ActionFactory.PASTE.getId(), "paste"));
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        ZoomInRetargetAction zoomInAction = new ZoomInRetargetAction();
        zoomInAction.setImageDescriptor(Activator.getImageDescriptor("ZOOM_IN"));
        ZoomOutRetargetAction zoomOutAction = new ZoomOutRetargetAction();
        zoomOutAction.setImageDescriptor(Activator.getImageDescriptor("ZOOM_OUT"));
        this.addRetargetAction((RetargetAction)zoomInAction);
        this.addRetargetAction((RetargetAction)zoomOutAction);
        this.addRetargetAction(new ZoomAdjustRetargetAction());
        RetargetAction gridAction = new RetargetAction("org.eclipse.gef.toggle_grid_visibility", ResourceString.getResourceString("action.title.grid"), 2);
        gridAction.setImageDescriptor(Activator.getImageDescriptor("GRID"));
        this.addRetargetAction(gridAction);
        RetargetAction tooltipAction = new RetargetAction(TooltipAction.ID, ResourceString.getResourceString("action.title.tooltip"), 2);
        tooltipAction.setImageDescriptor(Activator.getImageDescriptor("TOOLTIP"));
        this.addRetargetAction(tooltipAction);
        RetargetAction lockEditAction = new RetargetAction(LockEditAction.ID, ResourceString.getResourceString("action.title.lock.edit"), 2);
        lockEditAction.setImageDescriptor(Activator.getImageDescriptor("LOCK_EDIT"));
        this.addRetargetAction(lockEditAction);
        this.addRetargetAction(new ExportToDBAction.ExportToDBRetargetAction());
        AlignmentRetargetAction alignLeftAction = new AlignmentRetargetAction(1);
        alignLeftAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_LEFT"));
        alignLeftAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignLeftAction);
        AlignmentRetargetAction alignCenterAction = new AlignmentRetargetAction(2);
        alignCenterAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_CENTER"));
        alignCenterAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignCenterAction);
        AlignmentRetargetAction alignRightAction = new AlignmentRetargetAction(4);
        alignRightAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_RIGHT"));
        alignRightAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignRightAction);
        AlignmentRetargetAction alignTopAction = new AlignmentRetargetAction(8);
        alignTopAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_TOP"));
        alignTopAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignTopAction);
        AlignmentRetargetAction alignMiddleAction = new AlignmentRetargetAction(16);
        alignMiddleAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_MIDDLE"));
        alignMiddleAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignMiddleAction);
        AlignmentRetargetAction alignBottomAction = new AlignmentRetargetAction(32);
        alignBottomAction.setImageDescriptor(Activator.getImageDescriptor("ALIGN_BOTTOM"));
        alignBottomAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)alignBottomAction);
        MatchWidthRetargetAction matchWidthAction = new MatchWidthRetargetAction();
        matchWidthAction.setImageDescriptor(Activator.getImageDescriptor("MATCH_WIDTH"));
        matchWidthAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)matchWidthAction);
        MatchHeightRetargetAction matchHeightAction = new MatchHeightRetargetAction();
        matchHeightAction.setImageDescriptor(Activator.getImageDescriptor("MATCH_HEIGHT"));
        matchHeightAction.setDisabledImageDescriptor(null);
        this.addRetargetAction((RetargetAction)matchHeightAction);
        this.addRetargetAction((RetargetAction)new HorizontalLineAction.HorizontalLineRetargetAction());
        this.addRetargetAction((RetargetAction)new VerticalLineAction.VerticalLineRetargetAction());
        this.addRetargetAction((RetargetAction)new ChangeBackgroundColorAction.ChangeBackgroundColorRetargetAction());
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add(this.getAction(ActionFactory.DELETE.getId()));
        toolBarManager.add(this.getAction(ActionFactory.UNDO.getId()));
        toolBarManager.add(this.getAction(ActionFactory.REDO.getId()));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ZoomAdjustAction.ID));
        toolBarManager.add((IContributionItem)this.zoomComboContributionItem);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction("org.eclipse.gef.toggle_grid_visibility"));
        toolBarManager.add(this.getAction(TooltipAction.ID));
        toolBarManager.add(this.getAction(LockEditAction.ID));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getAction(ExportToDBAction.ID));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_left"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_center"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_right"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_top"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_middle"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_bottom"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.match.width"));
        toolBarManager.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.match.height"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.getActionRegistry().getAction((Object)HorizontalLineAction.ID));
        toolBarManager.add(this.getActionRegistry().getAction((Object)VerticalLineAction.ID));
        toolBarManager.add(this.getActionRegistry().getAction((Object)ChangeBackgroundColorAction.ID));
        toolBarManager.add((IContributionItem)new Separator());
        final FontNameContributionItem fontNameContributionItem = new FontNameContributionItem(this.getPage());
        final FontSizeContributionItem fontSizeContributionItem = new FontSizeContributionItem(this.getPage());
        toolBarManager.add((IContributionItem)fontNameContributionItem);
        toolBarManager.add((IContributionItem)fontSizeContributionItem);
        this.getPage().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object model;
                List selectedEditParts;
                if (selection instanceof IStructuredSelection && !(selectedEditParts = ((IStructuredSelection)selection).toList()).isEmpty() && selectedEditParts.get(0) instanceof EditPart && (model = ((EditPart)selectedEditParts.get(0)).getModel()) instanceof ViewableModel) {
                    ViewableModel viewableModel = (ViewableModel)model;
                    String fontName = viewableModel.getFontName();
                    int fontSize = viewableModel.getFontSize();
                    if (fontName != null) {
                        fontNameContributionItem.setText(fontName);
                    } else {
                        FontData fonData = Display.getCurrent().getSystemFont().getFontData()[0];
                        fontNameContributionItem.setText(fonData.getName());
                        viewableModel.setFontName(fonData.getName());
                    }
                    if (fontSize > 0) {
                        fontSizeContributionItem.setText(String.valueOf(fontSize));
                    } else {
                        fontSizeContributionItem.setText(String.valueOf(9));
                        viewableModel.setFontSize(fontSize);
                    }
                }
            }
        });
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey("print.ext");
    }
}

