/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;
import org.insightech.er.editor.model.settings.CategorySetting;
import org.insightech.er.editor.model.settings.Settings;

public class CategoryManageDialog
extends AbstractDialog {
    private Table categoryTable = null;
    private Table nodeTable = null;
    private Button addCategoryButton;
    private Button updateCategoryButton;
    private Button deleteCategoryButton;
    private Text categoryNameText = null;
    private ERDiagram diagram;
    private CategorySetting categorySettings;
    private Map<Category, TableEditor> categoryCheckMap;
    private Map<NodeElement, TableEditor> nodeCheckMap;
    private Category targetCategory;
    private Button upButton;
    private Button downButton;

    public CategoryManageDialog(Shell parentShell, Settings settings, ERDiagram diagram) {
        super(parentShell, 2);
        this.diagram = diagram;
        this.categorySettings = settings.getCategorySetting();
    }

    protected void initialize(Composite composite) {
        this.createCategoryGroup(composite);
        this.createNodeGroup(composite);
    }

    private void createCategoryGroup(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group group = new Group(composite, 0);
        group.setText(ResourceString.getResourceString("label.category.message"));
        group.setLayout((Layout)gridLayout);
        CompositeFactory.filler((Composite)group, 4);
        GridData tableGridData = new GridData();
        tableGridData.heightHint = 200;
        tableGridData.horizontalSpan = 3;
        tableGridData.verticalSpan = 2;
        this.categoryTable = new Table((Composite)group, 67584);
        this.categoryTable.setHeaderVisible(true);
        this.categoryTable.setLayoutData((Object)tableGridData);
        this.categoryTable.setLinesVisible(true);
        GridData upButtonGridData = new GridData();
        upButtonGridData.grabExcessHorizontalSpace = false;
        upButtonGridData.verticalAlignment = 3;
        upButtonGridData.grabExcessVerticalSpace = true;
        upButtonGridData.widthHint = 60;
        GridData downButtonGridData = new GridData();
        downButtonGridData.grabExcessVerticalSpace = true;
        downButtonGridData.verticalAlignment = 1;
        downButtonGridData.widthHint = 60;
        this.upButton = new Button((Composite)group, 0);
        this.upButton.setText(ResourceString.getResourceString("label.up.arrow"));
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button((Composite)group, 0);
        this.downButton.setText(ResourceString.getResourceString("label.down.arrow"));
        this.downButton.setLayoutData((Object)downButtonGridData);
        GridData textGridData = new GridData();
        textGridData.widthHint = 150;
        this.categoryNameText = new Text((Composite)group, 2048);
        this.categoryNameText.setLayoutData((Object)textGridData);
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 60;
        this.addCategoryButton = new Button((Composite)group, 0);
        this.addCategoryButton.setLayoutData((Object)buttonGridData);
        this.addCategoryButton.setText(ResourceString.getResourceString("label.button.add"));
        this.updateCategoryButton = new Button((Composite)group, 0);
        this.updateCategoryButton.setLayoutData((Object)buttonGridData);
        this.updateCategoryButton.setText(ResourceString.getResourceString("label.button.update"));
        this.deleteCategoryButton = new Button((Composite)group, 0);
        this.deleteCategoryButton.setLayoutData((Object)buttonGridData);
        this.deleteCategoryButton.setText(ResourceString.getResourceString("label.button.delete"));
        TableColumn tableColumn = new TableColumn(this.categoryTable, 0);
        tableColumn.setWidth(30);
        tableColumn.setResizable(false);
        TableColumn tableColumn1 = new TableColumn(this.categoryTable, 0);
        tableColumn1.setWidth(230);
        tableColumn1.setResizable(false);
        tableColumn1.setText(ResourceString.getResourceString("label.category.name"));
    }

    private void createNodeGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(ResourceString.getResourceString("label.category.object.message"));
        GridData gridData1 = new GridData();
        gridData1.heightHint = 15;
        Label label = new Label((Composite)group, 0);
        label.setText("");
        label.setLayoutData((Object)gridData1);
        GridData tableGridData = new GridData();
        tableGridData.heightHint = 200;
        this.nodeTable = new Table((Composite)group, 34816);
        this.nodeTable.setHeaderVisible(true);
        this.nodeTable.setLayoutData((Object)tableGridData);
        this.nodeTable.setLinesVisible(true);
        GridData gridData2 = new GridData();
        gridData2.heightHint = 22;
        label = new Label((Composite)group, 0);
        label.setText("");
        label.setLayoutData((Object)gridData2);
        TableColumn tableColumn2 = new TableColumn(this.nodeTable, 0);
        tableColumn2.setWidth(30);
        tableColumn2.setResizable(false);
        tableColumn2.setText("");
        TableColumn tableColumn3 = new TableColumn(this.nodeTable, 0);
        tableColumn3.setWidth(80);
        tableColumn3.setResizable(false);
        tableColumn3.setText(ResourceString.getResourceString("label.object.type"));
        TableColumn tableColumn4 = new TableColumn(this.nodeTable, 0);
        tableColumn4.setWidth(200);
        tableColumn4.setResizable(false);
        tableColumn4.setText(ResourceString.getResourceString("label.object.name"));
    }

    private void initCategoryTable() {
        this.categoryTable.removeAll();
        if (this.categoryCheckMap != null) {
            for (TableEditor editor : this.categoryCheckMap.values()) {
                editor.getEditor().dispose();
                editor.dispose();
            }
            this.categoryCheckMap.clear();
        } else {
            this.categoryCheckMap = new HashMap<Category, TableEditor>();
        }
        for (Category category : this.categorySettings.getAllCategories()) {
            TableItem tableItem = new TableItem(this.categoryTable, 0);
            Button selectCheckButton = new Button((Composite)this.categoryTable, 32);
            selectCheckButton.pack();
            TableEditor editor = new TableEditor(this.categoryTable);
            editor.minimumWidth = selectCheckButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)selectCheckButton, tableItem, 0);
            tableItem.setText(1, category.getName());
            if (this.categorySettings.isSelected(category)) {
                selectCheckButton.setSelection(true);
            }
            this.categoryCheckMap.put(category, editor);
            if (this.targetCategory != category) continue;
            this.categoryTable.setSelection(tableItem);
        }
        if (this.targetCategory != null) {
            this.initNodeList(this.targetCategory);
        } else {
            this.deleteNodeList();
        }
    }

    private void initNodeTable() {
        this.nodeTable.removeAll();
        this.nodeCheckMap = new HashMap<NodeElement, TableEditor>();
        for (NodeElement nodeElement : this.diagram.getDiagramContents().getContents()) {
            TableItem tableItem = new TableItem(this.nodeTable, 0);
            Button selectCheckButton = new Button((Composite)this.nodeTable, 32);
            selectCheckButton.pack();
            TableEditor editor = new TableEditor(this.nodeTable);
            editor.minimumWidth = selectCheckButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)selectCheckButton, tableItem, 0);
            tableItem.setText(1, ResourceString.getResourceString("label.object.type." + nodeElement.getObjectType()));
            tableItem.setText(2, nodeElement.getName());
            this.nodeCheckMap.put(nodeElement, editor);
        }
    }

    private void initNodeList(Category category) {
        this.categoryNameText.setText(category.getName());
        for (NodeElement nodeElement : this.nodeCheckMap.keySet()) {
            Button selectCheckButton = (Button)this.nodeCheckMap.get(nodeElement).getEditor();
            if (category.contains(nodeElement)) {
                selectCheckButton.setSelection(true);
                continue;
            }
            selectCheckButton.setSelection(false);
        }
    }

    private void deleteNodeList() {
        this.categoryNameText.setText("");
        this.nodeTable.removeAll();
        if (this.nodeCheckMap != null) {
            for (TableEditor editor : this.nodeCheckMap.values()) {
                editor.getEditor().dispose();
                editor.dispose();
            }
            this.nodeCheckMap.clear();
        }
    }

    protected void addListener() {
        super.addListener();
        this.categoryTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CategoryManageDialog.this.categoryTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                CategoryManageDialog.this.validatePage();
                if (CategoryManageDialog.this.targetCategory == null) {
                    CategoryManageDialog.this.initNodeTable();
                }
                CategoryManageDialog.this.targetCategory = CategoryManageDialog.this.categorySettings.getAllCategories().get(index);
                CategoryManageDialog.this.initNodeList(CategoryManageDialog.this.targetCategory);
            }
        });
        this.addCategoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = CategoryManageDialog.this.categoryNameText.getText().trim();
                if (name.equals("")) {
                    return;
                }
                CategoryManageDialog.this.validatePage();
                if (CategoryManageDialog.this.targetCategory == null) {
                    CategoryManageDialog.this.initNodeTable();
                }
                Category addCategory = new Category();
                int[] color = CategoryManageDialog.this.diagram.getDefaultColor();
                addCategory.setColor(color[0], color[1], color[2]);
                addCategory.setName(name);
                CategoryManageDialog.this.categorySettings.addCategoryAsSelected(addCategory);
                CategoryManageDialog.this.targetCategory = addCategory;
                CategoryManageDialog.this.initCategoryTable();
            }
        });
        this.updateCategoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = CategoryManageDialog.this.categoryNameText.getText().trim();
                if (name.equals("")) {
                    return;
                }
                CategoryManageDialog.this.validatePage();
                CategoryManageDialog.this.targetCategory.setName(name);
                CategoryManageDialog.this.initCategoryTable();
            }
        });
        this.deleteCategoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = CategoryManageDialog.this.categoryTable.getSelectionIndex();
                    CategoryManageDialog.this.validatePage();
                    CategoryManageDialog.this.categorySettings.removeCategory(index);
                    if (CategoryManageDialog.this.categoryTable.getItemCount() <= index + 1) {
                        index = CategoryManageDialog.this.categoryTable.getItemCount() != 0 ? CategoryManageDialog.this.categoryTable.getItemCount() - 2 : -1;
                    }
                    if (index != -1) {
                        CategoryManageDialog.this.targetCategory = CategoryManageDialog.this.categorySettings.getAllCategories().get(index);
                    } else {
                        CategoryManageDialog.this.targetCategory = null;
                    }
                    CategoryManageDialog.this.initCategoryTable();
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CategoryManageDialog.this.categoryTable.getSelectionIndex();
                if (index == -1 || index == 0) {
                    return;
                }
                CategoryManageDialog.this.validatePage();
                CategoryManageDialog.this.changeColumn(index - 1, index);
                CategoryManageDialog.this.initCategoryTable();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CategoryManageDialog.this.categoryTable.getSelectionIndex();
                if (index == -1 || index == CategoryManageDialog.this.categoryTable.getItemCount() - 1) {
                    return;
                }
                CategoryManageDialog.this.validatePage();
                CategoryManageDialog.this.changeColumn(index, index + 1);
                CategoryManageDialog.this.initCategoryTable();
            }
        });
    }

    public void changeColumn(int index1, int index2) {
        List<Category> allCategories = this.categorySettings.getAllCategories();
        Category category1 = allCategories.remove(index1);
        Category category2 = null;
        if (index1 < index2) {
            category2 = allCategories.remove(index2 - 1);
            allCategories.add(index1, category2);
            allCategories.add(index2, category1);
        } else if (index1 > index2) {
            category2 = allCategories.remove(index2);
            allCategories.add(index1 - 1, category2);
            allCategories.add(index2, category1);
        }
    }

    protected String getTitle() {
        return "label.category";
    }

    protected void perfomeOK() throws InputException {
        this.validatePage();
    }

    protected void setData() {
        this.initCategoryTable();
    }

    protected String getErrorMessage() {
        return null;
    }

    public void validatePage() {
        if (this.targetCategory != null) {
            ArrayList<NodeElement> selectedNodeElementList = new ArrayList<NodeElement>();
            for (NodeElement table : this.nodeCheckMap.keySet()) {
                Button selectCheckButton = (Button)this.nodeCheckMap.get(table).getEditor();
                if (!selectCheckButton.getSelection()) continue;
                selectedNodeElementList.add(table);
            }
            this.targetCategory.setContents(selectedNodeElementList);
        }
        ArrayList<Category> selectedCategories = new ArrayList<Category>();
        for (Category category : this.categorySettings.getAllCategories()) {
            Button button = (Button)this.categoryCheckMap.get(category).getEditor();
            if (!button.getSelection()) continue;
            selectedCategories.add(category);
        }
        this.categorySettings.setSelectedCategories(selectedCategories);
    }
}

