/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.testdata.detail.tab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.RowHeaderTable;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.common.widgets.table.CellEditWorker;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.testdata.DirectTestData;
import org.insightech.er.editor.view.dialog.testdata.detail.TestDataDialog;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectTestDataTabWrapper
extends ValidatableTabWrapper {
    private TestDataDialog dialog;
    private RowHeaderTable editColumnTable;
    private DirectTestData directTestData;
    private ERTable table;

    public DirectTestDataTabWrapper(TestDataDialog dialog, TabFolder parent, int style) {
        super(dialog, parent, style, "label.testdata.direct.input");
        this.dialog = dialog;
        this.init();
    }

    @Override
    public void initComposite() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        Text dummy = CompositeFactory.createNumText(this.dialog, this, "", 50);
        dummy.setVisible(false);
        this.createEditTable(this);
    }

    private void createEditTable(Composite composite) {
        this.editColumnTable = CompositeFactory.createRowHeaderTable(composite, 730, 300, 75, 25, 2, false, true);
        this.editColumnTable.setCellEditWorker(new CellEditWorker(){

            public void addNewRow() {
                DirectTestDataTabWrapper.this.addNewRowToTable();
            }

            public void changeRowNum() {
                DirectTestDataTabWrapper.this.dialog.resetTestDataNum();
            }

            public boolean isModified(int row, int column) {
                return false;
            }
        });
    }

    @Override
    protected void setData() {
    }

    @Override
    public void validatePage() throws InputException {
        this.saveTableData();
    }

    @Override
    public void setInitFocus() {
    }

    @Override
    public void reset() {
        this.saveTableData();
        this.table = this.dialog.getTargetTable();
        this.directTestData = this.dialog.getTestData().getTableTestDataMap().get(this.table).getDirectTestData();
        this.initTable();
    }

    private void saveTableData() {
        if (this.directTestData != null) {
            ArrayList<Map<NormalColumn, String>> dataList = new ArrayList<Map<NormalColumn, String>>();
            List<NormalColumn> normalColumnList = this.table.getExpandedColumns();
            int row = 0;
            while (row < this.editColumnTable.getItemCount() - 1) {
                HashMap<NormalColumn, String> data = new HashMap<NormalColumn, String>();
                int column = 0;
                while (column < normalColumnList.size()) {
                    NormalColumn normalColumn = normalColumnList.get(column);
                    String value = (String)this.editColumnTable.getValueAt(row, column);
                    data.put(normalColumn, value);
                    ++column;
                }
                dataList.add(data);
                ++row;
            }
            this.directTestData.setDataList(dataList);
        }
    }

    private void initTable() {
        this.editColumnTable.setVisible(false);
        this.editColumnTable.removeData();
        for (NormalColumn normalColumn : this.table.getExpandedColumns()) {
            String name = normalColumn.getName();
            String type = null;
            type = normalColumn.getType() == null ? "" : Format.formatType(normalColumn.getType(), normalColumn.getTypeData(), this.dialog.getDiagram().getDatabase());
            this.editColumnTable.addColumnHeader(String.valueOf(name) + "\r\n" + type, 100);
        }
        for (Map map : this.directTestData.getDataList()) {
            this.addTableItem(map);
        }
        this.addNewRowToTable();
        this.editColumnTable.setVisible(true);
    }

    private void addNewRowToTable() {
        this.editColumnTable.addRow("+", null);
    }

    private void addTableItem(Map<NormalColumn, String> data) {
        List<NormalColumn> columns = this.table.getExpandedColumns();
        Object[] values = new String[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            values[i] = data.get(columns.get(i));
            ++i;
        }
        this.editColumnTable.addRow(String.valueOf(this.editColumnTable.getItemCount() + 1), values);
    }

    @Override
    public void perfomeOK() {
    }

    public int getTestDataNum() {
        return this.editColumnTable.getItemCount() - 1;
    }
}

