/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;

public class NoteFigure
extends Shape {
    private static final long serialVersionUID = 7613144432550730126L;
    public static final int RETURN_WIDTH = 15;
    private TextFlow label;
    private Color foregroundColor;

    public NoteFigure() {
        this.create();
        this.setMinimumSize(new Dimension(30, 30));
    }

    public void create() {
        this.setBorder((Border)new MarginBorder(15));
        this.setLayoutManager((LayoutManager)new BorderLayout());
        FlowPage page = new FlowPage();
        this.label = new TextFlow();
        ParagraphTextLayout layout = new ParagraphTextLayout(this.label, 1);
        this.label.setLayoutManager((LayoutManager)layout);
        this.label.setOpaque(false);
        page.add((IFigure)this.label);
        this.add((IFigure)page, BorderLayout.CENTER);
    }

    public void setText(String text, int[] color) {
        this.decideColor(color);
        this.setForegroundColor(this.foregroundColor);
        this.label.setText(text);
    }

    protected void fillShape(Graphics graphics) {
        graphics.setAlpha(200);
        Rectangle bounds = this.getBounds();
        Point topRight1 = bounds.getTopRight().translate(0, 15);
        Point topRight2 = bounds.getTopRight().translate(-15, 0);
        PointList pointList = new PointList();
        pointList.addPoint(bounds.getTopLeft());
        pointList.addPoint(bounds.getBottomLeft());
        pointList.addPoint(bounds.getBottomRight());
        pointList.addPoint(topRight1);
        pointList.addPoint(topRight2);
        pointList.addPoint(bounds.getTopLeft());
        graphics.fillPolygon(pointList);
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle r = this.getBounds();
        int x = r.x + this.getLineWidth() / 2;
        int y = r.y + this.getLineWidth() / 2;
        int w = r.width - Math.max(1, this.getLineWidth());
        int h = r.height - Math.max(1, this.getLineWidth());
        Rectangle bounds = new Rectangle(x, y, w, h);
        Point topRight1 = bounds.getTopRight().translate(0, 15);
        Point topRight2 = bounds.getTopRight().translate(-15, 0);
        Point topRight3 = bounds.getTopRight().translate(-15, 15);
        graphics.drawLine(bounds.getTopLeft(), bounds.getBottomLeft());
        graphics.drawLine(bounds.getBottomLeft(), bounds.getBottomRight());
        graphics.drawLine(bounds.getBottomRight(), topRight1);
        graphics.drawLine(topRight1, topRight2);
        graphics.drawLine(topRight2, bounds.getTopLeft());
        graphics.drawLine(topRight2, topRight3);
        graphics.drawLine(topRight3, topRight1);
    }

    private void decideColor(int[] color) {
        if (color != null) {
            int sum = color[0] + color[1] + color[2];
            this.foregroundColor = sum > 255 ? ColorConstants.black : ColorConstants.white;
        }
    }
}

