/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.figure.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLayout
extends AbstractHintLayout {
    private int colnum;
    private int separatorWidth;
    private List<IFigure> separators;

    public TableLayout(int colnum) {
        this.colnum = colnum;
        if (this.colnum <= 0) {
            this.colnum = 1;
        }
        this.separators = new ArrayList<IFigure>();
        this.separatorWidth = 1;
    }

    public void setSeparator() {
    }

    public void layout(IFigure parent) {
        List children = this.clearSeparator(parent);
        List<List<IFigure>> table = this.getTable(children);
        int[] columnWidth = this.getColumnWidth(table);
        int[] rowHeight = this.getRowHeight(table);
        Rectangle rect = parent.getBounds();
        int x = rect.x + 1;
        int y = rect.y + 1;
        int i = 0;
        while (i < table.size()) {
            List<IFigure> tableRow = table.get(i);
            int j = 0;
            while (j < tableRow.size()) {
                Rectangle childRect = new Rectangle(x, y, columnWidth[j], rowHeight[i]);
                IFigure figure = tableRow.get(j);
                figure.setBounds(childRect);
                x += columnWidth[j];
                if (j != tableRow.size() - 1) {
                    Rectangle separetorRect = new Rectangle(x, y, this.separatorWidth, rowHeight[i]);
                    this.addVerticalSeparator(parent, separetorRect);
                    x += this.separatorWidth;
                }
                ++j;
            }
            x = rect.x + 1;
            y += rowHeight[i];
            if (i != table.size() - 1) {
                Rectangle separetorRect = new Rectangle(x, y, rect.width, this.separatorWidth);
                this.addHorizontalSeparator(parent, separetorRect);
                y += this.separatorWidth;
            }
            ++i;
        }
    }

    private List<List<IFigure>> getTable(List children) {
        int numChildren = children.size();
        ArrayList<List<IFigure>> table = new ArrayList<List<IFigure>>();
        ArrayList<IFigure> row = null;
        int i = 0;
        while (i < numChildren) {
            if (i % this.colnum == 0) {
                row = new ArrayList<IFigure>();
                table.add(row);
            }
            row.add((IFigure)children.get(i));
            ++i;
        }
        return table;
    }

    private int[] getColumnWidth(List<List<IFigure>> table) {
        int[] columnWidth = new int[this.colnum];
        int i = 0;
        while (i < this.colnum) {
            for (List<IFigure> tableRow : table) {
                if (tableRow.size() <= i) continue;
                IFigure figure = tableRow.get(i);
                int width = figure.getPreferredSize().width;
                if (width <= columnWidth[i]) continue;
                columnWidth[i] = (int)((double)width * 1.3);
            }
            ++i;
        }
        return columnWidth;
    }

    private int[] getRowHeight(List<List<IFigure>> table) {
        int[] rowHeight = new int[table.size()];
        int i = 0;
        while (i < rowHeight.length) {
            for (IFigure cell : table.get(i)) {
                int height = cell.getPreferredSize().height;
                if (height <= rowHeight[i]) continue;
                rowHeight[i] = height;
            }
            ++i;
        }
        return rowHeight;
    }

    private List<IFigure> getChildren(IFigure parent) {
        ArrayList<IFigure> children = new ArrayList<IFigure>();
        for (IFigure child : parent.getChildren()) {
            if (this.separators.contains(child)) continue;
            children.add(child);
        }
        return children;
    }

    private List clearSeparator(IFigure parent) {
        Iterator iter = parent.getChildren().iterator();
        while (iter.hasNext()) {
            IFigure child = (IFigure)iter.next();
            if (!this.separators.contains(child)) continue;
            iter.remove();
        }
        this.separators.clear();
        return parent.getChildren();
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        List<IFigure> children = this.getChildren(container);
        List<List<IFigure>> table = this.getTable(children);
        int[] columnWidth = this.getColumnWidth(table);
        int[] rowHeight = this.getRowHeight(table);
        int width = 0;
        int i = 0;
        while (i < columnWidth.length) {
            width += columnWidth[i];
            if (i != columnWidth.length - 1) {
                width += this.separatorWidth;
            }
            ++i;
        }
        ++width;
        ++width;
        int height = 0;
        int i2 = 0;
        while (i2 < rowHeight.length) {
            height += rowHeight[i2];
            if (i2 != rowHeight.length - 1) {
                height += this.separatorWidth;
            }
            ++i2;
        }
        ++height;
        return new Dimension(width, ++height);
    }

    private void addVerticalSeparator(IFigure figure, Rectangle rect) {
        Polyline separator = new Polyline();
        separator.setLineWidth(this.separatorWidth);
        separator.addPoint(new Point(rect.x, rect.y));
        separator.addPoint(new Point(rect.x, rect.y + rect.height));
        figure.getChildren().add(separator);
        separator.setParent(figure);
        this.separators.add((IFigure)separator);
    }

    private void addHorizontalSeparator(IFigure figure, Rectangle rect) {
        Polyline separator = new Polyline();
        separator.setLineWidth(this.separatorWidth);
        separator.addPoint(new Point(rect.x, rect.y));
        separator.addPoint(new Point(rect.x + rect.width, rect.y));
        figure.getChildren().add(separator);
        separator.setParent(figure);
        this.separators.add((IFigure)separator);
    }
}

