/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.preference;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class MultiFileFieldEditor
extends FileFieldEditor {
    private String[] extensions = null;
    private boolean multiple = false;

    public MultiFileFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, false, parent);
    }

    protected String changePressed() {
        File f;
        StringTokenizer tokenizer = new StringTokenizer(this.getTextControl().getText(), ";");
        if (tokenizer.countTokens() == 0) {
            f = null;
        } else {
            f = new File(tokenizer.nextToken());
            if (!f.exists()) {
                f = null;
            }
        }
        File[] d = this.getFile(f);
        if (d == null || d.length == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < d.length) {
            ret.append(d[i].getAbsolutePath());
            ret.append(";");
            ++i;
        }
        return ret.toString();
    }

    private File[] getFile(File startingDirectory) {
        int style = 4096;
        if (this.multiple) {
            style |= 2;
        }
        FileDialog dialog = new FileDialog(this.getShell(), style);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if (this.extensions != null) {
            dialog.setFilterExtensions(this.extensions);
        }
        dialog.open();
        String[] fileNames = dialog.getFileNames();
        if (fileNames.length > 0) {
            File[] files = new File[fileNames.length];
            int i = 0;
            while (i < fileNames.length) {
                files[i] = new File(dialog.getFilterPath(), fileNames[i]);
                ++i;
            }
            return files;
        }
        return null;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }
}

