/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.RNCCompletionProposal;
import com.objfac.rnceditor.RNCConstants;
import com.objfac.rnceditor.RNCEditor;
import com.objfac.rnceditor.RNCNode;
import com.objfac.rnceditor.RNCTree;
import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.schema.SchemaConstants;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.contentassist.XMLCompletionProposal;
import com.objfac.xmleditor.partition.PartitionUtils;
import com.objfac.xmleditor.template.IVariable;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;

public class RNCContentAssistProcessor
implements IContentAssistProcessor {
    private int fStart;
    private String fError;
    private ITextViewer fViewer;
    private RNCEditor fEditor;
    private RNCTree fTree;
    private int fBeg;
    private int fEnd;
    private IContextInformationValidator fValidator = new Validator();
    private static final String[] NONE = new String[0];
    private static final int IN_WHITESPACE = 0;
    private ITypedRegion fPartition;
    private static final int DEC = 0;
    private static final int PAT = 1;
    private static final int POP = 2;
    private static final int PIP = 3;
    private static final int GRM = 4;
    private static final int INC = 5;
    private static final int TYP = 6;
    private static final int SIM = 7;
    private static final int KID = 8;
    private static final int IDO = 9;
    private static final int KEY = 10;
    private static final int NOT = 11;
    private static final int NOQ = 12;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        this.fError = null;
        this.fViewer = iTextViewer;
        this.fEditor = (RNCEditor)RNCEditor.getEditorForDocument(this.fViewer.getDocument());
        this.fTree = this.fEditor.getRNCTree();
        try {
            Point point = iTextViewer.getSelectedRange();
            int n2 = point.x;
            int n3 = point.x + point.y;
            if (n != n2) {
                n2 = n3 = n;
            }
            this.fBeg = n2;
            this.fEnd = n3;
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals();
            Object var6_7 = null;
            this.fViewer = null;
            this.fEditor = null;
            this.fTree = null;
            return iCompletionProposalArray;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fViewer = null;
            this.fEditor = null;
            this.fTree = null;
            throw throwable;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        IContextInformation[] iContextInformationArray = new IContextInformation[]{};
        int n2 = 0;
        while (n2 < iContextInformationArray.length) {
            iContextInformationArray[n2] = new ContextInformation(Local.format((String)"CompletionProcessor.ContextInfo.display.pattern", (Object)new Integer(n2), (Object)new Integer(n)), Local.format((String)"CompletionProcessor.ContextInfo.value.pattern", (Object)new Integer(n2), (Object)new Integer(n - 5), (Object)new Integer(n + 5)));
            ++n2;
        }
        return iContextInformationArray;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return this.fError;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    private ICompletionProposal[] computeCompletionProposals() {
        int n;
        IVariable[] iVariableArray;
        ICompletionProposal[] iCompletionProposalArray;
        char[] cArray = new char[1];
        String[] stringArray = NONE;
        String[] stringArray2 = NONE;
        this.fStart = this.fBeg;
        int n2 = this.computeContext();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                cArray = RNCCompletionProposal.TRIGGER;
                break;
            }
            case 11: {
                this.fError = this.noProposals();
            }
            default: {
                return new ICompletionProposal[0];
            }
        }
        this.fStart = this.computeStart(this.fStart);
        stringArray = this.computeProposals(n2);
        stringArray2 = this.computeReplacements(n2, stringArray);
        if (this.fStart < this.fBeg) {
            LinkedList<String> linkedList = new LinkedList<String>();
            iCompletionProposalArray = new LinkedList();
            iVariableArray = "";
            try {
                iVariableArray = this.fViewer.getDocument().get(this.fStart, this.fBeg - this.fStart);
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith((String)iVariableArray)) {
                    linkedList.add(stringArray[n]);
                    iCompletionProposalArray.add(stringArray2[n]);
                }
                ++n;
            }
            if (linkedList.size() == 0) {
                this.fError = this.noProposals();
                return new ICompletionProposal[0];
            }
            stringArray = linkedList.toArray(new String[linkedList.size()]);
            stringArray2 = iCompletionProposalArray.toArray(new String[iCompletionProposalArray.size()]);
        }
        int n3 = stringArray == null ? 0 : stringArray.length;
        iCompletionProposalArray = new ICompletionProposal[n3];
        iVariableArray = XMLCompletionProposal.BUILTINVARIABLES;
        if (n3 > 0) {
            this.fEditor.setWatchPos(this.fEnd);
        }
        n = 0;
        while (n < n3) {
            iCompletionProposalArray[n] = new RNCCompletionProposal(stringArray[n], stringArray2[n], this.fStart, cArray, iVariableArray);
            ++n;
        }
        Arrays.sort(iCompletionProposalArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ICompletionProposal iCompletionProposal = (ICompletionProposal)object;
                ICompletionProposal iCompletionProposal2 = (ICompletionProposal)object2;
                String string = iCompletionProposal.getDisplayString();
                String string2 = iCompletionProposal2.getDisplayString();
                char c = string.charAt(0);
                char c2 = string2.charAt(0);
                boolean bl = XMLCharacter.isIDPart((char)c);
                boolean bl2 = XMLCharacter.isIDPart((char)c2);
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
                return string.compareToIgnoreCase(string2);
            }
        });
        return iCompletionProposalArray;
    }

    private String noProposals() {
        return Local.getString((String)"completion_No_proposals_available_1");
    }

    private String[] computeProposals(int n) {
        switch (n) {
            case 0: {
                return this.computeDeclarationProposals();
            }
            case 1: {
                return this.computePatternProposals();
            }
            case 2: {
                return new String[]{",", "|", "&", "?", "*", "+"};
            }
            case 3: {
                return new String[]{",", "|", "&"};
            }
            case 4: {
                return this.computeGrammarContentProposals();
            }
            case 5: {
                return this.computeIncludeContentProposals();
            }
            case 6: {
                return this.computeTypeProposals();
            }
            case 7: {
                return this.computeSimpleTypeProposals();
            }
            case 8: {
                return this.computeKeyIdProposals();
            }
            case 10: {
                return this.computeKeyProposals();
            }
            case 9: {
                return this.computeIdProposals();
            }
        }
        return NONE;
    }

    private String[] computeDeclarationProposals() {
        LinkedList linkedList = new LinkedList();
        this.addArray(linkedList, RNCConstants.DECLARATION_KEYWORDS);
        if (this.getPrev(this.fBeg - 1) == null && this.getNext(this.fBeg) == null) {
            this.addPatternProposals(linkedList);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void addPatternProposals(LinkedList linkedList) {
        this.addKeyProposals(linkedList);
        this.addDefineNameProposals(linkedList);
    }

    private void addDefineNameProposals(LinkedList linkedList) {
        Position[] positionArray = this.fTree.getPositions();
        int n = 0;
        while (n < positionArray.length) {
            RNCNode rNCNode = (RNCNode)positionArray[n];
            if (rNCNode.getType() == "com.objfac.rncdefine") {
                char c;
                String string = rNCNode.getContents();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = string.length();
                int n3 = 0;
                while (n3 < n2 && XMLCharacter.isIDPart((char)(c = string.charAt(n3)))) {
                    stringBuffer.append(c);
                    ++n3;
                }
                if (stringBuffer.length() > 0) {
                    linkedList.add(stringBuffer.toString());
                }
            }
            ++n;
        }
    }

    private void addArray(LinkedList linkedList, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            linkedList.add(stringArray[n]);
            ++n;
        }
    }

    private String[] computePatternProposals() {
        LinkedList linkedList = new LinkedList();
        this.addPatternProposals(linkedList);
        this.addDatatypeProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void addDatatypeProposals(LinkedList linkedList) {
        Position[] positionArray = this.fTree.getPositions();
        "http://www.w3.org/2001/XMLSchema-datatypes".length();
        String string = "xsd";
        int n = 0;
        while (n < positionArray.length) {
            RNCNode rNCNode = (RNCNode)positionArray[n];
            if (rNCNode.getType() == "com.objfac.rncdatatypes") {
                char c;
                String string2 = rNCNode.getContents();
                int n2 = "datatypes".length();
                int n3 = string2.length();
                if ((n2 = this.skipWS(string2, n2)) < n3 && XMLCharacter.isIDStart((char)(c = string2.charAt(n2)))) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(c);
                    ++n2;
                    while (n2 < n3 && XMLCharacter.isIDPart((char)(c = string2.charAt(n2)))) {
                        ++n2;
                        stringBuffer.append(c);
                    }
                    String string3 = stringBuffer.toString();
                    if (string3.length() > 0) {
                        String string4;
                        if (((n2 = this.skipWS(string2, n2 + 1)) < n3 && (c = string2.charAt(n2)) == '\"' || c == '\'') && (string4 = this.getQuoteContents(string2, n2 + 1, c)).equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                            string = string3;
                            break;
                        }
                        if (string3.equals("xsd")) {
                            string = null;
                        }
                    }
                }
            } else if (this.isPattern(rNCNode) || this.isGrammarContents(rNCNode)) break;
            ++n;
        }
        if (string != null) {
            n = 0;
            while (n < SchemaConstants.TYPES.length) {
                linkedList.add(String.valueOf(string) + ':' + SchemaConstants.TYPES[n]);
                ++n;
            }
        }
    }

    private int skipWS(String string, int n) {
        int n2 = string.length();
        while (n < n2 && XMLCharacter.isWhitespace((char)string.charAt(n))) {
            ++n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private String getQuoteContents(String var1_1, int var2_2, char var3_3) {
        block3: {
            var4_4 = var1_1.length();
            var5_5 = new StringBuffer();
            if (var2_2 >= var4_4 || var1_1.charAt(var2_2) != var3_3) ** GOTO lbl16
            if (++var2_2 >= var4_4 || var1_1.charAt(var2_2) != var3_3) break block3;
            while (++var2_2 < var4_4) {
                var6_6 = var1_1.charAt(var2_2);
                if (var6_6 != var3_3 || var2_2 + 1 >= var4_4 || var1_1.charAt(var2_2 + 1) != var3_3 || var2_2 + 2 >= var4_4 || var1_1.charAt(var2_2 + 2) != var3_3) {
                    var5_5.append(var6_6);
                    continue;
                }
                break block3;
            }
            break block3;
            while ((var6_7 = var1_1.charAt(var2_2)) != var3_3) {
                var5_5.append(var6_7);
lbl16:
                // 2 sources

                if (++var2_2 < var4_4) continue;
            }
        }
        return var5_5.toString();
    }

    private String[] computeGrammarContentProposals() {
        return new String[]{"start", "div", "include"};
    }

    private String[] computeIncludeContentProposals() {
        return new String[]{"start", "div"};
    }

    private String[] computeTypeProposals() {
        LinkedList linkedList = new LinkedList();
        this.addDatatypeProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] computeSimpleTypeProposals() {
        LinkedList linkedList = new LinkedList();
        this.addDatatypeProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void addKeyProposals(LinkedList linkedList) {
        this.addArray(linkedList, RNCConstants.PATTERN_KEYWORDS);
    }

    private String[] computeKeyProposals() {
        LinkedList linkedList = new LinkedList();
        this.addKeyProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] computeKeyIdProposals() {
        LinkedList linkedList = new LinkedList();
        this.addKeyProposals(linkedList);
        this.addDefineNameProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] computeIdProposals() {
        LinkedList linkedList = new LinkedList();
        this.addDefineNameProposals(linkedList);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String[] computeReplacements(int n, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private int computeStart(int n) {
        if (n > 0) {
            IDocument iDocument = this.fViewer.getDocument();
            try {
                boolean bl = false;
                int n2 = n - 1;
                while (n2 > 0 && XMLCharacter.isIDPart((char)iDocument.getChar(n2))) {
                    bl = true;
                    --n2;
                }
                if (bl) {
                    n = n2 + 1;
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        return n;
    }

    private int computeContext() {
        char c;
        IDocument iDocument = this.fViewer.getDocument();
        if (this.fBeg == 0 && iDocument.getLength() == 0) {
            return 0;
        }
        String string = "\u00000";
        try {
            if (this.fBeg > 0) {
                string = iDocument.get(this.fBeg - 1, 1);
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        boolean bl = (c = string.charAt(0)) == ' ';
        RNCNode rNCNode = this.fTree.fastFindNode(this.fBeg);
        if (rNCNode == null) {
            return this.sayNo(bl);
        }
        boolean bl2 = rNCNode.getOffset() == this.fBeg;
        int n = RNCConstants.getIntType(rNCNode.getType());
        if (XMLCharacter.isIDPart((char)c)) {
            return this.computeIdContext(bl, bl2, rNCNode, n);
        }
        if (n == 33 && c == '\\') {
            int n2 = this.computeBeforeContext(this.fBeg - 1);
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return 10;
                }
            }
        } else if (bl2 || n == 1 || n == 33 && c == '\\') {
            return this.computeBeforeContext(this.fBeg);
        }
        return this.sayNo(bl);
    }

    private int computeBeforeContext(int n) {
        RNCNode rNCNode = this.getPrev(n);
        if (rNCNode == null) {
            return 0;
        }
        int n2 = RNCConstants.getIntType(rNCNode.getType());
        char c = this.lastChar(rNCNode);
        switch (n2) {
            case 2: {
                RNCNode rNCNode2;
                if (this.isPatternEnd(rNCNode)) {
                    return 2;
                }
                if (n2 != 26 || (rNCNode2 = (RNCNode)rNCNode.getParent()) == null) break;
                if (rNCNode2.getType() == "com.objfac.rncgrammar") {
                    return 4;
                }
                if (rNCNode2.getType() != "com.objfac.rncinclude") break;
                return 5;
            }
            case 3: 
            case 4: 
            case 18: 
            case 24: 
            case 32: {
                RNCNode rNCNode3 = (RNCNode)rNCNode.getParent();
                if (rNCNode3 == null || rNCNode3.getType() == "com.objfac.rncattribute") break;
                return 2;
            }
            case 5: 
            case 6: 
            case 14: {
                if (c != '{') break;
                return 1;
            }
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 25: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: {
                RNCNode rNCNode4 = this.getPrev(rNCNode.getOffset());
                RNCNode cfr_ignored_0 = (RNCNode)rNCNode.getParent();
                if (rNCNode4 == null || !this.isPatternEnd(rNCNode4) || rNCNode4.getType() == "com.objfac.rncattribute") break;
                return 3;
            }
            case 13: {
                if (c != '{') break;
                return 7;
            }
            case 15: {
                if (c != '{') break;
                return 4;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 23: {
                return 3;
            }
            case 26: 
            case 27: {
                if (c == '{') {
                    return 5;
                }
            }
            case 28: 
            case 29: 
            case 30: {
                return 0;
            }
        }
        return this.sayNo(false);
    }

    private int computeIdContext(boolean bl, boolean bl2, ITypedRegion iTypedRegion, int n) {
        block32: {
            block31: {
                if (!bl2) break block31;
                RNCNode rNCNode = (RNCNode)PartitionUtils.getPartition(this.fViewer.getDocument(), "com.objfac.rncpartitioner", iTypedRegion.getOffset(), true);
                this.lastChar(rNCNode);
                switch (RNCConstants.getIntType(rNCNode.getType())) {
                    case 0: 
                    case 19: 
                    case 22: 
                    case 31: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 18: {
                        return 9;
                    }
                    case 5: {
                        if (this.isKeyContinue(rNCNode, "element")) {
                            return 9;
                        }
                        break block32;
                    }
                    case 6: {
                        if (this.isKeyContinue(rNCNode, "attribute")) {
                            return 9;
                        }
                        break block32;
                    }
                    case 13: {
                        if (this.isKeyContinue(rNCNode, "list")) {
                            return 9;
                        }
                        break block32;
                    }
                    case 14: {
                        if (this.isKeyContinue(rNCNode, "mixed")) {
                            return 9;
                        }
                    }
                    case 15: {
                        if (this.isKeyContinue(rNCNode, "grammar")) {
                            return 9;
                        }
                        break block32;
                    }
                    case 21: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        return 8;
                    }
                }
                break block32;
            }
            switch (n) {
                case 3: 
                case 4: 
                case 18: {
                    return 8;
                }
                case 5: {
                    if (!this.inKey(iTypedRegion, "element")) break;
                    return 8;
                }
                case 6: {
                    if (!this.inKey(iTypedRegion, "attribute")) break;
                    return 8;
                }
                case 13: {
                    if (!this.inKey(iTypedRegion, "list")) break;
                    return 8;
                }
                case 14: {
                    if (!this.inKey(iTypedRegion, "mixed")) break;
                    return 8;
                }
                case 15: {
                    if (!this.inKey(iTypedRegion, "grammar")) break;
                    return 8;
                }
                case 21: {
                    if (this.lastChar((RNCNode)iTypedRegion) != '=') {
                        return 8;
                    }
                }
                case 23: {
                    break;
                }
                case 24: {
                    return 8;
                }
                case 25: {
                    if (this.lastChar((RNCNode)iTypedRegion) == '=') break;
                    return 8;
                }
                case 26: {
                    if (this.lastChar((RNCNode)iTypedRegion) == '{') break;
                    return 8;
                }
                case 27: {
                    if (!this.inKey(iTypedRegion, "include")) break;
                    return 8;
                }
            }
        }
        return this.sayNo(bl);
    }

    private boolean inKey(ITypedRegion iTypedRegion, String string) {
        int n = iTypedRegion.getOffset();
        int n2 = string.length();
        return n < this.fBeg && this.fBeg <= n + n2 && iTypedRegion.getLength() <= n2;
    }

    private boolean isKeyContinue(RNCNode rNCNode, String string) {
        int n;
        int n2 = rNCNode.getOffset();
        int n3 = n2 + (n = rNCNode.getLength());
        return this.fBeg == n3 && n == string.length();
    }

    private boolean isGrammarContents(RNCNode rNCNode) {
        if (rNCNode == null) {
            return false;
        }
        switch (RNCConstants.getIntType(rNCNode.getType())) {
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private boolean isPatternEnd(RNCNode rNCNode) {
        if (rNCNode == null) {
            return false;
        }
        switch (RNCConstants.getIntType(rNCNode.getType())) {
            case 2: {
                return this.isPattern(rNCNode.getParent());
            }
            case 3: 
            case 4: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 32: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                return false;
            }
            case 0: 
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 19: 
            case 31: {
                return this.isPatternEnd(this.getPrev(rNCNode.getOffset()));
            }
        }
        return false;
    }

    private boolean isPattern(XMLNode xMLNode) {
        if (xMLNode == null) {
            return false;
        }
        switch (RNCConstants.getIntType(xMLNode.getType())) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    private boolean isInteresting(XMLNode xMLNode) {
        if (xMLNode == null) {
            return false;
        }
        String string = xMLNode.getType();
        return string != "com.objfac.rnccomment" && string != "com.objfac.rncws" && string != "com.objfac.rncanno" && string != "com.objfac.rncdocumentation";
    }

    private char lastChar(RNCNode rNCNode) {
        int n = rNCNode.getOffset() + rNCNode.getLength() - 1;
        try {
            char c = this.fViewer.getDocument().getChar(n);
            return c;
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return '\u0000';
        }
    }

    private RNCNode getNext(int n) {
        IDocument iDocument = this.fViewer.getDocument();
        int n2 = iDocument.getLength();
        while (n < n2) {
            RNCNode rNCNode = this.fTree.fastFindNode(n);
            if (this.isInteresting(rNCNode)) {
                return rNCNode;
            }
            n = rNCNode.getOffset() + rNCNode.getLength();
        }
        return null;
    }

    private RNCNode getPrev(int n) {
        --n;
        while (n >= 0) {
            RNCNode rNCNode = this.fTree.fastFindNode(n);
            if (this.isInteresting(rNCNode)) {
                return rNCNode;
            }
            n = rNCNode.getOffset();
            --n;
        }
        return null;
    }

    private int sayNo(boolean bl) {
        return bl ? 12 : 11;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fOffset;
        protected ITextViewer fViewer;
        protected IContextInformation fInfo;

        protected Validator() {
        }

        public boolean isContextInformationValid(int n) {
            return false;
        }

        public void install(IContextInformation iContextInformation, ITextViewer iTextViewer, int n) {
            this.fInfo = iContextInformation;
            this.fViewer = iTextViewer;
            this.fOffset = n;
        }

        public boolean updatePresentation(int n, TextPresentation textPresentation) {
            return false;
        }
    }
}

