/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor;

import com.objfac.rnceditor.color.AnnotationScanner;
import com.objfac.rnceditor.color.AnyScanner;
import com.objfac.rnceditor.color.GeneralScanner;
import com.objfac.rnceditor.color.NameClassScanner;
import com.objfac.xmleditor.BaseEditorEnvironment;
import com.objfac.xmleditor.util.XMLColorProvider;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class RNCEditorEnvironment
extends BaseEditorEnvironment {
    private IPreferenceStore fStore;
    private XMLColorProvider colorProvider;
    private HashMap fScanners = null;

    public RNCEditorEnvironment(IPreferenceStore iPreferenceStore) {
        this.fStore = iPreferenceStore;
    }

    protected void initialize() {
    }

    protected void clear() {
        this.colorProvider.dispose();
        this.colorProvider = null;
        this.fScanners = null;
    }

    public XMLColorProvider getXMLColorProvider() {
        if (this.colorProvider == null) {
            this.colorProvider = new XMLColorProvider();
        }
        return this.colorProvider;
    }

    public Color getPreferenceColor(String string) {
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getStore(), (String)string);
        XMLColorProvider xMLColorProvider = this.getXMLColorProvider();
        return xMLColorProvider.getColor(rGB);
    }

    public int getPreferenceStyle(String string) {
        return this.getStore().getBoolean(String.valueOf(string) + "#bold") ? 1 : 0;
    }

    public RuleBasedScanner getScannerForType(String string) {
        if (this.fScanners == null) {
            this.fScanners = new HashMap(11);
            GeneralScanner generalScanner = new GeneralScanner(this);
            NameClassScanner nameClassScanner = new NameClassScanner(this);
            AnnotationScanner annotationScanner = new AnnotationScanner(this);
            this.fScanners.put("com.objfac.rnccomment", new AnyScanner(this, "com.objfac.rnc.comment"));
            this.fScanners.put("com.objfac.rncdocumentation", new AnyScanner(this, "com.objfac.rnc.documentation"));
            this.fScanners.put("com.objfac.rncws", generalScanner);
            this.fScanners.put("com.objfac.rncend", generalScanner);
            this.fScanners.put("com.objfac.rncempty", generalScanner);
            this.fScanners.put("com.objfac.rnctext", generalScanner);
            this.fScanners.put("com.objfac.rncelement", nameClassScanner);
            this.fScanners.put("com.objfac.rncattribute", nameClassScanner);
            this.fScanners.put("com.objfac.rnccomma", generalScanner);
            this.fScanners.put("com.objfac.rncor", generalScanner);
            this.fScanners.put("com.objfac.rncamp", generalScanner);
            this.fScanners.put("com.objfac.rncquestion", generalScanner);
            this.fScanners.put("com.objfac.rncstar", generalScanner);
            this.fScanners.put("com.objfac.rncplus", generalScanner);
            this.fScanners.put("com.objfac.rnclist", generalScanner);
            this.fScanners.put("com.objfac.rncmixed", generalScanner);
            this.fScanners.put("com.objfac.rncgrammar", generalScanner);
            this.fScanners.put("com.objfac.rnclparen", generalScanner);
            this.fScanners.put("com.objfac.rncrparen", generalScanner);
            this.fScanners.put("com.objfac.rncnotallowed", generalScanner);
            this.fScanners.put("com.objfac.rncanno", annotationScanner);
            this.fScanners.put("com.objfac.rncannoend", annotationScanner);
            this.fScanners.put("com.objfac.rncdefine", generalScanner);
            this.fScanners.put("com.objfac.rncvalue", generalScanner);
            this.fScanners.put("com.objfac.rncdatatype", nameClassScanner);
            this.fScanners.put("com.objfac.rncref", generalScanner);
            this.fScanners.put("com.objfac.rncstart", generalScanner);
            this.fScanners.put("com.objfac.rncdiv", generalScanner);
            this.fScanners.put("com.objfac.rncinclude", generalScanner);
            this.fScanners.put("com.objfac.rncnamespace", generalScanner);
            this.fScanners.put("com.objfac.rncdefault", generalScanner);
            this.fScanners.put("com.objfac.rncdatatypes", generalScanner);
            this.fScanners.put("com.objfac.rncexternal", generalScanner);
            this.fScanners.put("com.objfac.rncbad", generalScanner);
            this.fScanners.put("com.objfac.rncexcept", generalScanner);
        }
        return (RuleBasedScanner)this.fScanners.get(string);
    }

    public IPreferenceStore getStore() {
        return this.fStore;
    }

    public Color getColor(int n, int n2, int n3) {
        RGB rGB = new RGB(n, n2, n3);
        return this.getColor(rGB);
    }

    public Color getColor(RGB rGB) {
        XMLColorProvider xMLColorProvider = this.getXMLColorProvider();
        return xMLColorProvider.getColor(rGB);
    }

    public void dispose() {
    }
}

