/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor.partition;

import com.objfac.util.UnimplementedException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;

public class BufferDocument
implements IDocument {
    private int[] lines;
    private char[] buf;

    public BufferDocument(char[] cArray) {
        this.buf = cArray;
        this.computeLineStarts();
    }

    private void computeLineStarts() {
        int[] nArray = new int[1024];
        nArray[0] = 0;
        int n = 1;
        int n2 = 0;
        while (n2 < this.buf.length) {
            char c = this.buf[n2];
            if (c == '\r' || c == '\n') {
                if (c == '\r' && n2 + 1 < this.buf.length && this.buf[n2 + 1] == '\n') {
                    ++n2;
                }
                if (n >= nArray.length) {
                    int[] nArray2 = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                nArray[n++] = n2 + 1;
            }
            ++n2;
        }
        this.lines = new int[n];
        System.arraycopy(nArray, 0, this.lines, 0, n);
    }

    private int findLine(int n) {
        int n2 = 0;
        int n3 = this.lines.length - 1;
        while (n2 < n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.lines[n4];
            if (n > n5) {
                n2 = n4;
                continue;
            }
            if (n < n5) {
                n3 = n4;
                continue;
            }
            return n4;
        }
        return n2;
    }

    public char getChar(int n) throws BadLocationException {
        if (n < 0 || n > this.buf.length) {
            throw new BadLocationException();
        }
        return this.buf[n];
    }

    public int getLength() {
        return this.buf.length;
    }

    public String get() {
        return String.copyValueOf(this.buf);
    }

    public String get(int n, int n2) throws BadLocationException {
        if (n < 0 || n2 < 0 || n + n2 > this.buf.length) {
            throw new BadLocationException();
        }
        return String.copyValueOf(this.buf, n, n2);
    }

    public void set(String string) {
        throw new UnimplementedException();
    }

    public void replace(int n, int n2, String string) throws BadLocationException {
        throw new UnimplementedException();
    }

    public void addDocumentListener(IDocumentListener iDocumentListener) {
        throw new UnimplementedException();
    }

    public void removeDocumentListener(IDocumentListener iDocumentListener) {
        throw new UnimplementedException();
    }

    public void addPrenotifiedDocumentListener(IDocumentListener iDocumentListener) {
        throw new UnimplementedException();
    }

    public void removePrenotifiedDocumentListener(IDocumentListener iDocumentListener) {
        throw new UnimplementedException();
    }

    public void addPositionCategory(String string) {
        throw new UnimplementedException();
    }

    public void removePositionCategory(String string) throws BadPositionCategoryException {
        throw new UnimplementedException();
    }

    public String[] getPositionCategories() {
        throw new UnimplementedException();
    }

    public boolean containsPositionCategory(String string) {
        throw new UnimplementedException();
    }

    public void addPosition(Position position) throws BadLocationException {
        throw new UnimplementedException();
    }

    public void removePosition(Position position) {
        throw new UnimplementedException();
    }

    public void addPosition(String string, Position position) throws BadLocationException, BadPositionCategoryException {
        throw new UnimplementedException();
    }

    public void removePosition(String string, Position position) throws BadPositionCategoryException {
        throw new UnimplementedException();
    }

    public Position[] getPositions(String string) throws BadPositionCategoryException {
        throw new UnimplementedException();
    }

    public boolean containsPosition(String string, int n, int n2) {
        throw new UnimplementedException();
    }

    public int computeIndexInCategory(String string, int n) throws BadLocationException, BadPositionCategoryException {
        throw new UnimplementedException();
    }

    public void addPositionUpdater(IPositionUpdater iPositionUpdater) {
        throw new UnimplementedException();
    }

    public void removePositionUpdater(IPositionUpdater iPositionUpdater) {
        throw new UnimplementedException();
    }

    public void insertPositionUpdater(IPositionUpdater iPositionUpdater, int n) {
        throw new UnimplementedException();
    }

    public IPositionUpdater[] getPositionUpdaters() {
        throw new UnimplementedException();
    }

    public String[] getLegalContentTypes() {
        throw new UnimplementedException();
    }

    public String getContentType(int n) throws BadLocationException {
        throw new UnimplementedException();
    }

    public ITypedRegion getPartition(int n) throws BadLocationException {
        throw new UnimplementedException();
    }

    public ITypedRegion[] computePartitioning(int n, int n2) throws BadLocationException {
        throw new UnimplementedException();
    }

    public void addDocumentPartitioningListener(IDocumentPartitioningListener iDocumentPartitioningListener) {
        throw new UnimplementedException();
    }

    public void removeDocumentPartitioningListener(IDocumentPartitioningListener iDocumentPartitioningListener) {
        throw new UnimplementedException();
    }

    public void setDocumentPartitioner(IDocumentPartitioner iDocumentPartitioner) {
        throw new UnimplementedException();
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        throw new UnimplementedException();
    }

    public int getLineLength(int n) throws BadLocationException {
        if (n < 0 || n >= this.lines.length) {
            throw new BadLocationException();
        }
        if (n == this.lines.length - 1) {
            return this.buf.length - this.lines[this.lines.length - 1];
        }
        return this.lines[n + 1] - this.lines[n];
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        if (n < 0 || n > this.buf.length) {
            throw new BadLocationException();
        }
        return this.findLine(n);
    }

    public int getLineOffset(int n) throws BadLocationException {
        if (n < 0 || n >= this.lines.length) {
            throw new BadLocationException();
        }
        return this.lines[n];
    }

    public IRegion getLineInformation(int n) throws BadLocationException {
        if (n < 0 || n >= this.lines.length) {
            throw new BadLocationException();
        }
        int n2 = this.lines[n];
        int n3 = n == this.lines.length - 1 ? this.buf.length : this.lines[n + 1];
        return new Region(n2, n3 - n2);
    }

    public IRegion getLineInformationOfOffset(int n) throws BadLocationException {
        return this.getLineInformation(this.getLineOfOffset(n));
    }

    public int getNumberOfLines() {
        return this.lines.length;
    }

    public int getNumberOfLines(int n, int n2) throws BadLocationException {
        throw new UnimplementedException();
    }

    public int computeNumberOfLines(String string) {
        throw new UnimplementedException();
    }

    public String[] getLegalLineDelimiters() {
        return new String[]{"\r\n", "\n", "\r"};
    }

    public String getLineDelimiter(int n) throws BadLocationException {
        if (n < 0 || n >= this.lines.length) {
            throw new BadLocationException();
        }
        if (n == this.lines.length - 1) {
            return "";
        }
        int n2 = this.lines[n + 1] - 1;
        if (this.buf[n2] == '\r') {
            return "\r";
        }
        if (n2 > 0 && this.buf[n2 - 1] == '\r') {
            return "\r\n";
        }
        return "\n";
    }

    public int search(int n, String string, boolean bl, boolean bl2, boolean bl3) throws BadLocationException {
        throw new UnimplementedException();
    }
}

