/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.rnceditor.partition;

import com.objfac.rnceditor.RNCDocumentProvider;
import com.objfac.xmleditor.partition.scanner.BufferPartitionScanner;
import org.eclipse.jface.text.IDocument;

public class RNCBufferPartitionScanner
extends BufferPartitionScanner {
    private int fStartPos;
    private int[] fPositions;
    private int fPosIndex;

    public RNCBufferPartitionScanner() {
        super(RNCDocumentProvider.getRNCPartitionScanner());
    }

    public void setRange(char[] cArray) {
        super.setRange(cArray);
        this.fStartPos = 0;
        this.fPositions = new int[4];
        this.fPosIndex = 0;
    }

    public int getPos() {
        return this.fOffset;
    }

    public void setPos(int n) {
        int n2 = n;
        while (this.fPosIndex > 0 && n < this.fPositions[this.fPosIndex - 1]) {
            this.fPosIndex -= 2;
            n2 = this.fPositions[this.fPosIndex];
        }
        this.fOffset = Math.min(n, n2);
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        super.setRange(iDocument, n, n2);
        this.fStartPos = n;
        this.fPositions = new int[4];
        this.fPosIndex = 0;
    }

    private void pushPos(int n) {
        if (this.fPositions.length < this.fPosIndex + 2) {
            int n2 = Math.max(this.fPositions.length * 2, this.fPosIndex + 2);
            int[] nArray = new int[n2];
            System.arraycopy(this.fPositions, 0, nArray, 0, this.fPosIndex);
            this.fPositions = nArray;
        }
        this.fPositions[this.fPosIndex++] = n;
        this.fPositions[this.fPosIndex++] = this.getPos();
    }

    public int read() {
        int n;
        int n2 = this.getPos();
        int n3 = super.read();
        if (n3 < 0) {
            n3 = n = -1;
        }
        if (n3 == 92) {
            n = super.read();
            if (n == 120 && (n = super.read()) == 123) {
                int n4;
                int n5 = 0;
                while ((n4 = this.hex(n = super.read())) >= 0) {
                    n5 = n5 * 16 + n4;
                }
                if (n == 125) {
                    this.pushPos(n2);
                    return n5;
                }
            }
            this.setPos(n2 + 1);
        }
        return n3;
    }

    protected int hex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public void unread() {
        this.setPos(this.getPos() - 1);
    }
}

