/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.util.RewindableInputStream;
import com.objfac.xml.io.Encoding;
import com.objfac.xmleditor.BaseDocumentProvider;
import com.objfac.xmleditor.BaseEditorEnvironment;
import com.objfac.xmleditor.IEncodingProvider;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.IReaderStorage;
import com.objfac.xmleditor.extensions.XMLDocumentSetupParticipant;
import com.objfac.xmleditor.partition.XMLPartitionScanner;
import com.objfac.xmleditor.partition.XMLPartitioner;
import com.objfac.xmleditor.preferences.XMLEncodingHandler;
import com.objfac.xmleditor.resources.XMLConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class XMLDocumentProvider
extends BaseDocumentProvider
implements IEncodingProvider {
    private static XMLPartitionScanner fScanner = null;
    String fEncoding;
    private boolean fFakeDefault = false;

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument = super.createDocument(object);
        XMLDocumentProvider.setPartitioner(iDocument);
        return iDocument;
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IReaderStorage) {
            IReaderStorage iReaderStorage = (IReaderStorage)iEditorInput;
            return this.setDocumentContent(iDocument, iReaderStorage.getCharContents());
        }
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            InputStream inputStream = iFile.getContents(false);
            if (string != null && ("UTF8".equals(string) || "UTF-8".equals(string))) {
                RewindableInputStream rewindableInputStream = new RewindableInputStream(inputStream);
                try {
                    if (rewindableInputStream.read() != 239 || rewindableInputStream.read() != 187 || rewindableInputStream.read() != 191) {
                        rewindableInputStream.rewind(0);
                    }
                }
                catch (IOException iOException) {
                    rewindableInputStream.rewind(0);
                }
                inputStream = rewindableInputStream;
            }
            this.setDocumentContent(iDocument, inputStream, string);
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IReaderStorage) {
            IReaderStorage iReaderStorage = (IReaderStorage)iEditorInput;
            return this.setDocumentContent(iDocument, iReaderStorage.getCharContents());
        }
        return super.setDocumentContent(iDocument, iEditorInput);
    }

    protected String getPersistedEncoding(Object object) {
        return super.getPersistedEncoding(object);
    }

    protected boolean setDocumentContent(IDocument iDocument, Reader reader) {
        try {
            iDocument.set(Misc.read((Reader)reader));
            return true;
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
            return false;
        }
    }

    public static IDocument createXMLDocument(String string) {
        Document document = new Document(string);
        XMLDocumentProvider.setPartitioner((IDocument)document);
        return document;
    }

    private static void setPartitioner(IDocument iDocument) {
        if (iDocument != null) {
            XMLDocumentSetupParticipant.setupPartitioner(iDocument);
        }
    }

    public static IDocumentPartitioner createXMLPartitioner() {
        return new XMLPartitioner((ITokenScanner)XMLDocumentProvider.getXMLPartitionScanner(), XMLConstants.TYPES);
    }

    public static XMLPartitionScanner getXMLPartitionScanner() {
        if (fScanner == null) {
            fScanner = new XMLPartitionScanner();
        }
        return fScanner;
    }

    public String getEncoding(Object object) {
        this.fEncoding = null;
        if (object instanceof IStorageEditorInput) {
            StorageDocumentProvider.StorageInfo storageInfo = (StorageDocumentProvider.StorageInfo)this.getElementInfo(object);
            if (storageInfo != null && storageInfo.fEncoding != null) {
                return storageInfo.fEncoding;
            }
            XMLEncodingHandler xMLEncodingHandler = XMLPlugin.getEncodingHandler();
            this.fEncoding = xMLEncodingHandler.getEncoding(object, null);
        }
        return this.fEncoding;
    }

    public String getEncoding(Object object, IDocument iDocument) {
        StorageDocumentProvider.StorageInfo storageInfo;
        XMLEncodingHandler xMLEncodingHandler = XMLPlugin.getEncodingHandler();
        this.fEncoding = xMLEncodingHandler.getEncoding(object, iDocument);
        if (object instanceof IStorageEditorInput && (storageInfo = (StorageDocumentProvider.StorageInfo)this.getElementInfo(object)) != null) {
            storageInfo.fEncoding = this.fEncoding;
        }
        return this.fEncoding;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = super.createElementInfo(object);
        if (object instanceof IStorageEditorInput) {
            ((StorageDocumentProvider.StorageInfo)elementInfo).fEncoding = this.fEncoding;
        }
        return elementInfo;
    }

    private byte[] getBytes(Object object, IDocument iDocument) throws UnsupportedEncodingException {
        byte[] byArray = null;
        String string = iDocument.get();
        String string2 = this.getEncoding(object, iDocument);
        try {
            byArray = string.getBytes(string2);
        }
        catch (Exception exception) {
            try {
                String string3 = Encoding.getJavaEquivalent((String)string2);
                try {
                    if (string3 != null) {
                        byArray = string.getBytes(string3);
                    }
                }
                catch (Exception exception2) {}
                if (byArray == null) {
                    XMLPlugin.log("Save error converting to encoding " + string2);
                    XMLPlugin.log(exception);
                    string2 = ResourcesPlugin.getEncoding();
                    byArray = string.getBytes(string2);
                }
            }
            catch (Exception exception3) {
                XMLPlugin.log("Save error converting to workbench default encoding " + string2);
                XMLPlugin.log(exception3);
                byArray = string.getBytes();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (!(object instanceof IFileEditorInput)) {
            super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
            return;
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getBytes(object, iDocument));
            IFile iFile = iFileEditorInput.getFile();
            if (iFile.exists()) {
                FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, (IResource)iFile);
                }
                this.fireElementStateChanging(object);
                try {
                    iFile.setContents((InputStream)byteArrayInputStream, bl, true, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    throw coreException;
                }
                catch (RuntimeException runtimeException) {
                    this.fireElementStateChangeFailed(object);
                    throw runtimeException;
                }
                if (fileInfo == null) return;
                ResourceMarkerAnnotationModel resourceMarkerAnnotationModel = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                resourceMarkerAnnotationModel.updateMarkers(fileInfo.fDocument);
                fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFile);
                return;
            }
            try {
                iProgressMonitor.beginTask(Local.getString((String)"Saving file"), 2000);
                ContainerGenerator containerGenerator = new ContainerGenerator(iFile.getParent().getFullPath());
                containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                iFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var9_16 = null;
                iProgressMonitor.done();
                return;
            }
        }
        catch (IOException iOException) {
            Status status = new Status(4, "org.eclipse.ui", 0, iOException.getMessage(), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
    }

    public void setFakeDefault(boolean bl) {
        this.fFakeDefault = bl;
    }

    public String getDefaultEncoding() {
        if (this.fFakeDefault) {
            return this.fEncoding;
        }
        return super.getDefaultEncoding();
    }

    protected BaseEditorEnvironment getEditorEnvironment() {
        return XMLPlugin.getDefault().getEnvironment();
    }
}

