/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class XMLDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fOffset;
    protected IDocument fDocument;

    public void doubleClicked(ITextViewer iTextViewer) {
        this.fOffset = iTextViewer.getSelectedRange().x;
        if (this.fOffset < 0) {
            return;
        }
        this.fText = iTextViewer;
        this.fDocument = iTextViewer.getDocument();
        XMLEditor xMLEditor = (XMLEditor)XMLEditor.getEditorForDocument(this.fDocument);
        if (xMLEditor == null) {
            return;
        }
        XMLTree xMLTree = xMLEditor.getXMLTree();
        if (xMLTree == null) {
            return;
        }
        XMLNode[] xMLNodeArray = xMLTree.findNodes(this.fOffset);
        if (xMLNodeArray.length == 0) {
            return;
        }
        if (xMLNodeArray.length == 2) {
            if (xMLNodeArray[0].getType() == "com.objfac.xmlstarttag") {
                this.selectStartContents(xMLNodeArray[0]);
                return;
            }
            if (xMLNodeArray[1].getType() == "com.objfac.xmlendtag") {
                this.selectEndContents(xMLNodeArray[1]);
                return;
            }
            if (xMLNodeArray[0].getType() == "com.objfac.xmldoctypestart") {
                this.selectStartSubset(xMLNodeArray[0]);
                return;
            }
            if (xMLNodeArray[1].getType() == "com.objfac.xmldoctypeend") {
                this.selectEndSubset(xMLNodeArray[1]);
                return;
            }
        }
        if (this.fOffset == xMLNodeArray[0].getOffset() || this.fOffset == xMLNodeArray[0].getOffset() + xMLNodeArray[0].getLength()) {
            return;
        }
        this.selectWord(xMLNodeArray[0]);
    }

    private void selectEndSubset(XMLNode xMLNode) {
        int n;
        int n2 = n = xMLNode.getOffset();
        XMLNode xMLNode2 = xMLNode.parent;
        if (xMLNode2 != null && xMLNode2.getType() == "com.objfac.xmldoctypestart") {
            n2 = xMLNode2.getOffset() + xMLNode2.getLength();
        }
        this.setSelection(n2, n);
    }

    private void selectStartSubset(XMLNode xMLNode) {
        int n;
        int n2 = n = xMLNode.getOffset() + xMLNode.getLength();
        XMLNode xMLNode2 = xMLNode.lastChild;
        if (xMLNode2 != null) {
            n2 = xMLNode2.getType() == "com.objfac.xmldoctypeend" ? xMLNode2.getOffset() : xMLNode2.getOffset() + xMLNode2.getLength();
        }
        this.setSelection(n, n2);
    }

    private void selectWord(XMLNode xMLNode) {
        int n = xMLNode.getOffset();
        int n2 = n + xMLNode.getLength();
        int n3 = this.fOffset;
        int n4 = this.fOffset - 1;
        try {
            while (n3 < n2) {
                if (!XMLCharacter.isIDPart((char)this.fDocument.getChar(n3))) break;
                ++n3;
            }
            while (n4 >= n) {
                if (!XMLCharacter.isIDPart((char)this.fDocument.getChar(n4))) break;
                --n4;
            }
            this.setSelection(++n4, n3);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    private void setSelection(int n, int n2) {
        if (n < n2) {
            this.fText.setSelectedRange(n, n2 - n);
        } else {
            this.fText.setSelectedRange(n, 0);
        }
    }

    private void selectEndContents(XMLNode xMLNode) {
        int n;
        int n2 = n = xMLNode.getOffset();
        XMLNode xMLNode2 = xMLNode.parent;
        if (xMLNode2 != null && xMLNode2.getQName().equals(xMLNode.getQName())) {
            n2 = xMLNode2.getOffset() + xMLNode2.getLength();
        }
        this.setSelection(n2, n);
    }

    private void selectStartContents(XMLNode xMLNode) {
        int n = xMLNode.getOffset() + xMLNode.getLength();
        XMLNode xMLNode2 = xMLNode.lastChild;
        if (xMLNode2 == null) {
            return;
        }
        int n2 = xMLNode2.getOffset() + xMLNode2.getLength();
        if (xMLNode2.getType() == "com.objfac.xmlendtag" && xMLNode.getQName().equals(xMLNode2.getQName())) {
            n2 = xMLNode2.getOffset();
        }
        this.setSelection(n, n2);
    }
}

