/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor;

import com.objfac.util.Local;
import com.objfac.util.TabCalculator;
import com.objfac.walker.EmptyWalker;
import com.objfac.walker.IWalker;
import com.objfac.xml.Util;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.parsers.NSParser;
import com.objfac.xml.parsers.ParserInterruptedException;
import com.objfac.xml.parsers.TagParser;
import com.objfac.xml.schema.QName;
import com.objfac.xmleditor.BaseContentOutlinePage;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.BaseSourceViewerConfiguration;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.ICursorListener;
import com.objfac.xmleditor.IEditorEnvironment;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLDocumentProvider;
import com.objfac.xmleditor.XMLNewContentOutlinePage;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.Formatter;
import com.objfac.xmleditor.actions.ShiftEditor;
import com.objfac.xmleditor.actions.TransformAction;
import com.objfac.xmleditor.actions.XMLGenerateDTD;
import com.objfac.xmleditor.extensions.XMLDocumentSetupParticipant;
import com.objfac.xmleditor.format.XMLSourceViewerConfiguration;
import com.objfac.xmleditor.partition.PartitionUtils;
import com.objfac.xmleditor.partition.XMLPartitioner;
import com.objfac.xmleditor.preferences.XMLDTDSettings;
import com.objfac.xmleditor.preferences.XMLGeneralSettings;
import com.objfac.xmleditor.preferences.XMLSchemaSettings;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class XMLEditor
extends BaseEditor
implements ShiftEditor {
    private XMLNode fEndTagToFix;
    private XMLNode fDanglingParent;
    private TransformAction fTransformAction;
    private UncommentAction fUncommentAction;
    private CommentAction fCommentAction;
    private JoinElementsAction fJoinElementsAction;
    private SplitElementAction fSplitElementAction;
    private AddSchemaLocAction fAddSchemaLocationAction;
    private boolean fInAutoFlow;
    private XMLGeneralSettings fXMLPrimary;
    private XMLSchemaSettings fXMLXsdSettings;
    private XMLSchemaSettings fXMLRncSettings;
    private XMLSchemaSettings fXMLRngSettings;
    private boolean fAutoFillEndTag;
    private boolean fAutoRemoveEndTag;
    private boolean fAutoInsertEndTag;
    protected static HashSet fEditors = new HashSet();
    protected static final String VALIDATE = "com.objfac.xmleditor.topLevelMenu.validate";
    protected static final String CLEAR_VALIDATE = "com.objfac.xmleditor.topLevelMenu.clearvalidate";
    protected static final String FORMAT = "com.objfac.xmleditor.topLevelMenu.tempformat";
    protected static final String SELECT_TAG = "com.objfac.xmleditor.topLevelMenu.SelectTag";
    protected static final String GENERATE_DTD = "com.objfac.xmleditor.topLevelMenu.GenerateDTD";
    public static final int WFONLY = 0;
    public static final int USEDTD = 0;
    private static String[] fDoctypeResults = new String[3];
    protected XMLTree fTree;
    protected Position rootRange = new Position(0);
    protected Position doctRange = new Position(0);
    protected BaseEditor.DL fDocListener = new BaseEditor.DL();
    protected static final int DELAY = 500;
    protected Thread fParseThread;
    protected Object fParseLock = new Object();
    protected long fWakeup;
    protected boolean fAgain = false;
    protected String fDoctype;
    protected String fRoot;
    protected String fUrl;
    protected IEditorInput fParseInput;
    protected boolean fIgnoreSelectionChange;
    protected char[] fStopSet = new char[]{'<', '>', '\'', '\"', '[', '\r', '\n'};
    protected char[] fStartSet = new char[]{'<', '>', '\'', '\"', '=', ']', '\r', '\n'};
    protected static final int MOUSE_UP = 0;
    protected static final int KEY_UP = 1;
    protected CursorListener fCursorListener = new CursorListener();
    protected LinkedList fCursorListeners = new LinkedList();
    protected DTDParams fParseParams;
    protected DTDParams fOldParams;
    protected XMLNode fDanglingEndTag = null;
    protected XMLNode fFillEndTag = null;
    protected boolean fEndTagScheduled = false;
    private boolean fInitializing;
    static /* synthetic */ Class class$0;

    public XMLEditor(boolean bl) {
        super(bl);
        this.initPreferenceSettings();
        this.setWalker((IWalker)new EmptyWalker());
        this.fTree = new XMLTree();
        fEditors.add(this);
    }

    public Object getAdaptable(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.objfac.xmleditor.XMLEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this;
        }
        return super.getAdaptable(clazz);
    }

    public int getEditorKind() {
        return 0;
    }

    public String getEditorId() {
        return "com.objfac.xmleditor.XMLEditor";
    }

    public XMLEditor() {
        this(false);
    }

    private void initPreferenceSettings() {
        this.fXMLRngSettings = new XMLSchemaSettings("com.objfac.xmleditor.rng");
        this.fXMLRncSettings = new XMLSchemaSettings("com.objfac.xmleditor.rnc");
        this.fXMLXsdSettings = new XMLSchemaSettings("com.objfac.xmleditor.xsd");
        this.fXMLPrimary = new XMLGeneralSettings();
        this.updateAutoEndTag();
    }

    private void updateAutoEndTag() {
        IPreferenceStore iPreferenceStore = this.fEnv.getStore();
        this.fAutoFillEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.fillendtag");
        this.fAutoRemoveEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.removeendtag");
        this.fAutoInsertEndTag = iPreferenceStore.getBoolean("com.objfac.xmleditor.insertendtag");
    }

    protected void setEditorEnvironment() {
        this.fEnv = XMLPlugin.getDefault().getEnvironment();
    }

    protected FileDocumentProvider createDocumentProvider() {
        return new XMLDocumentProvider();
    }

    protected BaseSourceViewerConfiguration createSourceViewerConfiguration(IEditorEnvironment iEditorEnvironment, TabCalculator tabCalculator) {
        return new XMLSourceViewerConfiguration(iEditorEnvironment, tabCalculator);
    }

    public static void invalidatePresentations() {
        Iterator iterator = fEditors.iterator();
        while (iterator.hasNext()) {
            XMLEditor xMLEditor = (XMLEditor)iterator.next();
            ISourceViewer iSourceViewer = xMLEditor.getSourceViewer();
            iSourceViewer.invalidateTextPresentation();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = Local.getBundle();
        ContentAssistAction contentAssistAction = new ContentAssistAction(resourceBundle, "ContentAssistProposal.", (ITextEditor)this);
        contentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)contentAssistAction);
        TextOperationAction textOperationAction = new TextOperationAction(Local.getBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)textOperationAction);
        textOperationAction = new TextOperationAction(Local.getBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        textOperationAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)textOperationAction);
    }

    protected void checkAuto(IDocument iDocument) {
        this.fOldParams = this.getDTDParams();
        if (this.fOldParams.auto) {
            this.doAuto(iDocument);
        }
    }

    protected void doAuto(IDocument iDocument) {
        Object object;
        String string = null;
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getDoctype();
        if (xMLNode != null && xMLNode.getType() == "com.objfac.xmldoctypestart") {
            int n;
            int n2 = n = xMLNode.getOffset() + xMLNode.getLength();
            object = xMLNode.lastChild;
            if (object != null) {
                n2 = object.getType() == "com.objfac.xmldoctypeend" ? object.getOffset() : object.getOffset() + object.getLength();
            }
            if (n < n2) {
                try {
                    string = this.getSourceViewer().getDocument().get(n, n2 - n);
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
        XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
        char[] cArray = string != null ? string.toCharArray() : null;
        object = XMLGenerateDTD.generate(this, iDocument);
        String string2 = "#generated";
        IWalker iWalker = xMLSchemaReaderShell.backgroundReadSchema(cArray, this.getUrl(), (char[])object, string2, string2, this.getResourceWatcherCallback());
        if (iWalker != null) {
            this.setWalker(iWalker);
        }
    }

    public static IWalker getWalkerForDocument(IDocument iDocument) {
        XMLEditor xMLEditor = (XMLEditor)XMLEditor.getEditorForDocument(iDocument);
        if (xMLEditor != null) {
            return xMLEditor.getWalker();
        }
        return null;
    }

    public int getValidationType(DTDParams dTDParams) {
        if (dTDParams.pub != null || dTDParams.sys != null) {
            return 0;
        }
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getDoctype();
        if (xMLNode != null && xMLNode.getType() == "com.objfac.xmldoctypestart") {
            XMLNode xMLNode2 = xMLNode.firstChild;
            while (xMLNode2 != null) {
                String string = xMLNode2.getType();
                if (string == "com.objfac.xmlelement" || string == "com.objfac.xmlattlist") {
                    return 0;
                }
                xMLNode2 = xMLNode2.nextSibling;
            }
        }
        return 0;
    }

    public DTDParams getDTDParams() {
        String[] stringArray;
        String[] stringArray2;
        Object object;
        List list;
        Object object2;
        Object object3;
        String string;
        int n;
        Object object4;
        DTDParams dTDParams = new DTDParams();
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getDoctype();
        if (xMLNode != null) {
            int n2 = 0;
            int n3 = 0;
            if (xMLNode.getType() == "com.objfac.xmldoctypestart") {
                n3 = n2 = xMLNode.getLength();
                object4 = xMLNode.getLastChild();
                if (object4 != null) {
                    n3 = object4.getType() == "com.objfac.xmldoctypeend" ? object4.getOffset() : object4.getOffset() + object4.getLength();
                    n3 -= xMLNode.getOffset();
                }
            }
            dTDParams.beg = n2;
            dTDParams.end = n3;
            object4 = xMLNode.getContents();
            Util.parseDoctype((String)object4, (String[])fDoctypeResults);
            dTDParams.epub = fDoctypeResults[1];
            dTDParams.esys = fDoctypeResults[2];
        }
        boolean bl = dTDParams.epub == null && dTDParams.esys == null && dTDParams.beg == dTDParams.end;
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            dTDParams.prim = this.fXMLPrimary.isSchemaPrimary(iFile);
        }
        if ((n = this.getEditorKind()) == 2) {
            dTDParams.trng = true;
            dTDParams.url = "";
            return dTDParams;
        }
        if (n == 4) {
            dTDParams.trng = true;
            dTDParams.url = "";
            return dTDParams;
        }
        if (n == 1) {
            dTDParams.tdtd = true;
            dTDParams.pub = null;
            dTDParams.sys = this.getUrl();
            return dTDParams;
        }
        if (n == 6) {
            dTDParams.trng = true;
            dTDParams.url = "";
            return dTDParams;
        }
        object4 = xMLTree.getRoot();
        if (object4 != null && (string = ((XMLNode)object4).getPrefix("http://www.w3.org/2001/XMLSchema-instance")) != null) {
            object3 = String.valueOf(string == "" ? "" : String.valueOf(string) + ':') + "schemaLocation";
            object2 = String.valueOf(string == "" ? "" : String.valueOf(string) + ':') + "noNamespaceSchemaLocation";
            list = ((XMLNode)object4).getAttributeList();
            object = list.iterator();
            while (object.hasNext()) {
                stringArray2 = (String[])object.next();
                if (!object.hasNext()) break;
                stringArray = (String[])object.next();
                if (!((String)object3).equals(stringArray2) && !((String)object2).equals(stringArray2)) continue;
                dTDParams.exsd = true;
                dTDParams.txsd = true;
                dTDParams.url = stringArray;
                return dTDParams;
            }
        }
        if (iEditorInput instanceof IFileEditorInput) {
            object4 = ((IFileEditorInput)iEditorInput).getFile();
            string = this.fXMLRngSettings.getCurrentUse((IFile)object4);
            if (string.equals("this")) {
                dTDParams.trng = true;
                dTDParams.url = this.fXMLRngSettings.getCurrentSystemId((IFile)object4);
                return dTDParams;
            }
            if (string.equals("pref") && (object3 = this.fXMLRngSettings.getMatch().intern()) != "no") {
                dTDParams.matc = true;
                object2 = xMLTree.getRoot();
                if (object2 != null) {
                    list = ((XMLNode)object2).getQName(new QName());
                    object = this.fXMLRngSettings.getMatchRows();
                    int n4 = 0;
                    while (n4 < ((ArrayList)object).size()) {
                        stringArray = (String[])((ArrayList)object).get(n4);
                        if (object3 == "root" && ((QName)list).localname.equals(stringArray[0]) || object3 == "ns" && ((QName)list).namespace.equals(stringArray[1]) || object3 == "rootandns" && ((QName)list).localname.equals(stringArray[0]) && ((QName)list).namespace.equals(stringArray[1])) {
                            dTDParams.url = stringArray[2];
                            dTDParams.trng = true;
                            return dTDParams;
                        }
                        ++n4;
                    }
                }
            }
            if ((string = this.fXMLRncSettings.getCurrentUse((IFile)object4)).equals("this")) {
                dTDParams.trnc = true;
                dTDParams.url = this.fXMLRncSettings.getCurrentSystemId((IFile)object4);
                return dTDParams;
            }
            if (string.equals("pref") && (object3 = this.fXMLRncSettings.getMatch().intern()) != "no") {
                dTDParams.matc = true;
                object2 = xMLTree.getRoot();
                if (object2 != null) {
                    list = ((XMLNode)object2).getQName(new QName());
                    object = this.fXMLRncSettings.getMatchRows();
                    int n5 = 0;
                    while (n5 < ((ArrayList)object).size()) {
                        stringArray = (String[])((ArrayList)object).get(n5);
                        if (object3 == "root" && ((QName)list).localname.equals(stringArray[0]) || object3 == "ns" && ((QName)list).namespace.equals(stringArray[1]) || object3 == "rootandns" && ((QName)list).localname.equals(stringArray[0]) && ((QName)list).namespace.equals(stringArray[1])) {
                            dTDParams.url = stringArray[2];
                            dTDParams.trnc = true;
                            return dTDParams;
                        }
                        ++n5;
                    }
                }
            }
            if ((string = this.fXMLXsdSettings.getCurrentUse((IFile)object4)).equals("this")) {
                dTDParams.txsd = true;
                dTDParams.url = this.fXMLXsdSettings.getCurrentSystemId((IFile)object4);
                dTDParams.nxsd = true;
                return dTDParams;
            }
            if (string.equals("pref") && (object3 = this.fXMLXsdSettings.getMatch().intern()) != "no") {
                dTDParams.matc = true;
                object2 = xMLTree.getRoot();
                if (object2 != null) {
                    list = ((XMLNode)object2).getQName(new QName());
                    object = this.fXMLXsdSettings.getMatchRows();
                    int n6 = 0;
                    while (n6 < ((ArrayList)object).size()) {
                        stringArray = (String[])((ArrayList)object).get(n6);
                        if (((QName)list).localname.equals(stringArray[0]) && ((QName)list).namespace.length() == 0) {
                            dTDParams.url = stringArray[2];
                            dTDParams.txsd = true;
                            dTDParams.nxsd = true;
                            return dTDParams;
                        }
                        if (((QName)list).namespace.length() > 0 && ((QName)list).namespace.equals(stringArray[1])) {
                            dTDParams.txsd = true;
                            dTDParams.url = stringArray[2];
                            return dTDParams;
                        }
                        ++n6;
                    }
                }
            }
            if (bl) {
                string = XMLDTDSettings.getCurrentHandling((IFile)object4);
                if (string.equals("auto")) {
                    dTDParams.auto = true;
                    return dTDParams;
                }
                if (string.equals("none")) {
                    dTDParams.none = true;
                    return dTDParams;
                }
                if (string.equals("this")) {
                    dTDParams.tdtd = true;
                    dTDParams.pub = XMLDTDSettings.getCurrentPublicId((IFile)object4);
                    dTDParams.sys = XMLDTDSettings.getCurrentSystemId((IFile)object4);
                    return dTDParams;
                }
                if (XMLDTDSettings.isMatch()) {
                    dTDParams.matc = true;
                    object3 = xMLTree.getRoot();
                    if (object3 != null) {
                        object2 = ((XMLNode)object3).getQName();
                        list = XMLDTDSettings.getMatchRows();
                        int n7 = 0;
                        while (n7 < ((ArrayList)list).size()) {
                            stringArray2 = (String[])((ArrayList)list).get(n7);
                            if (((String)object2).equals(stringArray2[0])) {
                                dTDParams.pub = stringArray2[1];
                                dTDParams.sys = stringArray2[2];
                                dTDParams.tdtd = true;
                                return dTDParams;
                            }
                            ++n7;
                        }
                    }
                }
            }
        }
        if (bl) {
            dTDParams.auto = XMLDTDSettings.isAuto();
        }
        return dTDParams;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        this.checkAuto(this.getDocument());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public XMLTree getXMLTree() {
        return this.fTree;
    }

    private SplitElementAction getSplitElementAction() {
        if (this.fSplitElementAction == null) {
            this.fSplitElementAction = new SplitElementAction();
        }
        return this.fSplitElementAction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void splitElement() {
        XMLNode xMLNode = this.splittableElement();
        if (xMLNode == null) return;
        String string = this.splittableElementName(xMLNode);
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer == null) return;
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelectionRange();
        IDocument iDocument = this.getDocument();
        this.beginCompoundChange();
        try {
            block8: {
                try {
                    String string2 = xMLNode.getType();
                    if (string2 == "com.objfac.xmlcomment") {
                        iDocument.replace(point.x, 0, "--><!--");
                        iSourceViewer.setSelectedRange(point.x + "-->".length(), 0);
                        break block8;
                    }
                    if (string2 == "com.objfac.xmlcdata") {
                        iDocument.replace(point.x, 0, "]]><![CDATA[");
                        iSourceViewer.setSelectedRange(point.x + "]]>".length(), 0);
                        break block8;
                    }
                    String string3 = xMLNode.getContents();
                    String string4 = "</" + string + ">";
                    iDocument.replace(point.x, 0, String.valueOf(string4) + string3);
                    Point point2 = new Point(point.x + string4.length(), string3.length());
                    iSourceViewer.setSelectedRange(point.x + string4.length(), string3.length());
                    Formatter formatter = new Formatter();
                    if (formatter.backgroundFormat(iDocument, this.getXMLTree(), this.getWalker(), point2, this.getTabWidth(), this.getSpacesForTabs(), this.getWrapMargin())) {
                        formatter.applyFormat(iDocument, iSourceViewer);
                    }
                    Point point3 = styledText.getSelectionRange();
                    iSourceViewer.setSelectedRange(point3.x + point3.y, 0);
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.endCompoundChange();
            throw throwable;
        }
        this.endCompoundChange();
    }

    private XMLNode splittableElement() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            StyledText styledText = iSourceViewer.getTextWidget();
            Point point = styledText.getSelectionRange();
            if (point.y == 0) {
                XMLTree xMLTree = this.getXMLTree();
                XMLNode xMLNode = xMLTree.findExactNode(point.x);
                if (point.x == xMLNode.getOffset() && point.x > 0 && xMLNode.getType() != "com.objfac.xmltext" && xMLNode.getType() != "com.objfac.xmlendtag") {
                    xMLNode = xMLTree.findExactNode(point.x - 1);
                }
                switch (XMLConstants.getIntType(xMLNode.getType())) {
                    case 0: {
                        int n = xMLNode.getOffset() + "<!--".length();
                        int n2 = xMLNode.getOffset() + xMLNode.getLength() - "-->".length();
                        if (point.x < n || point.x > n2) break;
                        return xMLNode;
                    }
                    case 5: {
                        int n = xMLNode.getOffset() + "<![CDATA[".length();
                        int n3 = xMLNode.getOffset() + xMLNode.getLength() - "]]>".length();
                        if (point.x < n || point.x > n3) break;
                        return xMLNode;
                    }
                    case 4: 
                    case 11: {
                        return xMLNode.getParent();
                    }
                }
            }
        }
        return null;
    }

    public String splittableElementName() {
        return this.splittableElementName(this.splittableElement());
    }

    public String splittableElementName(XMLNode xMLNode) {
        if (xMLNode != null) {
            String string = xMLNode.getType();
            if (string == "com.objfac.xmlcomment") {
                return "<!--";
            }
            if (string == "com.objfac.xmlcdata") {
                return "<![CDATA[";
            }
            return xMLNode.getQName();
        }
        return null;
    }

    public String joinableElementName() {
        return this.joinableElementName(this.joinableElement());
    }

    private String joinableElementName(XMLNode xMLNode) {
        return this.splittableElementName(xMLNode);
    }

    private XMLNode joinableElement() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            StyledText styledText = iSourceViewer.getTextWidget();
            Point point = styledText.getSelectionRange();
            if (point.y == 0) {
                XMLTree xMLTree = this.getXMLTree();
                XMLNode xMLNode = xMLTree.findExactNode(point.x);
                switch (XMLConstants.getIntType(xMLNode.getType())) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 5: {
                        return this.previousNodeSame(xMLNode);
                    }
                    case 4: 
                    case 11: {
                        return this.previousNodeSame(xMLNode.getParent());
                    }
                }
            }
        }
        return null;
    }

    private XMLNode previousNodeSame(XMLNode xMLNode) {
        XMLNode xMLNode2 = this.getPreviousNode(xMLNode);
        if (xMLNode2 != null) {
            if (xMLNode.getType() == "com.objfac.xmlcomment") {
                if (xMLNode2.getType() == "com.objfac.xmlcomment") {
                    return xMLNode;
                }
            } else if (xMLNode.getType() == "com.objfac.xmlcdata") {
                if (xMLNode2.getType() == "com.objfac.xmlcdata") {
                    return xMLNode;
                }
            } else {
                if (xMLNode2.getType() == "com.objfac.xmlendtag") {
                    xMLNode2 = xMLNode2.getParent();
                }
                if (xMLNode2 != null && (xMLNode2.getType() == "com.objfac.xmlstarttag" || xMLNode2.getType() == "com.objfac.xmlemptytag")) {
                    String string = xMLNode.getLocalname();
                    String string2 = xMLNode.getNamespace();
                    String string3 = xMLNode2.getLocalname();
                    String string4 = xMLNode2.getNamespace();
                    if (string.equals(string3) && (string2 == null ? string4 == null : string2.equals(string4))) {
                        return xMLNode;
                    }
                }
            }
        }
        return null;
    }

    private XMLNode getPreviousNode(XMLNode xMLNode) {
        if (xMLNode != null && xMLNode.getOffset() > 0) {
            XMLTree xMLTree = this.getXMLTree();
            XMLNode xMLNode2 = xMLTree.findExactNode(xMLNode.getOffset() - 1);
            while (xMLNode2.getType() == "com.objfac.xmltext" && xMLNode2.getOffset() > 0 && XMLCharacter.isWhitespace((String)xMLNode2.getContents())) {
                xMLNode2 = xMLTree.findExactNode(xMLNode2.getOffset() - 1);
            }
            return xMLNode2;
        }
        return null;
    }

    private JoinElementsAction getJoinElementsAction() {
        if (this.fJoinElementsAction == null) {
            this.fJoinElementsAction = new JoinElementsAction();
        }
        return this.fJoinElementsAction;
    }

    public void joinElements() {
        XMLNode xMLNode = this.joinableElement();
        if (xMLNode != null) {
            XMLNode xMLNode2 = this.getPreviousNode(xMLNode);
            if (xMLNode.getType() == "com.objfac.xmlcomment") {
                this.joinComments(xMLNode2, xMLNode);
            } else if (xMLNode.getType() == "com.objfac.xmlcdata") {
                this.joinCData(xMLNode2, xMLNode);
            } else {
                if (xMLNode2.getType() == "com.objfac.xmlendtag") {
                    xMLNode2 = xMLNode2.getParent();
                }
                this.joinElements(xMLNode2, xMLNode);
            }
        }
    }

    private void joinComments(XMLNode xMLNode, XMLNode xMLNode2) {
        int n = xMLNode2.getOffset() + "<!--".length();
        int n2 = xMLNode.getOffset() + xMLNode.getLength() - "-->".length();
        this.joinRemove(n2, n);
    }

    private void joinRemove(int n, int n2) {
        IDocument iDocument = this.getDocument();
        try {
            ISourceViewer iSourceViewer = this.getViewer();
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            iDocument.replace(n, n2 - n, "");
            int n3 = point.x;
            if (n3 > n2) {
                n3 -= n2 - n;
            } else if (n3 > n) {
                n3 = n;
            }
            iSourceViewer.setSelectedRange(n3, 0);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
    }

    private void joinCData(XMLNode xMLNode, XMLNode xMLNode2) {
        int n = xMLNode2.getOffset() + "<![CDATA[".length();
        int n2 = xMLNode.getOffset() + xMLNode.getLength() - "]]>".length();
        this.joinRemove(n2, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void joinElements(XMLNode xMLNode, XMLNode xMLNode2) {
        int n;
        int n2;
        XMLNode xMLNode3;
        boolean bl;
        boolean bl2 = xMLNode.getType() == "com.objfac.xmlemptytag";
        boolean bl3 = bl = xMLNode2.getType() == "com.objfac.xmlemptytag";
        if (!bl2) {
            xMLNode3 = xMLNode.getLastChild();
            if (xMLNode3 == null) return;
            if (xMLNode3.getType() != "com.objfac.xmlendtag") return;
            if (!xMLNode3.getQName().equals(xMLNode.getQName())) {
                return;
            }
            n2 = !bl ? xMLNode3.getOffset() : xMLNode3.getOffset() + xMLNode3.getLength();
            n = xMLNode2.getOffset() + xMLNode2.getLength();
        } else {
            n2 = xMLNode.getOffset();
            n = xMLNode2.getOffset();
        }
        this.beginCompoundChange();
        try {
            this.joinRemove(n2, n);
            xMLNode3 = this.getViewer();
            IDocument iDocument = this.getDocument();
            Point point = xMLNode3.getTextWidget().getSelectionRange();
            Formatter formatter = new Formatter();
            if (formatter.backgroundFormat(iDocument, this.getXMLTree(), this.getWalker(), point, this.getTabWidth(), this.getSpacesForTabs(), this.getWrapMargin())) {
                formatter.applyFormat(iDocument, (ISourceViewer)xMLNode3);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.endCompoundChange();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.endCompoundChange();
    }

    private UncommentAction getUncommentAction() {
        if (this.fUncommentAction == null) {
            this.fUncommentAction = new UncommentAction();
        }
        return this.fUncommentAction;
    }

    private CommentAction getCommentAction() {
        if (this.fCommentAction == null) {
            this.fCommentAction = new CommentAction();
        }
        return this.fCommentAction;
    }

    public boolean canComment() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            XMLTree xMLTree = this.getXMLTree();
            XMLNode xMLNode = xMLTree.findExactNode(point.x);
            XMLNode xMLNode2 = xMLTree.findExactNode(point.x + point.y);
            return xMLNode != null && xMLNode2 != null && (xMLNode.getType() == "com.objfac.xmltext" && xMLNode2.getType() == "com.objfac.xmltext" || point.x == xMLNode.getOffset() && point.x + point.y == xMLNode2.getOffset());
        }
        return false;
    }

    public void comment() {
        if (!this.canComment()) {
            return;
        }
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            IDocument iDocument = this.getDocument();
            try {
                if (point.y == 0) {
                    iDocument.replace(point.x, 0, "<!---->");
                    iSourceViewer.setSelectedRange(point.x + "<!--".length(), 0);
                } else {
                    String string = iDocument.get(point.x, point.y);
                    string = "<!--" + this.hideNestedComments(string) + "-->";
                    iDocument.replace(point.x, point.y, string);
                    iSourceViewer.setSelectedRange(point.x, string.length());
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
    }

    private String hideNestedComments(String string) {
        int n = string.indexOf("--");
        int n2 = 0;
        int n3 = string.length();
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 0) {
            stringBuffer.append(cArray, n2, n - n2);
            stringBuffer.append("-#");
            n2 = ++n;
            n = string.indexOf("--", n);
        }
        if (n2 < n3) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public void uncomment() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            XMLNode xMLNode = this.getXMLTree().findExactNode(point.x);
            if (xMLNode.getType() == "com.objfac.xmlcomment") {
                String string = xMLNode.getContents();
                int n = "<!--".length();
                int n2 = string.endsWith("-->") ? string.length() - "-->".length() : string.length();
                string = this.exposeNestedComments(string, n, n2);
                IDocument iDocument = this.getDocument();
                try {
                    iDocument.replace(xMLNode.getOffset(), xMLNode.getLength(), string);
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
                iSourceViewer.setSelectedRange(xMLNode.getOffset(), string.length());
            }
        }
    }

    private String exposeNestedComments(String string, int n, int n2) {
        if (string.indexOf("-#-", n) < 0) {
            return string.substring(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = "!-*-".length();
        int n5 = "*-".length();
        int n6 = n;
        while (n6 < n2) {
            char c = cArray[n6];
            if (c == '<') {
                if (n6 + n4 <= n2 && cArray[n6 + 1] == '!' && cArray[n6 + 2] == '-' && cArray[n6 + 3] == '#' && cArray[n6 + 4] == '-') {
                    n6 += n4;
                    if (n3 == 0) {
                        stringBuffer.append("<!--");
                    } else {
                        stringBuffer.append("<!-#-");
                    }
                    ++n3;
                } else {
                    stringBuffer.append('<');
                }
            } else if (c == '-') {
                if (n6 + n5 <= n2 && cArray[n6 + 1] == '#' && cArray[n6 + 2] == '-') {
                    if (n3 > 0 && n6 + n5 < n2 && cArray[n6 + 3] == '>') {
                        n6 += n5 + 1;
                        if (n3 == 1) {
                            stringBuffer.append("-->");
                        } else {
                            stringBuffer.append("-#->");
                        }
                        --n3;
                    } else {
                        ++n6;
                        if (n3 > 0) {
                            stringBuffer.append("-#");
                        } else {
                            stringBuffer.append('-');
                        }
                    }
                } else {
                    stringBuffer.append('-');
                }
            } else {
                stringBuffer.append(c);
            }
            ++n6;
        }
        return stringBuffer.toString();
    }

    protected BaseContentOutlinePage createContentOutlinePage() {
        return new XMLNewContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
    }

    protected void resetParseParams() {
        this.fOldParams = null;
    }

    protected void documentChanged(Position[] positionArray, IDocument iDocument, int n, int n2, int n3, boolean bl) {
        if (this.fInitializing) {
            return;
        }
        this.notifyCursorListeners();
        this.checkAutoFlow(iDocument, n, n2, n3);
        this.checkTagNameChanged(iDocument, n, n2, n3);
        if (bl) {
            this.checkAuto(iDocument);
        }
        boolean bl2 = bl;
        if (!bl) {
            if (this.getEditorKind() == 1) {
                bl = true;
            } else if (this.fOldParams != null && this.getDoctRange(this.doctRange).overlapsWith(n, n2)) {
                bl = true;
            } else if (this.fOldParams != null && (this.fOldParams.pref || this.fOldParams.txsd) && (this.fOldParams.matc || this.fOldParams.exsd) && this.getRootRange(this.rootRange).overlapsWith(n, n2)) {
                bl = true;
            }
        }
        if (bl) {
            String string;
            if (!bl2 || this.fOldParams == null) {
                this.fOldParams = this.getDTDParams();
            }
            if (!this.fOldParams.auto && !this.fOldParams.none && (string = this.getUrl()) != null) {
                this.parse(this.getXMLTree().getDoctypeContents(true), this.getRootContents(), string, this.getEditorInput(), this.fOldParams);
            }
        }
    }

    private void checkTagNameChanged(IDocument iDocument, int n, int n2, int n3) {
    }

    private boolean overlaps(int n, int n2, int n3, int n4) {
        return n4 > n && n2 > n3;
    }

    private void checkAutoFlow(IDocument iDocument, int n, int n2, int n3) {
        if (!this.fInAutoFlow && !this.isInUndoRedo() && n > 0 && this.shouldFlowLong(iDocument, n)) {
            this.doAutoFlow(iDocument, n);
        }
    }

    private boolean shouldFlowLong(IDocument iDocument, int n) {
        if (!this.getAutoFlowLong()) {
            return false;
        }
        try {
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            int n2 = this.getTabber().countWholeLine(string);
            if (n2 > this.getWrapMargin()) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        return false;
    }

    private void doAutoFlow(final IDocument iDocument, int n) {
        if (this.fInAutoFlow) {
            return;
        }
        final ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        final StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        this.fInAutoFlow = true;
        this.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block10: {
                    block9: {
                        block8: {
                            try {
                                if (styledText.isDisposed()) {
                                    Object var5_1 = null;
                                    break block8;
                                }
                                Point point = styledText.getSelectionRange();
                                if (!XMLEditor.this.shouldFlowLong(iDocument, point.x)) {
                                    break block9;
                                }
                                Formatter formatter = new Formatter();
                                if (!formatter.backgroundFormat(iDocument, XMLEditor.this.getXMLTree(), XMLEditor.this.getWalker(), point, XMLEditor.this.getTabWidth(), XMLEditor.this.getSpacesForTabs(), XMLEditor.this.getWrapMargin())) break block10;
                                XMLEditor.this.convertToCompoundChange();
                                try {
                                    formatter.applyFormat(iDocument, iSourceViewer);
                                }
                                catch (Throwable throwable) {
                                    Object var3_8 = null;
                                    XMLEditor.this.endCompoundChange();
                                    throw throwable;
                                }
                                {
                                    Object var3_9 = null;
                                    XMLEditor.this.endCompoundChange();
                                    break block10;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_3 = null;
                                XMLEditor.this.fInAutoFlow = false;
                                throw throwable;
                            }
                        }
                        XMLEditor.this.fInAutoFlow = false;
                        return;
                    }
                    Object var5_2 = null;
                    XMLEditor.this.fInAutoFlow = false;
                    return;
                }
                Object var5_4 = null;
                XMLEditor.this.fInAutoFlow = false;
            }
        });
    }

    protected void updateContentAssist() {
        this.fOldParams = this.getDTDParams();
        this.parse(this.getXMLTree().getDoctypeContents(true), this.getRootContents(), this.getUrl(), this.getEditorInput(), this.fOldParams);
    }

    private DTDParams getOldParams() {
        if (this.fOldParams == null) {
            this.fOldParams = this.getDTDParams();
        }
        return this.fOldParams;
    }

    protected boolean needValidate() {
        return this.getOldParams().txsd;
    }

    Position getRootRange(Position position) {
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getRoot();
        return this.copyPos((Position)xMLNode, position);
    }

    protected Position getDoctRange(Position position) {
        XMLNode xMLNode;
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode2 = xMLTree.getDoctype();
        this.copyPos((Position)xMLNode2, position);
        if (xMLNode2 != null && xMLNode2.getType() == "com.objfac.xmldoctypestart" && (xMLNode = xMLNode2.lastChild) != null) {
            if (xMLNode.getType() == "com.objfac.xmldoctypeend") {
                position.setLength(xMLNode.getOffset() - position.getOffset());
            } else {
                position.setLength(xMLNode.getOffset() + xMLNode.getLength() - position.getOffset());
            }
        }
        return position;
    }

    protected Position copyPos(Position position, Position position2) {
        if (position == null) {
            position2.setOffset(0);
            position2.setLength(0);
        } else {
            position2.setOffset(position.getOffset());
            position2.setLength(position.getLength());
        }
        return position2;
    }

    protected String getRootContents() {
        String string = null;
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getRoot();
        if (xMLNode != null) {
            string = xMLNode.getContents();
        }
        return string;
    }

    protected void notifyCursorListeners() {
        Iterator iterator = this.fCursorListeners.iterator();
        while (iterator.hasNext()) {
            ((ICursorListener)iterator.next()).modified();
        }
    }

    protected boolean notAllWS(IDocument iDocument, ITypedRegion iTypedRegion) {
        try {
            String string = iDocument.get(iTypedRegion.getOffset(), iTypedRegion.getLength());
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                if (!XMLCharacter.isWhitespace((char)c)) {
                    return false;
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string, String string2, String string3, IEditorInput iEditorInput, DTDParams dTDParams) {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return;
        }
        if (!Config.pro() && this.getEditorKind() != 0 && this.getEditorKind() != 1) {
            return;
        }
        if (dTDParams.txsd || this.getEditorKind() == 4) {
            return;
        }
        Object object = this.fParseLock;
        synchronized (object) {
            this.fWakeup = System.currentTimeMillis() + 500L;
            this.fDoctype = string;
            this.fRoot = string2;
            this.fUrl = string3;
            this.fParseInput = iEditorInput;
            this.fParseParams = dTDParams;
            if (this.fParseThread == null || !this.fParseThread.isAlive()) {
                this.fParseThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        while (true) {
                            Object object;
                            Object object2;
                            try {
                                DTDParams dTDParams;
                                IEditorInput iEditorInput;
                                String string;
                                Object object3 = XMLEditor.this.fParseLock;
                                synchronized (object3) {
                                    while (true) {
                                        long l;
                                        if ((l = System.currentTimeMillis()) >= XMLEditor.this.fWakeup) {
                                            object2 = XMLEditor.this.fDoctype;
                                            object = XMLEditor.this.fRoot;
                                            string = XMLEditor.this.fUrl;
                                            iEditorInput = XMLEditor.this.fParseInput;
                                            dTDParams = XMLEditor.this.fParseParams;
                                            break;
                                        }
                                        XMLEditor.this.fParseLock.wait(XMLEditor.this.fWakeup - l);
                                    }
                                }
                                boolean bl = false;
                                try {
                                    try {
                                        XMLEditor.this.setXmlParseState(dTDParams, true, bl);
                                        bl = XMLEditor.this.reallyParse((String)object2, (String)object, string, iEditorInput, dTDParams);
                                    }
                                    catch (ParserInterruptedException parserInterruptedException) {}
                                }
                                catch (Throwable throwable) {
                                    Object var7_11 = null;
                                    XMLEditor.this.setXmlParseState(dTDParams, false, bl);
                                    throw throwable;
                                }
                                {
                                    Object var7_9 = null;
                                    XMLEditor.this.setXmlParseState(dTDParams, false, bl);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (RuntimeException runtimeException) {
                                object = XMLEditor.this.fParseLock;
                                synchronized (object) {
                                    XMLEditor.this.fParseThread = null;
                                    throw runtimeException;
                                }
                            }
                            object2 = XMLEditor.this.fParseLock;
                            synchronized (object2) {
                                if (!XMLEditor.this.fAgain) {
                                    XMLEditor.this.fParseThread = null;
                                    XMLEditor.this.fUrl = null;
                                    XMLEditor.this.fDoctype = null;
                                    return;
                                }
                                XMLEditor.this.fAgain = false;
                            }
                        }
                    }
                };
                this.fParseThread.setName("XMLParseThread");
                this.fParseThread.setPriority((Thread.currentThread().getPriority() + 1) / 2);
                this.fParseThread.start();
            } else {
                this.fAgain = true;
                this.fParseThread.interrupt();
            }
        }
    }

    private void setXmlParseState(DTDParams dTDParams, boolean bl, boolean bl2) {
        int n = 0;
        n = dTDParams.txsd ? (bl ? 2 : (bl2 ? 5 : 8)) : (dTDParams.trnc || dTDParams.trng ? (bl ? 3 : (bl2 ? 6 : 9)) : (dTDParams.auto ? (bl ? 10 : (bl2 ? 11 : 12)) : (bl ? 1 : (bl2 ? 4 : 7))));
        this.setParseState(n);
    }

    protected boolean reallyParse(String string, String string2, String string3, IEditorInput iEditorInput, DTDParams dTDParams) {
        XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
        IWalker iWalker = xMLSchemaReaderShell.backgroundReadSchema(this.getEditorKind(), dTDParams, string3, null, string, this.getResourceWatcherCallback());
        if (iWalker != null) {
            this.setWalker(iWalker);
        }
        return iWalker != null && !(iWalker instanceof EmptyWalker);
    }

    protected String[] parseSchemaLocations(String string) {
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < cArray.length && XMLCharacter.isIDPart((char)cArray[n])) {
            stringBuffer.append(cArray[n]);
            ++n;
        }
        List list = TagParser.getAttributeList((char[])cArray, (int)0, (int)cArray.length);
        HashMap hashMap = new HashMap();
        hashMap.put("", null);
        NSParser.parseNS((List)list, hashMap);
        if (hashMap.size() == 1 && hashMap.get("") == null) {
            return new String[0];
        }
        String string3 = stringBuffer.toString();
        String string4 = "";
        int n2 = string3.lastIndexOf(58);
        if (n2 >= 0) {
            string4 = string3.substring(0, n2);
            string3 = string3.substring(n2 + 1);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(string2 = (String)hashMap.get(string4)) && string3.equals("schema")) {
            linkedList.add("http://www.w3.org/2001/XMLSchema.xsd");
        }
        Iterator iterator = list.iterator();
        block1: while (iterator.hasNext()) {
            String string5;
            boolean bl;
            String string6;
            String string7 = (String)iterator.next();
            String string8 = (String)iterator.next();
            String string9 = "";
            int n3 = string7.lastIndexOf(58);
            if (n3 >= 0) {
                string9 = string7.substring(0, n3);
            }
            if ((string6 = (String)hashMap.get(string9)) == null || !string6.equals("http://www.w3.org/2001/XMLSchema-instance") || !(bl = (string5 = string7.substring(n3 + 1)).equals("schemaLocation")) && !string5.equals("noNamespaceSchemaLocation")) continue;
            List list2 = XMLEditor.listValueToList(string8);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                if (bl) {
                    iterator2.next();
                    if (!iterator2.hasNext()) continue block1;
                }
                linkedList.add((String)iterator2.next());
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static List listValueToList(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        int n = -1;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (XMLCharacter.isWhitespace((char)c)) {
                if (bl) {
                    linkedList.add(string.substring(n, n3));
                    n = n2;
                    bl = false;
                }
            } else if (!bl) {
                n = n3;
                bl = true;
            }
            ++n3;
        }
        if (n >= 0 && n < n2) {
            linkedList.add(string.substring(n));
        }
        return linkedList;
    }

    public static ITypedRegion getPartition(IDocument iDocument, int n) {
        Assert.isTrue((iDocument != null ? 1 : 0) != 0, (String)"null document");
        return PartitionUtils.getPartition(iDocument, "com.objfac.xmlpartitioner", n, false);
    }

    public ITypedRegion getPartition(int n) {
        return XMLEditor.getPartition(this.getDocument(), n);
    }

    protected boolean isSelectionChanging() {
        return this.fIgnoreSelectionChange;
    }

    protected void setSelectionChanging(boolean bl) {
        this.fIgnoreSelectionChange = bl;
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        StyledText styledText = this.getSourceViewer().getTextWidget();
        styledText.addMouseListener((MouseListener)this.fCursorListener);
        styledText.addKeyListener((KeyListener)this.fCursorListener);
    }

    public void dispose() {
        fEditors.remove(this);
        super.dispose();
    }

    protected void verifyKey(VerifyEvent verifyEvent) {
    }

    /*
     * Unable to fully structure code
     */
    protected int posLeft(IDocument var1_1, int var2_2) {
        block14: {
            block15: {
                if (var2_2 <= 0) break block14;
                v0 = --var2_2;
                --var2_2;
                var3_3 = this.get(var1_1, v0);
                while (var3_3 == ' ' || var3_3 == '\t') {
                    if (var2_2 < 0) break;
                    var3_3 = this.get(var1_1, var2_2--);
                }
                if (var2_2 < 0) break block15;
                switch (var3_3) {
                    case '\n': {
                        if (var2_2 < 0 || this.get(var1_1, var2_2) != '\r') break;
                        --var2_2;
                        break;
                    }
                    case '\r': 
                    case ';': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (var2_2 < 0 || this.get(var1_1, var2_2) != '=') break;
                        --var2_2;
                        break;
                    }
                    case '[': {
                        if (var2_2 - 2 < 0) break;
                        var4_4 = this.get(var1_1, var2_2 - 2, 3);
                        if (var4_4.equals("<[[")) {
                            var2_2 -= 3;
                            break;
                        }
                        if (!var4_4.equals("TA[") || var2_2 - 4 < 0 || !this.get(var1_1, var2_2 - 4, 5).equals("<!CDAT")) break;
                        var2_2 -= 5;
                        break;
                    }
                    case '>': {
                        if (var2_2 >= 0 && (var3_3 = this.get(var1_1, var2_2)) == '/') {
                            --var2_2;
                            break;
                        }
                        if (!XMLCharacter.isIDPart((char)var3_3)) break;
                        var4_5 = var2_2 - 1;
                        while (var4_5 >= 0 && XMLCharacter.isIDPart((char)(var3_3 = this.get(var1_1, var4_5)))) {
                            --var4_5;
                        }
                        if (var4_5 - 1 < 0 || var3_3 != '/' && var3_3 != '!' && var3_3 != '?' || this.get(var1_1, var4_5 - 1) != '<') break;
                        var2_2 = var4_5 - 2;
                        break;
                    }
                    default: {
                        if (!XMLCharacter.isIDPart((char)var3_3)) ** GOTO lbl53
                        while (var2_2 >= 0 && XMLCharacter.isIDPart((char)this.get(var1_1, var2_2))) {
                            --var2_2;
                        }
                        if (var2_2 >= 0 && this.get(var1_1, var2_2) == '/') {
                            --var2_2;
                        }
                        if (var2_2 < 0 || this.get(var1_1, var2_2) != '<') break;
                        --var2_2;
                        break;
lbl-1000:
                        // 1 sources

                        {
                            --var2_2;
lbl53:
                            // 2 sources

                            ** while (var2_2 >= 0 && !this.isStopChar((char)this.get((IDocument)var1_1, (int)var2_2)))
                        }
                    }
                }
            }
            return var2_2 + 1;
        }
        return var2_2;
    }

    protected boolean isStopChar(char c) {
        if (XMLCharacter.isWhitespace((char)c) || XMLCharacter.isIDPart((char)c)) {
            return true;
        }
        return this.in(c, this.fStopSet);
    }

    /*
     * Unable to fully structure code
     */
    protected int posRight(IDocument var1_1, int var2_2) {
        block22: {
            var3_3 = var1_1.getLength();
            if (var2_2 >= var3_3) break block22;
            var4_4 = this.get(var1_1, var2_2++);
            block0 : switch (var4_4) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\'': 
                case ';': 
                case '>': {
                    break;
                }
                case '<': {
                    if (var2_2 < var3_3 && (var4_4 = this.get(var1_1, var2_2)) == '!') {
                        if (++var2_2 < var3_3 && (var4_4 = this.get(var1_1, var2_2)) == '-') {
                            if (++var2_2 >= var3_3 || (var4_4 = this.get(var1_1, var2_2)) != '-') break;
                            ++var2_2;
                            break;
                        }
                        if (var2_2 >= var3_3 || this.get(var1_1, var2_2) != '[' || ++var2_2 >= var3_3 || this.get(var1_1, var2_2) != '[' || var3_3 - ++var2_2 < 6 || !this.get(var1_1, var2_2, 6).equals("CDATA[")) break;
                        var2_2 += 6;
                        break;
                    }
                    var5_5 = false;
                    if (var2_2 < var3_3) {
                        var4_4 = this.get(var1_1, var2_2);
                        if (var4_4 == '/') {
                            var5_5 = true;
                            ++var2_2;
                        } else if (var4_4 == '!' || var4_4 == '?') {
                            ++var2_2;
                        }
                    }
                    while (var2_2 < var3_3 && XMLCharacter.isIDPart((char)(var4_4 = this.get(var1_1, var2_2)))) {
                        ++var2_2;
                    }
                    if (var2_2 >= var3_3 || !var5_5 || var4_4 != '>') break;
                    ++var2_2;
                    break;
                }
                default: {
                    if (XMLCharacter.isIDPart((char)var4_4)) ** GOTO lbl40
                    if (true) ** GOTO lbl36
                    do {
                        ++var2_2;
lbl36:
                        // 2 sources

                        if (var2_2 >= var3_3) break block0;
                    } while (!this.inStart(var4_4 = this.get(var1_1, var2_2)));
                    break;
lbl-1000:
                    // 1 sources

                    {
                        ++var2_2;
lbl40:
                        // 2 sources

                        if (var2_2 >= var3_3) break block0;
                        ** while (XMLCharacter.isIDPart((char)(var4_4 = this.get((IDocument)var1_1, (int)var2_2))))
                    }
lbl42:
                    // 1 sources

                    break;
                }
                case '=': {
                    if (var2_2 >= var3_3 || (var4_4 = this.get(var1_1, var2_2)) != '\"' && var4_4 != '\'') break;
                    ++var2_2;
                    break;
                }
                case '/': {
                    while (var2_2 < var3_3 && XMLCharacter.isIDPart((char)(var4_4 = this.get(var1_1, var2_2)))) {
                        ++var2_2;
                    }
                    if (var2_2 >= var3_3 || (var4_4 = this.get(var1_1, var2_2)) != '>') break;
                    ++var2_2;
                    break;
                }
                case '\r': {
                    if (var2_2 < var3_3 && (var4_4 = this.get(var1_1, var2_2)) == '\n') {
                        ++var2_2;
                    }
                }
                case '\n': {
                    break;
                }
                case ']': {
                    if (var2_2 + 1 >= var3_3 || !this.get(var1_1, var2_2, 2).equals("]>")) break;
                    var2_2 += 2;
                    break;
                }
                case '-': {
                    if (var2_2 + 1 >= var3_3 || !this.get(var1_1, var2_2, 2).equals("->")) break;
                    var2_2 += 2;
                    break;
                }
            }
            while (var2_2 < var3_3 && ((var4_4 = this.get(var1_1, var2_2)) == ' ' || var4_4 == '\t')) {
                ++var2_2;
            }
        }
        return var2_2;
    }

    protected boolean inStart(char c) {
        if (XMLCharacter.isIDPart((char)c) || XMLCharacter.isWhitespace((char)c)) {
            return true;
        }
        return this.in(c, this.fStartSet);
    }

    protected boolean in(char c, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected char get(IDocument iDocument, int n) {
        try {
            return iDocument.get(n, 1).charAt(0);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return '\u0000';
        }
    }

    protected String get(IDocument iDocument, int n, int n2) {
        try {
            return iDocument.get(n, n2);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return "";
        }
    }

    public void addCursorListener(ICursorListener iCursorListener) {
        if (!this.fCursorListeners.contains(iCursorListener)) {
            this.fCursorListeners.add(iCursorListener);
        }
    }

    public void removeCursorListener(ICursorListener iCursorListener) {
        this.fCursorListeners.remove(iCursorListener);
    }

    private void removeEndTag() {
        block16: {
            if (this.fDanglingEndTag != null) {
                return;
            }
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer != null) {
                Point point = iSourceViewer.getSelectedRange();
                if (point.y == 0 && point.x > 0) {
                    iSourceViewer.getDocument();
                    XMLTree xMLTree = this.getXMLTree();
                    XMLNode xMLNode = xMLTree.findExactNode(point.x - 1);
                    if (xMLNode.getType() == "com.objfac.xmlemptytag") {
                        QName qName = xMLNode.getQName((QName)null);
                        QName qName2 = new QName();
                        XMLNode xMLNode2 = xMLNode.getNextSibling();
                        while (xMLNode2 != null) {
                            if (xMLNode2.getType() == "com.objfac.xmlendtag" && this.fAutoRemoveEndTag) {
                                xMLNode2.getQName(qName2);
                                if (qName.namespace.equals(qName2.namespace) && qName.localname.equals(qName2.localname)) {
                                    String string = xMLNode.getQName();
                                    XMLNode xMLNode3 = xMLNode.getParent();
                                    XMLNode xMLNode4 = xMLNode2;
                                    while (xMLNode3 != null) {
                                        if (xMLNode3.getQName().equals(string)) {
                                            XMLNode xMLNode5 = xMLNode3.getLastChild();
                                            if (xMLNode5 != xMLNode4) break;
                                            xMLNode4 = null;
                                            XMLNode xMLNode6 = xMLNode3.getNextSibling();
                                            while (xMLNode6 != null) {
                                                if (xMLNode6.getType() == "com.objfac.xmlendtag" && xMLNode6.getQName().equals(string)) {
                                                    xMLNode4 = xMLNode6;
                                                    break;
                                                }
                                                xMLNode6 = xMLNode6.getNextSibling();
                                            }
                                            if (xMLNode4 == null) break block16;
                                        }
                                        xMLNode3 = xMLNode3.getParent();
                                    }
                                    this.fDanglingParent = xMLNode;
                                    this.fDanglingEndTag = xMLNode2;
                                    Display.getCurrent().asyncExec(new Runnable(){

                                        public void run() {
                                            XMLEditor.this.doRemoveEndTag();
                                        }
                                    });
                                    break;
                                }
                            } else if (xMLNode2.getType() != "com.objfac.xmltext" || !XMLCharacter.isWhitespace((String)xMLNode2.getContents())) break;
                            xMLNode2 = xMLNode2.getNextSibling();
                        }
                    } else if (this.shouldFillEndTag(xMLNode)) {
                        this.fFillEndTag = xMLNode;
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                XMLEditor.this.doFillEndTag();
                            }
                        });
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFillEndTag() {
        if (this.fFillEndTag == null) return;
        if (!this.shouldFillEndTag(this.fFillEndTag)) {
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        String string = this.fFillEndTag.getParent().getQName();
        try {
            try {
                int n = this.fFillEndTag.getOffset() + 2;
                iDocument.replace(n, 0, String.valueOf(string) + ">");
                iSourceViewer.setSelectedRange(n + string.length() + 1, 0);
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fFillEndTag = null;
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.fFillEndTag = null;
            return;
        }
    }

    private boolean shouldRemoveEndTag() {
        return this.fAutoRemoveEndTag;
    }

    private boolean shouldFillEndTag(XMLNode xMLNode) {
        XMLNode xMLNode2;
        String string;
        if (!this.fAutoFillEndTag) {
            return false;
        }
        boolean bl = false;
        if (!(xMLNode.getType() != "com.objfac.xmlendtag" || (string = xMLNode.getContents()).length() >= 3 && XMLCharacter.isIDStart((char)string.charAt(2)) || (xMLNode2 = xMLNode.getParent()) == null)) {
            XMLNode xMLNode3 = xMLNode2.getLastChild();
            boolean bl2 = bl = xMLNode3 == xMLNode || xMLNode3.getType() != "com.objfac.xmlendtag";
            if (!bl) {
                String string2 = xMLNode3.getQName();
                bl = !string2.equals(xMLNode2.getQName());
            }
        }
        return bl;
    }

    private void doRemoveEndTag() {
        XMLNode xMLNode;
        if (this.fDanglingEndTag == null) {
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        int n = this.fDanglingEndTag.getOffset();
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode2 = xMLTree.findExactNode(n);
        if (xMLNode2 == this.fDanglingEndTag && xMLNode2.getType() == "com.objfac.xmlendtag" && (xMLNode = xMLTree.findExactNode(this.fDanglingParent.getOffset())) == this.fDanglingParent && xMLNode.getType() == "com.objfac.xmlemptytag") {
            IDocument iDocument = iSourceViewer.getDocument();
            int n2 = xMLNode.getOffset() + xMLNode.getLength();
            try {
                String string = iDocument.get(n2, xMLNode2.getOffset() - n2);
                if (string.length() == 0 || XMLCharacter.isWhitespace((String)string)) {
                    iDocument.replace(n2, xMLNode2.getOffset() + xMLNode2.getLength() - n2, "");
                }
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        this.fDanglingEndTag = null;
    }

    protected void scheduleEndTag() {
        if (this.fEndTagScheduled) {
            return;
        }
        this.fEndTagScheduled = true;
        Display.getCurrent().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    XMLEditor.this.doAddEndTag();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    XMLEditor.this.fEndTagScheduled = false;
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    XMLEditor.this.fEndTagScheduled = false;
                    return;
                }
            }
        });
    }

    protected void doAddEndTag() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getSelectedRange();
            if (point.y == 0 && point.x > 0) {
                IDocument iDocument = iSourceViewer.getDocument();
                XMLTree xMLTree = this.getXMLTree();
                XMLNode xMLNode = xMLTree.findExactNode(point.x - 1);
                String string = xMLNode.getQName();
                try {
                    if (xMLNode.getType() == "com.objfac.xmlstarttag" && xMLNode.getOffset() + xMLNode.getLength() == point.x && iDocument.get(point.x - 1, 1).equals(">") && this.noEndTag(xMLNode)) {
                        iDocument.replace(point.x, 0, "</" + string + ">");
                        iSourceViewer.setSelectedRange(point.x, 0);
                    }
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
    }

    private boolean noEndTag(XMLNode xMLNode) {
        boolean bl;
        String string = xMLNode.getQName();
        boolean bl2 = bl = xMLNode.lastChild == null || xMLNode.lastChild.getType() != "com.objfac.xmlendtag" || !xMLNode.lastChild.getQName().equals(string) || this.getFirstEndTag(xMLNode) != xMLNode.lastChild;
        if (bl) {
            return true;
        }
        XMLNode xMLNode2 = xMLNode.getParent();
        if (xMLNode2 != null && xMLNode2.getQName().equals(string)) {
            return this.noEndTag(xMLNode2);
        }
        return false;
    }

    private XMLNode getFirstEndTag(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode.firstChild;
        while (xMLNode2 != null) {
            if ("com.objfac.xmlendtag".equals(xMLNode2.getType())) {
                return xMLNode2;
            }
            xMLNode2 = xMLNode2.nextSibling;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getProperty();
        XMLPlugin.getDefault().getPreferenceStore();
        if (string.equals("com.objfac.xmleditor.insertendtag") || string.equals("com.objfac.xmleditor.removeendtag") || string.equals("com.objfac.xmleditor.fillendtag")) {
            this.updateAutoEndTag();
        }
    }

    public boolean isXml() {
        XMLTree xMLTree = this.getXMLTree();
        return xMLTree.getRoot() != null || xMLTree.getDoctype() != null;
    }

    public IOutlineTree getOutlineTree() {
        return this.getXMLTree();
    }

    protected void backgroundHandleDependencies(long l) {
    }

    public boolean noSchemaLocation() {
        XMLTree xMLTree;
        XMLNode xMLNode;
        boolean bl = false;
        if (this.getEditorKind() == 0 && (xMLNode = (xMLTree = this.getXMLTree()).getRoot()) != null) {
            bl = true;
            String string = xMLNode.getPrefix("http://www.w3.org/2001/XMLSchema-instance");
            if (string != null) {
                String string2 = string.length() > 0 ? String.valueOf(string) + ":" : "";
                String string3 = String.valueOf(string2) + "schemaLocation";
                String string4 = String.valueOf(string2) + "noNamespaceSchemaLocation";
                List list = xMLNode.getAttributeList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    String cfr_ignored_0 = (String)iterator.next();
                    if (!string5.equals(string3) && !string5.equals(string4)) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        Action action;
        Object object;
        super.editorContextMenuAboutToShow(iMenuManager);
        if (Config.pro() && this.noSchemaLocation()) {
            iMenuManager.appendToGroup("group.generate", (IAction)this.getAddSchemaLocationAction());
        }
        this.addAction(iMenuManager, "ContentAssistProposal");
        if (this.canUncomment()) {
            object = this.getUncommentAction();
            object.setText(Local.getString((String)"Uncomment"));
            iMenuManager.appendToGroup("group.edit", (IAction)object);
        }
        if (this.canComment()) {
            object = this.getCommentAction();
            object.setText(Local.getString((String)"Comment"));
            iMenuManager.appendToGroup("group.edit", (IAction)object);
        }
        if ((object = this.joinableElementName()) != null) {
            action = this.getJoinElementsAction();
            if ("<!--".equals(object) || "<![CDATA[".equals(object)) {
                action.setText(Local.format((String)"Join {0}", (Object)object));
            } else {
                action.setText(Local.format((String)"Join <{0}>", (Object)object));
            }
            iMenuManager.appendToGroup("group.edit", (IAction)action);
        }
        if ((object = this.splittableElementName()) != null) {
            action = this.getSplitElementAction();
            if ("<!--".equals(object) || "<![CDATA[".equals(object)) {
                action.setText(Local.format((String)"Split {0}", (Object)object));
            } else {
                action.setText(Local.format((String)"Split <{0}>", (Object)object));
            }
            iMenuManager.appendToGroup("group.edit", (IAction)action);
        }
        if (Config.pro() && this.getFile() != null) {
            iMenuManager.appendToGroup("group.generate", this.getTransformAction());
        }
    }

    private IAction getTransformAction() {
        if (this.fTransformAction == null) {
            this.fTransformAction = new TransformAction(this);
        }
        return this.fTransformAction;
    }

    public boolean canUncomment() {
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getTextWidget().getSelectionRange();
            XMLNode xMLNode = this.getXMLTree().findExactNode(point.x);
            return xMLNode != null && xMLNode.getType() == "com.objfac.xmlcomment" && point.x + point.y <= xMLNode.getOffset() + xMLNode.getLength();
        }
        return false;
    }

    public Action getAddSchemaLocationAction() {
        if (this.fAddSchemaLocationAction == null) {
            this.fAddSchemaLocationAction = new AddSchemaLocAction();
        }
        return this.fAddSchemaLocationAction;
    }

    protected boolean canOpenSchema() {
        if (this.getEditorKind() != 0) {
            return false;
        }
        if (this.fOldParams != null) {
            return this.fOldParams.exsd || this.fOldParams.tdtd && (this.fOldParams.pub != null || this.fOldParams.sys != null) || this.fOldParams.trnc && this.fOldParams.url != null || this.fOldParams.trng && this.fOldParams.url != null || this.fOldParams.txsd && this.fOldParams.url != null || this.fOldParams.epub != null || this.fOldParams.esys != null;
        }
        return false;
    }

    protected boolean hasDtd() {
        return this.fOldParams.beg != this.fOldParams.end || this.fOldParams.tdtd && (this.fOldParams.pub != null || this.fOldParams.sys != null) || this.fOldParams.epub != null || this.fOldParams.esys != null;
    }

    protected void openSchema() {
        String string = null;
        String string2 = null;
        if (this.fOldParams.trnc && this.fOldParams.url != null) {
            string = this.fOldParams.url;
            string2 = "com.objfac.rnceditor.RNCEditor";
        } else if (this.fOldParams.trng && this.fOldParams.url != null) {
            string = this.fOldParams.url;
            string2 = "com.objfac.xmleditor.XMLEditor.rng";
        } else if (this.fOldParams.txsd && this.fOldParams.url != null) {
            string = this.fOldParams.url;
            string2 = "com.objfac.xmleditor.XMLEditor.xsd";
        } else if (this.fOldParams.tdtd && this.fOldParams.sys != null) {
            string = this.fOldParams.sys;
            string2 = "com.objfac.xmleditor.XMLEditor.dtd";
        } else if (this.fOldParams.esys != null) {
            string = this.fOldParams.esys;
            string2 = "com.objfac.xmleditor.XMLEditor.dtd";
        } else if (this.fOldParams.exsd && this.fOldParams.url != null) {
            string2 = "com.objfac.xmleditor.XMLEditor.xsd";
            String[] stringArray = Util.xmlListToArray((String)this.fOldParams.url);
            if (stringArray.length == 1) {
                string = stringArray[0];
            } else if (stringArray.length > 1) {
                string = stringArray[1];
            }
        }
        if (string != null) {
            this.showEditor(string, string2, 0, 0);
        }
    }

    public boolean canOpenDefinition() {
        StyledText styledText;
        ISourceViewer iSourceViewer;
        if ((this.hasDtd() || this.canOpenSchema()) && (iSourceViewer = this.getViewer()) != null && (styledText = iSourceViewer.getTextWidget()) != null) {
            Point point = styledText.getSelection();
            XMLTree xMLTree = this.getXMLTree();
            XMLNode xMLNode = xMLTree.findExactNode(point.x);
            if (xMLNode != null && point.x == xMLNode.getOffset() && point.x > 0) {
                xMLNode = xMLTree.findExactNode(point.x - 1);
            }
            if (xMLNode != null && point.x >= xMLNode.getOffset() && point.x + point.y < xMLNode.getOffset() + xMLNode.getLength()) {
                switch (XMLConstants.getIntType(xMLNode.getType())) {
                    case 2: 
                    case 3: {
                        return this.inGERefOrFreeId(xMLNode, point);
                    }
                    case 4: {
                        return this.inId(xMLNode, point);
                    }
                    case 14: {
                        return this.inPERefOrElement(xMLNode, point);
                    }
                    case 12: 
                    case 13: 
                    case 15: {
                        return this.inEntityRef(xMLNode, point);
                    }
                    case 20: 
                    case 21: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean inGERefOrFreeId(XMLNode xMLNode, Point point) {
        String string = xMLNode.getContents();
        int n = point.x - xMLNode.getOffset();
        string.length();
        if (!this.inString(string, n)) {
            return false;
        }
        int[] nArray = new int[2];
        if (this.bracketId(string, n, nArray)) {
            if (this.inGERef(string, nArray, n, point)) {
                return true;
            }
            if (nArray[0] == 1) {
                return true;
            }
            if (this.inSelection(nArray, n, point) && this.isAttrNameStart(nArray[0], xMLNode)) {
                return true;
            }
        }
        return false;
    }

    private boolean isAttrNameStart(int n, XMLNode xMLNode) {
        List list = xMLNode.getAttributeOffsets();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private boolean inGERef(String string, int[] nArray, int n, Point point) {
        return nArray[0] > 0 && string.charAt(nArray[0] - 1) == '&' && nArray[1] < string.length() && string.charAt(nArray[1]) == ';' && n + point.y <= nArray[1] + 1;
    }

    private boolean inId(XMLNode xMLNode, Point point) {
        String string = xMLNode.getContents();
        int n = point.x - xMLNode.getOffset();
        string.length();
        if (!this.inString(string, n)) {
            return false;
        }
        int[] nArray = new int[2];
        return this.bracketId(string, n, nArray) && this.inSelection(nArray, n, point);
    }

    private boolean inSelection(int[] nArray, int n, Point point) {
        return n + point.y <= nArray[1] + 1;
    }

    private boolean inPERefOrElement(XMLNode xMLNode, Point point) {
        String string = xMLNode.getContents();
        int n = point.x - xMLNode.getOffset();
        int n2 = string.length();
        if (!this.inString(string, n)) {
            return false;
        }
        int[] nArray = new int[2];
        if (this.bracketId(string, n, nArray) && nArray[0] > 0) {
            char c = string.charAt(nArray[0] - 1);
            if (n + point.y <= nArray[1] + 1 && c == '%' && nArray[1] < n2 && string.charAt(nArray[1]) == ';') {
                return true;
            }
            int n3 = "<!ELEMENT ".length();
            while (n3 < n2 && XMLCharacter.isWhitespace((char)string.charAt(n3))) {
                ++n3;
            }
            while (n3 < nArray[0] && XMLCharacter.isIDPart((char)string.charAt(n3))) {
                ++n3;
            }
            while (n3 < nArray[0] && XMLCharacter.isWhitespace((char)string.charAt(n3))) {
                ++n3;
            }
            return n3 < nArray[0];
        }
        return false;
    }

    private boolean bracketId(String string, int n, int[] nArray) {
        int n2;
        int n3 = n2 = n;
        int n4 = string.length();
        while (n2 > 0 && XMLCharacter.isIDPart((char)string.charAt(n2 - 1))) {
            --n2;
        }
        while (n3 < n4 && XMLCharacter.isIDPart((char)string.charAt(n3))) {
            ++n3;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return n2 < n3;
    }

    private boolean inEntityRef(XMLNode xMLNode, Point point) {
        int n;
        String string = xMLNode.getContents();
        if (!this.inString(string, n = point.x - xMLNode.getOffset())) {
            return false;
        }
        int[] nArray = new int[2];
        if (this.bracketId(string, n, nArray)) {
            char c;
            return point.x + point.y <= nArray[1] + 1 && nArray[0] > 0 && ((c = string.charAt(nArray[0] - 1)) == '&' || c == '%') && nArray[1] < string.length() && string.charAt(nArray[1]) == ';';
        }
        return false;
    }

    private boolean inString(String string, int n) {
        return n >= 0 && n < string.length();
    }

    public char[] getContents() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            String string = iDocument.get();
            return string.toCharArray();
        }
        return new char[0];
    }

    public boolean canOpenUri() {
        String string = this.getUri();
        return string != null && string.length() > 0;
    }

    private String getUri() {
        String string = null;
        ISourceViewer iSourceViewer = this.getViewer();
        if (iSourceViewer != null) {
            Point point = iSourceViewer.getSelectedRange();
            XMLTree xMLTree = this.getXMLTree();
            XMLNode xMLNode = xMLTree.findNode(point.x);
            int n = xMLNode.getOffset();
            if (point.x > n && point.x + point.y < n + xMLNode.getLength()) {
                String string2 = xMLNode.getType();
                if (string2 == "com.objfac.xmlstarttag" || string2 == "com.objfac.xmlemptytag") {
                    point.x -= n;
                    XMLNode.AttributeData[] attributeDataArray = xMLNode.getAttributeData();
                    int n2 = 0;
                    while (n2 < attributeDataArray.length) {
                        XMLNode.AttributeData attributeData = attributeDataArray[n2];
                        if (point.x > attributeData.quoteBeg && point.x + point.y < attributeData.quoteEnd) {
                            char c;
                            int n3 = point.x - attributeData.quoteBeg - 1;
                            int n4 = n3 + point.y;
                            int n5 = attributeData.value.length();
                            while (n3 > 0 && n3 <= n5 && (c = attributeData.value.charAt(n3 - 1)) != '\'' && c != '\"' && !XMLCharacter.isWhitespace((char)c)) {
                                --n3;
                            }
                            while (n4 < n5 && (c = attributeData.value.charAt(n4)) != '\'' && c != '\"' && !XMLCharacter.isWhitespace((char)c)) {
                                ++n4;
                            }
                            string = attributeData.value.substring(n3, n4);
                            break;
                        }
                        ++n2;
                    }
                } else if (string2 == "com.objfac.xmldoctype" || string2 == "com.objfac.xmldoctypestart") {
                    String[] stringArray = new String[3];
                    Util.parseDoctype((String)xMLNode.getContents(), (String[])stringArray);
                    string = stringArray[2];
                } else if (string2 == "com.objfac.xmlpentity" || string2 == "com.objfac.xmlgentity") {
                    String string3 = xMLNode.getContents();
                    int n6 = "<!ENTITY".length();
                    int n7 = string3.length();
                    if ((n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7)) < n7) {
                        char c = string3.charAt(n6);
                        if (c == '%' && (n6 = Util.skipWhitespace((String)string3, (int)(n6 + 1), (int)n7)) < n7) {
                            c = string3.charAt(n6);
                        }
                        if (XMLCharacter.isIDStart((char)c)) {
                            n6 = Util.skipId((String)string3, (int)n6, (int)n7);
                            if ((n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7)) < n7 && ((c = string3.charAt(n6)) == 'S' || c == 'P')) {
                                int n8 = n6;
                                n6 = Util.skipId((String)string3, (int)n6, (int)n7);
                                String string4 = string3.substring(n8, n6);
                                String[] stringArray = new String[2];
                                n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7);
                                if ("PUBLIC".equals(string4)) {
                                    n6 = Util.parseLiteral((String)string3, (int)n6, (int)n7, (String[])stringArray, (int)0);
                                    n6 = Util.skipWhitespace((String)string3, (int)n6, (int)n7);
                                    string4 = "SYSTEM";
                                }
                                if ("SYSTEM".equals(string4)) {
                                    n6 = Util.parseLiteral((String)string3, (int)n6, (int)n7, (String[])stringArray, (int)1);
                                    string = stringArray[1];
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public void openUri() {
        String string = this.getUri();
        if (string != null && string.length() > 0) {
            this.openUri(string);
        }
    }

    public String getTransformUri() {
        XMLTree xMLTree = this.getXMLTree();
        XMLNode xMLNode = xMLTree.getHead();
        String string = null;
        while (xMLNode != null) {
            String string2;
            String string3 = xMLNode.getType();
            if (string3 == "com.objfac.xmlstarttag" || string3 == "com.objfac.xmlemptytag") break;
            if (string3 == "com.objfac.xmlpi" && "xml-stylesheet".equals(string2 = xMLNode.getQName())) {
                String string4 = xMLNode.getAttributeValue("href");
                String string5 = xMLNode.getAttributeValue("type");
                if (string5 != null && string4 != null && ("text/xsl".equals(string5) || "text/xslt".equals(string5)) && string4.length() > 0) {
                    string = string4;
                    break;
                }
            }
            xMLNode = xMLNode.getNextSibling();
        }
        return string;
    }

    protected XMLNode findNode(int n) {
        XMLNode xMLNode = this.getXMLTree().findExactNode(n);
        return xMLNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkPartitioner(IDocument iDocument) {
        IDocumentPartitioner iDocumentPartitioner = PartitionUtils.getPartitioner(iDocument, "com.objfac.xmlpartitioner");
        if (iDocumentPartitioner instanceof XMLPartitioner) return;
        this.fInitializing = true;
        try {
            XMLDocumentSetupParticipant.setupPartitioner(iDocument);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fInitializing = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fInitializing = false;
            return;
        }
    }

    protected boolean isMyProvider(IDocumentProvider iDocumentProvider) {
        return iDocumentProvider instanceof XMLDocumentProvider;
    }

    private class SplitElementAction
    extends Action {
        SplitElementAction() {
        }

        public void run() {
            XMLEditor.this.splitElement();
        }
    }

    private class JoinElementsAction
    extends Action {
        JoinElementsAction() {
        }

        public void run() {
            XMLEditor.this.joinElements();
        }
    }

    private class UncommentAction
    extends Action {
        UncommentAction() {
        }

        public void run() {
            XMLEditor.this.uncomment();
        }
    }

    private class CommentAction
    extends Action {
        CommentAction() {
        }

        public void run() {
            XMLEditor.this.comment();
        }
    }

    protected class CursorListener
    extends KeyAdapter
    implements MouseListener {
        protected CursorListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.notifyCursorListeners();
        }

        protected void notifyCursorListeners() {
            Iterator iterator = XMLEditor.this.fCursorListeners.iterator();
            while (iterator.hasNext()) {
                ((ICursorListener)iterator.next()).mouseUp();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.character == '>' && keyEvent.stateMask == 131072 && XMLEditor.this.fAutoInsertEndTag) {
                XMLEditor.this.scheduleEndTag();
            }
            if (keyEvent.character == '/') {
                XMLEditor.this.removeEndTag();
            }
        }
    }

    private class AddSchemaLocAction
    extends Action {
        public AddSchemaLocAction() {
            this.setText(Local.getString((String)"Add schema location"));
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 678->682)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

