/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.xml.schema.impl.SchemaError;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.MigrationUtils;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.ErrorTuple;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class ActionUtils {
    public static final int ALL_STATUS_MASK = 7;
    public static final int NOT_OK_STATUS_MASK = 7;
    private static final Exception NO_EXCEPTION = null;

    public static IStatus errorsToStatus(int n, String string, ErrorCollector errorCollector) {
        return ActionUtils.errorsToStatus(n, string, errorCollector.getErrors().iterator());
    }

    public static IStatus errorsToStatus(int n, String string, List list) {
        return ActionUtils.errorsToStatus(n, string, list.iterator());
    }

    public static IStatus errorsToStatus(int n, String string, Iterator iterator) {
        Object object;
        LinkedList<Status> linkedList = new LinkedList<Status>();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3;
            ErrorTuple errorTuple;
            Object e = iterator.next();
            if (e instanceof ErrorTuple) {
                errorTuple = (ErrorTuple)e;
                n3 = ActionUtils.callbackSeverityToStatusSeverity(errorTuple.level);
                object = errorTuple.message;
            } else {
                errorTuple = (SchemaError)iterator.next();
                n3 = ActionUtils.schemaSeverityToStatusSeverity(errorTuple.getSeverity());
                object = errorTuple.getMessage();
            }
            if (n2 < n3) {
                n2 = n3;
            }
            linkedList.add(new Status(n3, "com.objfac.xmleditor", n, (String)object, (Throwable)NO_EXCEPTION));
        }
        IStatus[] iStatusArray = linkedList.toArray(new IStatus[linkedList.size()]);
        object = new DoWeNeedThis("com.objfac.xmleditor", 1, iStatusArray, string, NO_EXCEPTION);
        object.fixSeverity(n2);
        return object;
    }

    public static int schemaSeverityToStatusSeverity(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 4;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public static int callbackSeverityToStatusSeverity(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public static IStatus makeErrorStatus(int n, String string, Exception exception) {
        return new Status(4, "com.objfac.xmleditor", n, string, (Throwable)exception);
    }

    public static IStatus makeErrorStatus(int n, String string) {
        return new Status(4, "com.objfac.xmleditor", n, string, (Throwable)NO_EXCEPTION);
    }

    public static IEditorPart openFile(String string, String string2) throws CoreException {
        IEditorPart iEditorPart = null;
        if (new File(string).isDirectory()) {
            return null;
        }
        Path path = new Path(string);
        IFile iFile = XMLPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile == null || !iFile.exists()) {
            iFile = ActionUtils.makeLink((IPath)path);
        }
        if (iFile != null) {
            IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            iEditorPart = string2 == null ? MigrationUtils.openEditor(iWorkbenchPage, iFile) : MigrationUtils.openEditor(iWorkbenchPage, iFile, string2);
        }
        return iEditorPart;
    }

    public static IFile makeLink(IPath iPath) throws CoreException {
        Object object;
        IFile[] iFileArray = XMLPlugin.getWorkspace().getRoot().findFilesForLocation(iPath);
        int n = 0;
        while (n < iFileArray.length) {
            object = iFileArray[n];
            if (object != null && object.exists()) {
                return object;
            }
            ++n;
        }
        IFile iFile = null;
        object = iPath.lastSegment();
        iFile = ActionUtils.getExternalProject().getFile((String)object);
        if (iFile.exists()) {
            String string = iPath.removeFileExtension().lastSegment();
            String string2 = iPath.getFileExtension();
            int n2 = 0;
            IResource[] iResourceArray = ActionUtils.getExternalProject().members();
            int n3 = 0;
            while (n3 < iResourceArray.length) {
                IResource iResource = iResourceArray[n3];
                if (iResource.isLinked() && iResource.getRawLocation().equals((Object)iPath)) {
                    return (IFile)iResource;
                }
                String string3 = iResource.getFullPath().removeFileExtension().lastSegment();
                String string4 = iResource.getFullPath().getFileExtension();
                if (string3.startsWith(string) && string4 != null && string2 != null && string4.equals(string2)) {
                    String string5;
                    int n4;
                    int n5 = string3.lastIndexOf(40);
                    int n6 = string3.lastIndexOf(41);
                    if (n5 != -1 && n6 != -1 && n6 > n5 + 1 && (n4 = Integer.parseInt(string5 = string3.substring(n5 + 1, n6))) > n2) {
                        n2 = n4;
                    }
                }
                ++n3;
            }
            String string6 = String.valueOf(string) + "(" + ++n2 + ")";
            if (string2 != null) {
                string6 = String.valueOf(string6) + "." + string2;
            }
            iFile = ActionUtils.getExternalProject().getFile(string6);
            iFile.createLink(iPath, 0, null);
        } else {
            iFile.createLink(iPath, 0, null);
        }
        return iFile;
    }

    public static IProject getExternalProject() throws CoreException {
        String string = XMLPlugin.getDefault().getPreferenceStore().getString("com.objfac.desktopproject");
        IProject iProject = XMLPlugin.getWorkspace().getRoot().getProject(string);
        if (!iProject.exists()) {
            iProject.create(null);
        }
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        return iProject;
    }

    public static String getNonNullProperty(IFile iFile, QualifiedName qualifiedName) {
        String string = ActionUtils.getProperty(iFile, qualifiedName);
        return string == null ? "" : string;
    }

    public static String getProperty(IFile iFile, QualifiedName qualifiedName) {
        try {
            return iFile.getPersistentProperty(qualifiedName);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
            return null;
        }
    }

    public static void setProperty(IFile iFile, QualifiedName qualifiedName, String string) {
        try {
            iFile.setPersistentProperty(qualifiedName, string);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }

    public static void setProperty(IFile iFile, QualifiedName qualifiedName, Collection collection) {
        ActionUtils.setProperty(iFile, qualifiedName, ActionUtils.packCollection(collection));
    }

    public static void getProperty(IFile iFile, QualifiedName qualifiedName, List list) {
        String string = ActionUtils.getProperty(iFile, qualifiedName);
        ActionUtils.unpackString(string, list);
    }

    public static String packCollection(Collection collection) {
        boolean[] cfr_ignored_0 = new boolean[127];
        Iterator iterator = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('/');
            }
            String string = iterator.next().toString();
            int n = string.indexOf(47);
            int n2 = 0;
            while ((n = string.indexOf(47)) >= 0) {
                stringBuffer.append(string.substring(n2, n)).append("//");
                n2 = n + 1;
            }
            if (n2 >= string.length()) continue;
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static void unpackString(String string, List list) {
        list.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '/') {
                if (n + 1 < n2 && string.charAt(n + 1) == '/') {
                    stringBuffer.append('/');
                    ++n;
                } else {
                    list.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (n + 1 == n2) {
                        list.add("");
                    }
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            list.add(stringBuffer.toString());
        }
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String replaceExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        string = n < 0 ? String.valueOf(string) + '.' + string2 : String.valueOf(string.substring(0, n)) + '.' + string2;
        return string;
    }

    public static boolean isActionable() {
        boolean bl = Config.pro();
        return bl;
    }

    private static class DoWeNeedThis
    extends MultiStatus {
        public DoWeNeedThis(String string, int n, IStatus[] iStatusArray, String string2, Throwable throwable) {
            super(string, n, iStatusArray, string2, throwable);
        }

        public void fixSeverity(int n) {
            this.setSeverity(n);
        }
    }
}

