/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Misc;
import com.objfac.xml.io.DefaultDocumentReaderFactory;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.actions.DefinitionLocation;
import com.objfac.xmleditor.actions.DefinitionTarget;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.awt.Toolkit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;

public abstract class DefinitionFinder {
    protected BaseEditor editor;

    protected abstract DefinitionTarget getDefinitionTarget(Point var1, XMLNode var2);

    protected abstract DefinitionLocation findDefinition(DefinitionTarget var1, XMLNode var2, String var3);

    protected abstract XMLNode getHead(String var1);

    public void openDefinition() {
        DefinitionTarget definitionTarget = this.getDefinitionTarget();
        if (definitionTarget != null) {
            XMLNode xMLNode = this.editor.getOutlineTree().getHead();
            DefinitionLocation definitionLocation = this.findDefinitionInTree(xMLNode, definitionTarget, null);
            if (definitionLocation != null) {
                this.editor.selectAndReveal(definitionLocation.getOffset(), definitionLocation.getLength());
                return;
            }
            String string = this.editor.getUrl();
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            this.findHeads(string, this.editor.getEditorKind(), Misc.getExtension((String)string), hashSet, hashSet2);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (this.findDefinition(string2, definitionTarget, null)) {
                    return;
                }
                HashSet hashSet3 = new HashSet();
                if (!this.tryChildren(string2, definitionTarget, hashSet3, null)) continue;
                return;
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private void findHeads(String string, int n, String string2, Set set, Set set2) {
        if (set2.contains(string)) {
            return;
        }
        set2.add(string);
        DependencyManager dependencyManager = DependencyManager.getSingletonManager();
        String[] stringArray = dependencyManager.getIncludingParents(string);
        if (stringArray.length == 0) {
            set.add(string);
        } else {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                String string4 = Misc.getExtension((String)string3);
                int n3 = XMLConstants.extensionToKind(string4);
                if (n == 1 && n3 == 0) {
                    set.add(string3);
                } else if (n3 == n || string4.equals(string2)) {
                    this.findHeads(string3, n, string2, set, set2);
                }
                ++n2;
            }
        }
    }

    public DefinitionTarget getDefinitionTarget() {
        ISourceViewer iSourceViewer = this.editor.getViewer();
        Point point = iSourceViewer.getSelectedRange();
        IOutlineTree iOutlineTree = this.editor.getOutlineTree();
        XMLNode xMLNode = iOutlineTree.findNode(point.x);
        if (point.x >= xMLNode.getOffset() && point.x + point.y <= xMLNode.getOffset() + xMLNode.getLength()) {
            return this.getDefinitionTarget(point, xMLNode);
        }
        return null;
    }

    protected DefinitionLocation findDefinitionInTree(XMLNode xMLNode, DefinitionTarget definitionTarget, String string) {
        DefinitionLocation definitionLocation = null;
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            XMLNode xMLNode3;
            definitionLocation = this.findDefinition(definitionTarget, xMLNode2, null);
            if (definitionLocation != null || (xMLNode3 = xMLNode2.getFirstChild()) != null && (definitionLocation = this.findDefinitionInTree(xMLNode3, definitionTarget, null)) != null) break;
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return definitionLocation;
    }

    protected IExternalEntity getEntity() {
        return new ExternalEntity(null, null, this.editor.getUrl(), (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
    }

    protected boolean findDefinition(String string, DefinitionTarget definitionTarget, String string2) {
        String string3;
        DefinitionLocation definitionLocation;
        XMLNode xMLNode = this.getHead(string);
        return xMLNode != null && (definitionLocation = this.findDefinitionInTree(xMLNode, definitionTarget, string2)) != null && this.editor.showEditor(string, string3 = this.editor.getEditorId(), definitionLocation.getOffset(), definitionLocation.getLength()) != null;
    }

    public DefinitionFinder(BaseEditor baseEditor) {
        this.editor = baseEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tryChildren(String string, DefinitionTarget definitionTarget, Set set, String string2) {
        if (set.contains(string)) {
            return false;
        }
        DependencyManager dependencyManager = DependencyManager.getSingletonManager();
        String[] stringArray = dependencyManager.getIncludedChildren(string);
        int n = 0;
        while (n < stringArray.length) {
            if (!set.contains(stringArray[n])) {
                Object var8_8;
                block9: {
                    if (string2 == null && dependencyManager.isXsdInclude(string, stringArray[n])) {
                        string2 = dependencyManager.getTargetNamespace(string);
                    }
                    if (this.findDefinition(stringArray[n], definitionTarget, string2)) {
                        return true;
                    }
                    set.add(string);
                    try {
                        if (!this.tryChildren(stringArray[n], definitionTarget, set, string2)) break block9;
                        var8_8 = null;
                        set.remove(string);
                        return true;
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        set.remove(string);
                        throw throwable;
                    }
                }
                var8_8 = null;
                set.remove(string);
            }
            ++n;
        }
        return false;
    }
}

