/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.walker.IWalker;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.contentassist.ContentAssistUtil;
import com.objfac.xmleditor.notes.Name;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.io.CharArrayWriter;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DumpWalkerContextAction
extends Action {
    private XMLEditor fEditor;
    private static final int ELEMENT_NAMES = 0;
    private static final int ATTRIBUTE_NAMES = 1;
    private static final int ATTRIBUTE_VALUES = 2;
    private static final int ELEMENT_VALUES = 3;
    private static final String[] ELEMENTNAMES = new String[]{"Element names"};
    private static final String[] ELEMENTVALUS = new String[]{"Element values"};
    private static final String[] ATTRIBUNAMES = new String[]{"Attribute names"};
    private static final String[] ATTRIBUVALUS = new String[]{"Attribute values"};
    private static final String[] TOPLEVELNAME = new String[]{"Top-level element names"};

    public DumpWalkerContextAction(XMLEditor xMLEditor, String string) {
        this.fEditor = xMLEditor;
        this.setText(string);
    }

    public void run() {
        String string;
        IEditorInput iEditorInput = this.fEditor.getEditorInput();
        String string2 = string = iEditorInput.getName();
        int n = string.lastIndexOf(46);
        string = n > 0 ? String.valueOf(string.substring(0, n)) + "_walker_context." + "xml" : String.valueOf(string) + "_walker_context.xml";
        String[][] stringArray = new String[2][];
        IWalker iWalker = this.getWalkerInContext(stringArray);
        XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
        CharArrayWriter charArrayWriter = xMLSchemaReaderShell.literalDumpWalker(iWalker);
        String string3 = System.getProperty("line.separator");
        try {
            charArrayWriter.write("<!--");
            charArrayWriter.write(string3);
            charArrayWriter.write(stringArray[0][0]);
            charArrayWriter.write(string3);
            int n2 = 0;
            while (n2 < stringArray[1].length) {
                charArrayWriter.write(stringArray[1][n2]);
                charArrayWriter.write(string3);
                ++n2;
            }
            charArrayWriter.write("-->");
            charArrayWriter.write(string3);
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
        }
        char[] cArray = charArrayWriter.toCharArray();
        Storage storage = new Storage(cArray, string, string2, "UTF-8");
        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            try {
                iWorkbenchPage.openEditor((IEditorInput)storage, "com.objfac.xmleditor.XMLEditor");
            }
            catch (PartInitException partInitException) {
                XMLPlugin.log(partInitException);
            }
        }
    }

    private IWalker getWalkerInContext(String[][] stringArray) {
        XMLTree xMLTree = this.fEditor.getXMLTree();
        XMLNode xMLNode = xMLTree.getRoot();
        Point point = this.fEditor.getViewer().getTextWidget().getSelectionRange();
        IWalker iWalker = null;
        if (xMLNode == null || point.x < xMLNode.getOffset()) {
            iWalker = this.fEditor.getWalker();
            iWalker.setRootContext();
            stringArray[0] = TOPLEVELNAME;
            stringArray[1] = iWalker.getElements();
        } else {
            Context context = this.getWalkerContext(xMLTree, point);
            if (context.type == 0 || context.type == 3) {
                iWalker = ContentAssistUtil.findNode(this.fEditor, xMLNode, context.node);
                if (iWalker != null) {
                    if (context.type == 0) {
                        stringArray[0] = ELEMENTNAMES;
                        stringArray[1] = iWalker.getElements();
                    } else {
                        stringArray[0] = ELEMENTVALUS;
                        stringArray[1] = iWalker.getTextValues();
                    }
                }
            } else if ((context.type == 1 || context.type == 2) && (iWalker = ContentAssistUtil.findElement(this.fEditor, xMLNode, context.node)) != null) {
                if (context.type == 1) {
                    this.acceptAttributesTo(null, context.node, iWalker);
                    stringArray[0] = ATTRIBUNAMES;
                    stringArray[1] = iWalker.getAttributes();
                } else {
                    Name name = this.getAttrName(context.attrName, context.node);
                    this.acceptAttributesTo(name, context.node, iWalker);
                    stringArray[0] = ATTRIBUVALUS;
                    stringArray[1] = iWalker.getAttributeValues(name.namespace, name.localname, name.qname);
                }
            }
        }
        if (iWalker == null) {
            iWalker = this.fEditor.getWalker();
            iWalker.setRootContext();
            stringArray[0] = TOPLEVELNAME;
            stringArray[1] = iWalker.getElements();
        }
        return iWalker;
    }

    private Name getAttrName(String string, XMLNode xMLNode) {
        String string2;
        String string3 = string2 = string;
        String string4 = "";
        int n = string2.indexOf(58);
        if (n >= 0) {
            String string5 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            string4 = xMLNode.getNamespace(string5);
        }
        return new Name(string4, string2, string3);
    }

    private void acceptAttributesTo(Name name, XMLNode xMLNode, IWalker iWalker) {
        XMLNode.AttributeData[] attributeDataArray = xMLNode.getAttributeData();
        int n = 0;
        while (n < attributeDataArray.length) {
            Name name2 = this.getAttrName(attributeDataArray[n].name, xMLNode);
            if (name2.equals(name)) break;
            iWalker.acceptAttributeSkipValue(name2.namespace, name2.localname, name2.qname);
            ++n;
        }
    }

    private Context getWalkerContext(XMLTree xMLTree, Point point) {
        Context context = new Context();
        context.node = xMLTree.findExactNode(point.x);
        context.offsetInNode = point.x - context.node.getOffset();
        String string = context.node.getType();
        if (string == "com.objfac.xmlstarttag" || string == "com.objfac.xmlemptytag") {
            String string2 = context.node.getContents();
            int n = 1;
            int n2 = string2.length();
            while (n < n2 && XMLCharacter.isIDPart((char)string2.charAt(n))) {
                ++n;
            }
            if (context.offsetInNode < n) {
                context.type = 0;
            } else {
                XMLNode.AttributeData[] attributeDataArray = context.node.getAttributeData();
                int n3 = 0;
                while (n3 < attributeDataArray.length) {
                    if (context.offsetInNode < attributeDataArray[n3].nameEnd) {
                        context.type = 1;
                        break;
                    }
                    if (context.offsetInNode < attributeDataArray[n3].quoteEnd) {
                        context.type = 2;
                        context.attrName = attributeDataArray[n3].name;
                        break;
                    }
                    ++n3;
                }
                if (n3 == attributeDataArray.length) {
                    context.type = 1;
                }
            }
        } else if (string == "com.objfac.xmlendtag") {
            XMLNode xMLNode;
            XMLNode xMLNode2 = context.node.getParent();
            context.type = xMLNode2 == null ? 0 : (xMLNode2 != null && xMLNode2.getOffset() + xMLNode2.getLength() == context.node.getOffset() ? 3 : ((xMLNode = xMLTree.findExactNode(point.x - 1)).getType() == "com.objfac.xmltext" && xMLNode2.getOffset() + xMLNode2.getLength() == xMLNode.getOffset() ? 3 : 0));
        } else if (string == "com.objfac.xmltext") {
            XMLNode xMLNode = context.node.getParent();
            if (xMLNode == null) {
                context.type = 0;
            } else if (xMLNode != null && xMLNode.getOffset() + xMLNode.getLength() == context.node.getOffset()) {
                XMLNode xMLNode3 = xMLNode.getLastChild();
                context.type = xMLNode.getOffset() + xMLNode.getLength() == context.node.getOffset() && (xMLNode3 == context.node || xMLNode3.getType() == "com.objfac.xmlendtag" && context.node.getOffset() + context.node.getLength() == xMLNode3.getOffset()) ? 3 : 0;
            }
        } else {
            context.type = 0;
        }
        return context;
    }

    private static class Context {
        public String attrName;
        public XMLNode node;
        public int offsetInNode;
        public int type;

        Context() {
        }
    }
}

