/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.walker.gen.GenerateXMLResult;
import com.objfac.xmleditor.actions.AbstractDialog;
import com.objfac.xmleditor.wizards.WizardUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenerateXMLDialog
extends AbstractDialog {
    private boolean fDoRepeat;
    private Button fRandomSeed;
    private Button fRandomize;
    private Text fPrefix;
    private Label fPrefixLabel;
    private boolean fHasNs;
    private GenerateXMLResult fResult = new GenerateXMLResult();
    private String fDefaultName;
    private Text fRepeatCount;
    private Label fRepeatLabel;
    private Button fRepeatableElem;
    private Button fOptionalElem;
    private Button fOptionalAttr;
    private String[] fRootNames;
    private List fRootList;
    private boolean fIsDTD;
    private ButtonListener fButtonListener = new ButtonListener();

    public GenerateXMLDialog(Shell shell, String string, RGB rGB, boolean bl, boolean bl2, String[] stringArray, String string2) {
        super(shell, string, rGB);
        this.fIsDTD = bl;
        this.fHasNs = bl2;
        this.fRootNames = stringArray;
        this.fDefaultName = string2;
    }

    protected void createDialogBody(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        composite2.setLayoutData((Object)gridData);
        Object object = new GridLayout(2, false);
        composite2.setLayout((Layout)object);
        gridData = new Label(composite2, 0);
        gridData.setText(Local.getString((String)"Root element names:"));
        object = new GridData();
        object.horizontalSpan = 2;
        gridData.setLayoutData(object);
        this.fRootList = new List(composite2, 2564);
        object = new GridData(768);
        object.horizontalSpan = 2;
        object.heightHint = 64;
        this.fRootList.setLayoutData(object);
        this.fRootList.setItems(this.fRootNames);
        if (this.fDefaultName != null) {
            int n = 0;
            while (n < this.fRootNames.length) {
                if (this.fDefaultName.equals(this.fRootNames[n])) {
                    this.fRootList.setSelection(n);
                    break;
                }
                ++n;
            }
        }
        this.fRootList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GenerateXMLDialog.this.listSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                GenerateXMLDialog.this.listDoubleClick();
            }
        });
        this.fPrefixLabel = new Label(composite2, 0);
        this.fPrefixLabel.setText(Local.getString((String)"Default prefix:"));
        object = new GridData();
        this.fPrefixLabel.setLayoutData(object);
        this.fPrefix = new Text(composite2, 2052);
        object = WizardUtils.getDialogSetting("com.objfac.genxml.prefix");
        this.fPrefix.setText(object == null ? "" : object);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 50;
        this.fPrefix.setLayoutData((Object)gridData2);
        this.fPrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GenerateXMLDialog.this.validate();
            }
        });
        this.fOptionalAttr = new Button(composite2, 32);
        this.fOptionalAttr.setText(Local.getString((String)"Generate optional attributes"));
        boolean bl = WizardUtils.getBooleanDialogSetting("com.objfac.genxml.optatt");
        this.fOptionalAttr.setSelection(bl);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        this.fOptionalAttr.setLayoutData((Object)gridData3);
        this.fOptionalAttr.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fOptionalElem = new Button(composite2, 32);
        this.fOptionalElem.setText(Local.getString((String)"Generate optional elements"));
        boolean bl2 = WizardUtils.getBooleanDialogSetting("com.objfac.genxml.optelm");
        this.fOptionalElem.setSelection(bl2);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        this.fOptionalElem.setLayoutData((Object)gridData4);
        this.fOptionalElem.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fRepeatableElem = new Button(composite2, 32);
        this.fRepeatableElem.setText(Local.getString((String)"Generate optional repeatable elements"));
        int n = WizardUtils.getIntDialogSetting("com.objfac.genxml.repeat");
        boolean bl3 = WizardUtils.getBooleanDialogSetting("com.objfac.genxml.dorept");
        this.fRepeatableElem.setSelection(bl3);
        GridData gridData5 = new GridData(768);
        gridData5.horizontalSpan = 2;
        this.fRepeatableElem.setLayoutData((Object)gridData5);
        this.fRepeatableElem.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fRepeatLabel = new Label(composite2, 0);
        this.fRepeatLabel.setText(Local.getString((String)"How many:"));
        gridData5 = new GridData();
        gridData5.horizontalIndent = 18;
        this.fRepeatLabel.setLayoutData((Object)gridData5);
        this.fRepeatCount = new Text(composite2, 2052);
        this.fRepeatCount.setText(n <= 0 ? "1" : "" + n);
        gridData5 = new GridData();
        this.fRepeatCount.setLayoutData((Object)gridData5);
        this.fRepeatCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GenerateXMLDialog.this.validate();
            }
        });
        this.fRandomize = new Button(composite2, 32);
        this.fRandomize.setText(Local.getString((String)"Randomize choices"));
        boolean bl4 = WizardUtils.getBooleanDialogSetting("com.objfac.genxml.random");
        this.fRandomize.setSelection(bl4);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalSpan = 2;
        this.fRandomize.setLayoutData((Object)gridData6);
        this.fRandomize.addSelectionListener((SelectionListener)this.fButtonListener);
        this.fRandomSeed = new Button(composite2, 32);
        this.fRandomSeed.setText(Local.getString((String)"Different sequence each time"));
        boolean bl5 = WizardUtils.getBooleanDialogSetting("com.objfac.genxml.randsd");
        this.fRandomSeed.setSelection(bl5);
        GridData gridData7 = new GridData(768);
        gridData7.horizontalSpan = 2;
        gridData7.horizontalIndent = 18;
        this.fRandomSeed.setLayoutData((Object)gridData7);
        this.fRandomSeed.addSelectionListener((SelectionListener)this.fButtonListener);
    }

    protected void listDoubleClick() {
        this.listSelection();
        if (this.noErrors()) {
            this.okPressed();
        }
    }

    protected void okPressed() {
        WizardUtils.putDialogSetting("com.objfac.genxml.prefix", this.fResult.prefix);
        WizardUtils.putDialogSetting("com.objfac.genxml.optatt", this.fResult.optionalAttributes);
        WizardUtils.putDialogSetting("com.objfac.genxml.optelm", this.fResult.optionalElements);
        WizardUtils.putDialogSetting("com.objfac.genxml.random", this.fResult.randomizeChoices);
        WizardUtils.putDialogSetting("com.objfac.genxml.randsd", this.fResult.randomSeed);
        WizardUtils.putDialogSetting("com.objfac.genxml.repeat", this.fResult.repeatCount);
        WizardUtils.putDialogSetting("com.objfac.genxml.dorept", this.fDoRepeat);
        super.okPressed();
    }

    protected void listSelection() {
        this.validate();
    }

    protected void doValidate() {
        int n;
        int n2 = this.fRootList.getSelectionIndex();
        if (n2 >= 0) {
            this.fResult.rootName = this.fRootList.getItem(n2);
        }
        this.fResult.optionalAttributes = this.fOptionalAttr.getSelection();
        this.fResult.optionalElements = this.fOptionalElem.getSelection();
        this.fResult.randomizeChoices = this.fRandomize.getSelection();
        this.fResult.randomSeed = this.fResult.randomizeChoices ? this.fRandomSeed.getSelection() : false;
        this.fDoRepeat = this.fRepeatableElem.getSelection();
        this.fRandomSeed.setEnabled(this.fResult.randomizeChoices);
        this.fPrefixLabel.setEnabled(this.fHasNs);
        this.fPrefix.setEnabled(this.fHasNs);
        if (this.fHasNs) {
            this.fResult.prefix = this.fPrefix.getText();
        }
        this.fRepeatLabel.setEnabled(this.fDoRepeat);
        this.fRepeatCount.setEnabled(this.fDoRepeat);
        if (this.fDoRepeat) {
            String string = this.fRepeatCount.getText();
            if (string.length() == 0) {
                this.setMessages(null, "Please specify number of elements to generate");
            } else {
                try {
                    int n3 = Integer.parseInt(string);
                    if (n3 < 0) {
                        this.setMessages("Count must be a positive number", null);
                    } else if (n3 == 0) {
                        this.setMessages("Count must be greater than zero", null);
                    } else {
                        this.fResult.repeatCount = n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setMessages("Count must be a number", null);
                }
            }
        }
        if (this.noErrors() && (n = this.fRootList.getSelectionIndex()) < 0) {
            this.setMessages(null, Local.getString((String)"Select a root element name from the list"));
        }
    }

    public GenerateXMLResult show() {
        int n = this.open();
        if (n == 0) {
            return this.fResult;
        }
        return null;
    }

    protected void doInit() {
    }

    private class ButtonListener
    extends SelectionAdapter {
        ButtonListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            GenerateXMLDialog.this.validate();
        }
    }
}

