/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.rnceditor.RNCEditor;
import com.objfac.rnceditor.RNCTree;
import com.objfac.rnceditor.partition.RNCParser;
import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.DefaultDocumentReaderFactory;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.UnknownPublicIdentifierException;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.actions.DependencyManager;
import com.objfac.xmleditor.actions.EditorActionDelegate;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class RNCGotoDefinitionAction
extends EditorActionDelegate {
    private RNCEditor editor;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof RNCEditor) {
            this.editor = (RNCEditor)iEditorPart;
        }
    }

    public void run(IAction iAction) {
        if (this.editor != null) {
            this.editor.openDefinition();
        }
    }

    private boolean tryChildren(String string, String string2, List list) {
        if (list.contains(string)) {
            return false;
        }
        list.add(string);
        DependencyManager dependencyManager = DependencyManager.getSingletonManager();
        String[] stringArray = dependencyManager.getIncludedChildren(string);
        int n = 0;
        while (n < stringArray.length) {
            if (!list.contains(stringArray[n]) && this.findDefinition(stringArray[n], string2)) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            if (this.tryChildren(stringArray[n], string2, list)) {
                return true;
            }
            ++n;
        }
        String[] stringArray2 = dependencyManager.getIncludingParents(string);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (this.tryChildren(stringArray2[n2], string2, list)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean findDefinition(String string, String string2) {
        ExternalEntity externalEntity = new ExternalEntity(null, null, string, (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
        try {
            String string3;
            XMLNode xMLNode;
            char[] cArray = externalEntity.getContents();
            RNCParser rNCParser = new RNCParser();
            RNCTree rNCTree = rNCParser.parse(cArray);
            XMLNode xMLNode2 = rNCTree.getHead();
            if (xMLNode2 != null && (xMLNode = this.findDefinition(string2, xMLNode2)) != null && this.showEditor(string, string3 = this.editor.getEditorId(), cArray, xMLNode.getOffset(), string2.length())) {
                return true;
            }
        }
        catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {
        }
        catch (IOException iOException) {
            XMLPlugin.log(iOException);
        }
        return false;
    }

    private boolean showEditor(String string, String string2, char[] cArray, int n, int n2) {
        IEditorPart iEditorPart = null;
        IFile iFile = this.uriToIFile(string);
        iEditorPart = iFile != null ? this.openEditor(iFile, string2) : (!string.startsWith("file:") ? this.getStorageEditor(string, string2, cArray) : this.getNonWorkspaceEditor(string, string2));
        if (iEditorPart != null && iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return true;
        }
        return false;
    }

    private IEditorPart getNonWorkspaceEditor(String string, String string2) {
        IEditorPart iEditorPart = null;
        String string3 = Misc.fileUrlToPath((String)string);
        try {
            iEditorPart = ActionUtils.openFile(string3, string2);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
        return iEditorPart;
    }

    private IEditorPart getStorageEditor(String string, String string2, char[] cArray) {
        IEditorPart iEditorPart = null;
        String string3 = Misc.getName((String)string);
        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorInput iEditorInput;
            IEditorPart iEditorPart2;
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            if (string3.equals(iEditorReference.getName()) && (iEditorPart2 = iEditorReference.getEditor(true)) != null && (iEditorInput = iEditorPart2.getEditorInput()) instanceof Storage && string.equals(((Storage)iEditorInput).getOldName())) {
                iEditorPart = iEditorPart2;
                iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                break;
            }
            ++n;
        }
        if (iEditorPart == null) {
            Storage storage = new Storage(cArray, string3, string, "UTF-8");
            try {
                iEditorPart = iWorkbenchPage.openEditor((IEditorInput)storage, string2);
            }
            catch (PartInitException partInitException) {
                XMLPlugin.log(partInitException);
            }
        }
        return iEditorPart;
    }

    private IEditorPart openEditor(IFile iFile, String string) {
        IEditorPart iEditorPart = null;
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
            if (iEditorPart != null) {
                iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            } else {
                try {
                    iEditorPart = iWorkbenchPage.openEditor((IEditorInput)fileEditorInput, string);
                }
                catch (PartInitException partInitException) {
                    XMLPlugin.log(partInitException);
                }
            }
        }
        return iEditorPart;
    }

    private IFile uriToIFile(String string) {
        IFile iFile = null;
        if (string.startsWith("file:")) {
            IWorkspace iWorkspace = XMLPlugin.getWorkspace();
            IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
            String string2 = Misc.fileUrlToPath((String)string);
            Path path = new Path(string2);
            iFile = iWorkspaceRoot.getFileForLocation((IPath)path);
        }
        return iFile;
    }

    private XMLNode findDefinition(String string, XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            XMLNode xMLNode3;
            Object object;
            String string2 = xMLNode2.getType();
            if (string2 == "com.objfac.rncdefine" && ((String)(object = xMLNode2.getContents())).startsWith(string) && ((String)object).length() > string.length() && !XMLCharacter.isIDPart((char)((String)object).charAt(string.length()))) {
                return xMLNode2;
            }
            object = xMLNode2.getFirstChild();
            if (object != null && (xMLNode3 = this.findDefinition(string, (XMLNode)object)) != null) {
                return xMLNode3;
            }
            xMLNode2 = xMLNode2.getNextSibling();
        }
        return null;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl = false;
        if (this.editor != null && iSelection instanceof ITextSelection) {
            String string;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            RNCTree rNCTree = this.editor.getRNCTree();
            XMLNode xMLNode = rNCTree.findNode(iTextSelection.getOffset());
            if (xMLNode != null && (string = xMLNode.getType()) == "com.objfac.rncref") {
                bl = true;
            }
        }
        this.setEnabled(iAction, bl);
    }
}

