/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.xml.XMLCharacter;

public class TextualFormatter {

    public static class Scanner {
        public static final int EOS = -1;
        private static final char EOC = '\uffff';
        int pos;
        private int beg;
        private int end;
        String s;
        int lastNodeType;
        int lastNodePos;
        private boolean inDocType;
        private boolean treatEntitiesAsText;

        public Scanner(String string, int n, int n2, boolean bl, boolean bl2) {
            this.s = string;
            this.pos = this.beg = n;
            this.end = n2;
            this.treatEntitiesAsText = bl2;
        }

        public int nextNode() {
            int n = -1;
            if (this.pos == this.end) {
                return n;
            }
            this.lastNodePos = this.pos;
            char c = this.next();
            if (c == '<') {
                c = this.next();
                if (c == '!') {
                    if (this.peek("--")) {
                        this.skip("--");
                        this.scanPast("-->");
                        n = 0;
                    } else if (this.peek("[CDATA[")) {
                        this.skip("[CDATA[");
                        this.scanPast("]]>");
                        n = 5;
                    } else if (this.peek("DOCTYPE")) {
                        this.skip("DOCTYPE");
                        n = this.scanDoctypeStart();
                    } else if (XMLCharacter.isIDStart((char)c)) {
                        this.back();
                        if (this.peek("ELEMENT")) {
                            this.skip("ELEMENT");
                            this.scanElementStart();
                            n = 14;
                        } else if (this.peek("ATTRIBUTE")) {
                            this.skip("ATTRIBUTE");
                            this.scanElementStart();
                            n = 15;
                        } else if (this.peek("ENTITY")) {
                            this.skip("ENTITY");
                            n = this.skipNext('%') ? 13 : 12;
                            this.scanElementStart();
                        } else if (this.peek("ELEMENT")) {
                            this.skip("ELEMENT");
                            this.scanElementStart();
                            n = 14;
                        }
                    } else {
                        this.back();
                        n = 1;
                    }
                } else if (XMLCharacter.isIDStart((char)c)) {
                    n = this.scanElementStart();
                } else if (c == '?') {
                    if (this.peekIgnoreCase("xml")) {
                        this.skip("xml");
                        n = 6;
                    } else {
                        n = 8;
                    }
                    this.scanPast("?>");
                } else if (c == '/') {
                    this.scanElementStart();
                    n = 4;
                } else {
                    this.back();
                    n = 1;
                }
            } else if (c == '&' && !this.treatEntitiesAsText) {
                this.scanEntityReference();
            }
            return n;
        }

        public void unscan() {
            this.pos = this.lastNodePos;
            if (this.lastNodeType == 17) {
                this.inDocType = false;
            }
        }

        private char next() {
            if (this.pos == this.end) {
                return '\uffff';
            }
            return this.s.charAt(this.pos++);
        }

        private void back() {
            if (this.pos > this.beg) {
                --this.pos;
            }
        }

        private boolean skipNext(char c) {
            int n = this.pos;
            while (n < this.end) {
                char c2 = this.s.charAt(n);
                if (c2 == c) {
                    ++this.pos;
                    return true;
                }
                if (!XMLCharacter.isWhitespace((char)c2)) break;
                ++this.pos;
            }
            return false;
        }

        private char peek() {
            if (this.pos + 1 >= this.end) {
                return '\uffff';
            }
            return this.s.charAt(this.pos + 1);
        }

        private boolean peek(String string) {
            int n = 0;
            int n2 = string.length();
            int n3 = this.pos;
            while (n3 < this.end && n < n2) {
                if (this.s.charAt(n3) != string.charAt(n)) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return n == n2;
        }

        private boolean peekIgnoreCase(String string) {
            int n = 0;
            int n2 = string.length();
            int n3 = this.pos;
            while (n3 < this.end && n < n2) {
                char c = this.s.charAt(n3);
                char c2 = string.charAt(n);
                if (Character.toLowerCase(c) != Character.toLowerCase(c2) || Character.toUpperCase(c) != Character.toUpperCase(c2)) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return n == n2;
        }

        private void skip(String string) {
            this.pos = Math.min(this.end, this.pos + string.length());
        }

        private void scanPast(String string) {
            this.scanTo(string);
            this.skip(string);
        }

        private void scanTo(String string) {
            char c = string.charAt(0);
            int n = string.length();
            int n2 = this.pos;
            while (n2 < this.end) {
                if (this.s.charAt(n2) == c) {
                    int n3 = n2 + n;
                    int n4 = n2 + 1;
                    int n5 = 0;
                    while (n4 < this.end && n4 < n3) {
                        if (this.s.charAt(n4) != string.charAt(n5)) break;
                        ++n4;
                        ++n5;
                    }
                    if (n4 == n3) break;
                }
                ++n2;
            }
        }

        private int scanDoctypeStart() {
            int n = -1;
            while (this.pos < this.end) {
                char c = this.next();
                if (c == '\'' || c == '\"') {
                    this.scanValue(c, true);
                } else {
                    if (c == '>' || c == '<') {
                        n = 7;
                        if (c != '>') break;
                        ++this.pos;
                        break;
                    }
                    if (c == '[') {
                        n = 17;
                        ++this.pos;
                        break;
                    }
                }
                ++this.pos;
            }
            return n;
        }

        private void scanValue(char c, boolean bl) {
            while (this.pos < this.end) {
                char c2 = this.next();
                if (c2 == '<') {
                    --this.pos;
                    break;
                }
                if (c2 == c) {
                    if (bl) break;
                    --this.pos;
                    break;
                }
                ++this.pos;
            }
        }

        private int scanElementStart() {
            int n = -1;
            boolean bl = false;
            while (this.pos < this.end) {
                char c = this.next();
                if (c == '\'' || c == '\"') {
                    this.scanValue(c, true);
                } else {
                    if (c == '>' || c == '<') {
                        n = bl ? 3 : 2;
                        if (c != '>') break;
                        ++this.pos;
                        break;
                    }
                    if (c == '/') {
                        bl = true;
                    } else if (!XMLCharacter.isWhitespace((char)c)) {
                        bl = false;
                    }
                }
                ++this.pos;
            }
            return n;
        }

        private void scanEntityReference() {
            while (this.pos < this.end) {
                char c = this.s.charAt(this.pos);
                if (c == ';') break;
                if (!XMLCharacter.isIDPart((char)c)) {
                    --this.pos;
                    break;
                }
                ++this.pos;
            }
        }
    }
}

