/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.validate.TransformArguments;
import com.objfac.xmleditor.wizards.WizardUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TransformDialog
extends TitleAreaDialog {
    private String fTransformUri;
    private boolean fIsXsl;
    private ArrayList fParamList = new ArrayList();
    private Button fClearButton;
    private ArrayList fParamProperty;
    private String fParamValu;
    private String fParamName;
    private int fTableRows;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fNewButton;
    private Table fTable;
    private String fResultOutput;
    private String fResultInput;
    private IPath fContainer;
    private Button fOutputBrowse;
    private Label fOutputLabel;
    private Text fOutput;
    private Button fToTmp;
    private Button fTmpOut;
    private IFile fSheet;
    private Text fInput;

    public TransformDialog(boolean bl, Shell shell, IFile iFile, String string) {
        super(shell);
        this.fIsXsl = bl;
        this.fSheet = iFile;
        this.fTransformUri = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Local.getString((String)"Transform"));
    }

    public TransformArguments show() {
        int n = this.open();
        if (n == 0) {
            TransformArguments transformArguments = new TransformArguments();
            transformArguments.inputUri = this.fResultInput;
            transformArguments.outputFile = this.fResultOutput;
            this.collectParameters(transformArguments);
            ActionUtils.setProperty(this.fSheet, XMLConstants.XSL_IN, this.fResultInput);
            ActionUtils.setProperty(this.fSheet, XMLConstants.XSL_TMP, this.fResultOutput == null ? "true" : "false");
            ActionUtils.setProperty(this.fSheet, XMLConstants.XSL_OUT, this.fResultOutput == null ? "" : this.fResultOutput);
            ActionUtils.setProperty(this.fSheet, XMLConstants.XSL_PARAMS, this.fParamList);
            return transformArguments;
        }
        return null;
    }

    private void collectParameters(TransformArguments transformArguments) {
        int n = 0;
        int n2 = this.fParamList.size();
        while (n < n2) {
            String string = (String)this.fParamList.get(n);
            String string2 = (String)this.fParamList.get(n + 1);
            transformArguments.addParameter(string, string2);
            n += 2;
        }
    }

    private void collectParameters() {
        this.fParamList.clear();
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            String string = tableItem.getText(0);
            String string2 = tableItem.getText(1);
            this.fParamList.add(string);
            this.fParamList.add(string2);
            ++n;
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        composite3.setLayoutData((Object)gridData);
        Object object = new GridLayout(3, false);
        composite3.setLayout((Layout)object);
        gridData = new Label(composite3, 0);
        gridData.setText(Local.getString((String)(this.fIsXsl ? "Input file:" : "XSL file:")));
        object = new GridData();
        gridData.setLayoutData(object);
        this.fInput = new Text(composite3, 2052);
        object = ActionUtils.getNonNullProperty(this.fSheet, XMLConstants.XSL_IN);
        if (this.fTransformUri != null) {
            object = this.fTransformUri;
        }
        this.fInput.setText((String)object);
        this.fInput.setSelection(0, ((String)object).length());
        GridData gridData2 = new GridData(768);
        this.fInput.setLayoutData((Object)gridData2);
        this.fInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TransformDialog.this.inputChanged();
            }
        });
        this.fContainer = this.fSheet.getFullPath().removeLastSegments(1);
        gridData2 = new Button(composite3, 8);
        gridData2.setText(Local.getString((String)"Browse"));
        GridData gridData3 = new GridData();
        gridData2.setLayoutData((Object)gridData3);
        gridData2.addSelectionListener((SelectionListener)new WizardUtils.BrowseButtonListener(this.fInput, this.getShell(), this.fContainer, true, false));
        boolean bl = "false".equals(ActionUtils.getNonNullProperty(this.fSheet, XMLConstants.XSL_TMP));
        this.fToTmp = new Button(composite3, 32);
        this.fToTmp.setText(Local.getString((String)"Output to memory"));
        this.fToTmp.setSelection(!bl);
        Object object2 = new GridData();
        ((GridData)object2).horizontalSpan = 3;
        this.fToTmp.setLayoutData(object2);
        this.fToTmp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.fToTmp.setSelection(true);
            }
        });
        this.fOutputLabel = new Label(composite3, 0);
        this.fOutputLabel.setText(Local.getString((String)"Output file:"));
        object2 = new GridData();
        ((GridData)object2).horizontalIndent = 18;
        this.fOutputLabel.setLayoutData(object2);
        this.fOutput = new Text(composite3, 2052);
        object2 = ActionUtils.getNonNullProperty(this.fSheet, XMLConstants.XSL_OUT);
        this.fOutput.setText((String)object2);
        this.fOutput.setSelection(0, ((String)object2).length());
        GridData gridData4 = new GridData(768);
        this.fOutput.setLayoutData((Object)gridData4);
        this.fOutput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                TransformDialog.this.outputChanged();
            }
        });
        this.fOutputBrowse = new Button(composite3, 8);
        this.fOutputBrowse.setText(Local.getString((String)"Browse"));
        gridData4 = new GridData();
        this.fOutputBrowse.setLayoutData((Object)gridData4);
        this.fOutputBrowse.addSelectionListener((SelectionListener)new WizardUtils.BrowseButtonListener(this.fOutput, this.getShell(), this.fContainer, true, false));
        gridData4 = new Label(composite3, 0);
        gridData4.setText(Local.getString((String)"Parameters:"));
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 3;
        gridData4.setLayoutData((Object)gridData5);
        gridData5 = new Composite(composite3, 16384);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalSpan = 3;
        gridData5.setLayoutData((Object)gridData6);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridData5.setLayout((Layout)gridLayout);
        this.fTable = new Table((Composite)gridData5, 84740);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gridData6 = new GridData(768);
        gridData6.verticalAlignment = 1;
        gridData6.heightHint = 100;
        this.fTable.setLayoutData((Object)gridData6);
        gridLayout = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(2, 100);
        gridLayout.addColumnData((ColumnLayoutData)columnWeightData);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(2, 100);
        gridLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        this.fTable.setLayout((Layout)gridLayout);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText(Local.getString((String)"Name"));
        TableColumn tableColumn2 = new TableColumn(this.fTable, 0);
        tableColumn2.setText(Local.getString((String)"Value"));
        ArrayList arrayList = new ArrayList();
        ActionUtils.getProperty(this.fSheet, XMLConstants.XSL_PARAMS, arrayList);
        this.fillTable(arrayList);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.rowSelected();
            }
        });
        gridData6 = new Composite((Composite)gridData5, 16384);
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.verticalAlignment = 1;
        gridLayout.horizontalIndent = 10;
        gridData6.setLayoutData((Object)gridLayout);
        columnWeightData = new RowLayout(512);
        columnWeightData.marginTop = 0;
        columnWeightData.marginBottom = 6;
        columnWeightData.pack = false;
        gridData6.setLayout((Layout)columnWeightData);
        this.fNewButton = new Button((Composite)gridData6, 0x1000000);
        this.fNewButton.setText(Local.getString((String)"New..."));
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.doNew();
            }
        });
        this.fEditButton = new Button((Composite)gridData6, 0x1000000);
        this.fEditButton.setText(Local.getString((String)"Edit..."));
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.doEdit();
            }
        });
        this.fRemoveButton = new Button((Composite)gridData6, 0x1000000);
        this.fRemoveButton.setText(Local.getString((String)"Remove"));
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.doRemove();
            }
        });
        this.fClearButton = new Button((Composite)gridData6, 0x1000000);
        this.fClearButton.setText(Local.getString((String)"Clear"));
        this.fClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformDialog.this.doClear();
            }
        });
        return composite2;
    }

    protected void doNew() {
        ParamDialog paramDialog = new ParamDialog(this.getShell(), "", "");
        if (paramDialog.open() == 0) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            tableItem.setText(0, this.fParamName);
            tableItem.setText(1, this.fParamValu);
            this.collectParameters();
        }
    }

    protected void doEdit() {
        TableItem[] tableItemArray = this.fTable.getSelection();
        if (tableItemArray.length > 0) {
            TableItem tableItem = tableItemArray[0];
            ParamDialog paramDialog = new ParamDialog(this.getShell(), tableItem.getText(0), tableItem.getText(1));
            if (paramDialog.open() == 0) {
                tableItem.setText(0, this.fParamName);
                tableItem.setText(1, this.fParamValu);
            }
            this.collectParameters();
        }
    }

    protected void doRemove() {
        TableItem[] tableItemArray = this.fTable.getSelection();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].dispose();
            ++n;
        }
        this.collectParameters();
    }

    protected void doClear() {
        this.fTable.removeAll();
        this.collectParameters();
    }

    private void fillTable(ArrayList arrayList) {
        this.fParamList.clear();
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            String string = (String)arrayList.get(n);
            String string2 = (String)arrayList.get(n + 1);
            tableItem.setText(0, string);
            tableItem.setText(1, string2);
            this.fParamList.add(string);
            this.fParamList.add(string2);
            n += 2;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setTitleAreaColor(new RGB(255, 255, 255));
        if (this.fIsXsl) {
            this.setTitle(Local.getString((String)"Specify input file, output destination and optional parameters"));
        } else {
            this.setTitle(Local.getString((String)"Specify stylesheet file, output destination and optional parameters"));
        }
        this.validate();
        if (this.fInput.getText().length() == 0) {
            this.setError(null);
            this.setMessage(Local.getString((String)"Specify input file"));
            this.getButton(0).setEnabled(false);
        }
        return control;
    }

    private void rowSelected() {
        this.fEditButton.setEnabled(true);
        this.fRemoveButton.setEnabled(true);
    }

    private void validate() {
        boolean bl = !this.fToTmp.getSelection();
        this.fOutputLabel.setEnabled(bl);
        this.fOutput.setEnabled(bl);
        this.fOutputBrowse.setEnabled(bl);
        String string = this.fInput.getText();
        String string2 = this.fOutput.getText();
        this.setError(null);
        if (!this.existingFile(string)) {
            if (this.fIsXsl) {
                this.setError(Local.getString((String)"Input file does not exist"));
            } else {
                this.setError(Local.getString((String)"Stylesheet file does not exist"));
            }
        } else if (bl) {
            if (this.fOutput.getText().length() == 0) {
                this.setError(Local.getString((String)"Output file must be specified"));
            } else if (!this.possibleFile(string2)) {
                this.setError(Local.getString((String)"Output file not in a project"));
            }
        }
        this.fResultInput = string;
        this.fResultOutput = bl ? string2 : null;
    }

    private boolean existingFile(String string) {
        String string2 = WizardUtils.ipathToFolderPath(this.fContainer);
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        String string3 = Misc.absPathToUrl((String)string2);
        String string4 = Misc.getAbsUrl((String)string3, (String)string);
        string4 = Misc.escapeUri((String)string4);
        try {
            URI uRI = new URI(string4);
            File file = new File(uRI);
            return !file.isDirectory() && file.exists();
        }
        catch (URISyntaxException uRISyntaxException) {
            XMLPlugin.log(uRISyntaxException);
            return false;
        }
    }

    private boolean possibleFile(String string) {
        if (this.existingFile(string)) {
            return true;
        }
        return true;
    }

    private boolean validateFile(Text text) {
        return false;
    }

    protected void outputChanged() {
        this.validate();
    }

    protected void inputChanged() {
        this.validate();
    }

    protected void setError(String string) {
        if (string == null) {
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        } else {
            this.setErrorMessage(string);
            this.getButton(0).setEnabled(false);
        }
    }

    public static void insertSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        label.setText(" ");
        label.setVisible(false);
    }

    private class ParamDialog
    extends Dialog {
        private Text fNameText;
        private Text fValuText;
        private String fMsg = "";
        private Label fMsgLabel;

        public ParamDialog(Shell shell, String string, String string2) {
            super(shell);
            TransformDialog.this.fParamName = string;
            TransformDialog.this.fParamValu = string2;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            String string = TransformDialog.this.fParamName.length() == 0 ? Local.getString((String)"New Parameter") : Local.getString((String)"Edit Parameter");
            composite.getShell().setText(string);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            this.fMsgLabel = new Label(composite3, 16384);
            GridData gridData = new GridData(769);
            gridData.horizontalSpan = 2;
            gridData.widthHint = 300;
            this.fMsgLabel.setLayoutData((Object)gridData);
            gridData = new Label(composite3, 16384);
            gridData.setText(Local.getString((String)"Name:"));
            this.fNameText = new Text(composite3, 18436);
            this.fNameText.setText(TransformDialog.this.fParamName);
            GridData gridData2 = new GridData(769);
            gridData2.widthHint = 100;
            this.fNameText.setLayoutData((Object)gridData2);
            gridData2 = new Label(composite3, 16384);
            gridData2.setText(Local.getString((String)"Value:"));
            this.fValuText = new Text(composite3, 18436);
            this.fValuText.setText(TransformDialog.this.fParamValu);
            Object object = new GridData(769);
            object.widthHint = 200;
            this.fValuText.setLayoutData(object);
            object = new LocalModifyListener();
            this.fNameText.addModifyListener((ModifyListener)object);
            this.fValuText.addModifyListener((ModifyListener)object);
            return composite2;
        }

        protected Control createContents(Composite composite) {
            Control control = super.createContents(composite);
            this.validate();
            return control;
        }

        private void validate() {
            String string = this.fMsg;
            this.fMsg = "";
            TransformDialog.this.fParamName = this.fNameText.getText();
            TransformDialog.this.fParamValu = this.fValuText.getText();
            if (this.isEmpty(TransformDialog.this.fParamName)) {
                this.fMsg = Local.getString((String)"Parameter name must be specified");
            }
            Button button = this.getButton(0);
            button.setEnabled(this.fMsg.length() == 0);
            if (!string.equals(this.fMsg)) {
                this.fMsgLabel.setText(this.fMsg);
            }
        }

        private boolean isEmpty(String string) {
            int n = string.length();
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c > ' ') {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private class LocalModifyListener
        implements ModifyListener {
            LocalModifyListener() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                ParamDialog.this.validate();
            }
        }
    }
}

