/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.memio.MemFiles;
import com.objfac.util.Local;
import com.objfac.walker.IWalker;
import com.objfac.xml.io.DefaultDocumentReaderFactory;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.ActionUtils;
import com.objfac.xmleditor.actions.IReaderStorage;
import com.objfac.xmleditor.actions.Storage;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.SchemaTranslatorShell;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class XMLConvertToAction
implements IEditorActionDelegate {
    private int fromBits;
    private int toKind;
    BaseEditor editor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected XMLConvertToAction(int n) {
        int n2 = 31;
        this.fromBits = n2 & ~XMLConstants.kindToBit(n);
        this.toKind = n;
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.objfac.xmleditor.BaseEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.editor = (BaseEditor)iEditorPart.getAdapter((Class)clazz);
        } else {
            this.editor = null;
        }
        iAction.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return Config.pro() && this.editor != null && (this.fromBits & XMLConstants.kindToBit(this.editor.getEditorKind())) != 0;
    }

    private CharArrayWriter convertFromXsd() {
        XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
        IWalker iWalker = xMLSchemaReaderShell.getWalkerForXsd(this.editor.getUrl(), this.editor.getResourceWatcherCallback());
        List list = iWalker.getErrors();
        if (list != null && list.size() > 0) {
            this.showErrorDialog(ActionUtils.errorsToStatus(1, Local.getString((String)"Translation from XML Schema to internal format failed"), list));
            return null;
        }
        return xMLSchemaReaderShell.dumpWalker(iWalker, null, true, 10);
    }

    public void run(IAction iAction) {
        if (Config.pro() && this.isEnabled()) {
            this.convert();
        }
    }

    private void convert() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n = this.editor.getEditorKind();
        MemFiles.AuxFile[] auxFileArray = null;
        String string = null;
        if (n == 4) {
            object6 = this.convertFromXsd();
            if (object6 == null) {
                return;
            }
            object5 = new MemFiles();
            string = XMLConvertToAction.deriveUri(this.editor.getUrl(), "rng");
            object4 = XMLConvertToAction.getName(string);
            object5.addFile((String)object4, (CharArrayWriter)object6, "UTF-8");
            auxFileArray = object5.getFiles();
        }
        if (auxFileArray == null || this.toKind != 2) {
            if (auxFileArray != null) {
                object3 = auxFileArray[0];
                object2 = object3.getWriter().toCharArray();
                object5 = new CharArrayReader((char[])object2);
                object6 = object3.getEncoding();
                object4 = string;
                n = 2;
            } else {
                IEditorInput iEditorInput = this.editor.getEditorInput();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.core.resources.IStorage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((object = (IStorage)iEditorInput.getAdapter((Class)clazz)) != null) {
                    object4 = "memory:" + this.editor.getEditorInput().getName();
                    try {
                        if (object instanceof IReaderStorage) {
                            object3 = (IReaderStorage)object;
                            object5 = object3.getCharContents();
                        }
                        object3 = object.getContents();
                        object6 = this.editor.getEncoding();
                        try {
                            object5 = new InputStreamReader((InputStream)object3, (String)object6);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            object5 = new InputStreamReader((InputStream)object3);
                        }
                    }
                    catch (CoreException coreException) {
                        this.showErrorDialog(ActionUtils.makeErrorStatus(1, Local.format((String)"Can''t make a reader for {0}", (Object)object4), (Exception)((Object)coreException)));
                        return;
                    }
                } else {
                    object4 = this.editor.getUrl();
                    object3 = new ExternalEntity(null, null, (String)object4, (IDocumentReaderFactory)DefaultDocumentReaderFactory.getFactory());
                    try {
                        object2 = object3.getContents();
                    }
                    catch (IOException iOException) {
                        this.showErrorDialog(ActionUtils.makeErrorStatus(1, Local.format((String)"Can''t read {0}", (Object)object4), iOException));
                        return;
                    }
                    object5 = new CharArrayReader((char[])object2);
                    object6 = this.editor.getEncoding();
                }
            }
            object3 = new SchemaTranslatorShell();
            object2 = XMLConvertToAction.deriveUri((String)object4, XMLConstants.kindToExtension(this.toKind));
            ErrorCollector errorCollector = new ErrorCollector();
            MemFiles memFiles = new MemFiles();
            ((SchemaTranslatorShell)object3).translate((Reader)object5, (String)object4, n, (String)object2, this.toKind, errorCollector, memFiles);
            int n2 = errorCollector.getMaxSeverity();
            if (errorCollector.getErrors().size() > 0) {
                this.showErrorDialog(ActionUtils.errorsToStatus(1, n2 <= 1 ? Local.getString((String)"Translation warning") : Local.getString((String)"Translation failed"), errorCollector));
            }
            auxFileArray = memFiles.getFiles();
        }
        int n3 = auxFileArray.length - 1;
        while (n3 >= 0) {
            object5 = auxFileArray[n3];
            object4 = object5.getWriter();
            object = XMLConvertToAction.getName(object5.getUri());
            object3 = new Storage(((CharArrayWriter)object4).toCharArray(), (String)object, (String)object, object5.getEncoding());
            object2 = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (object2 != null) {
                try {
                    object2.openEditor((IEditorInput)object3, XMLConstants.kindToId(this.toKind));
                }
                catch (PartInitException partInitException) {
                    XMLPlugin.log(partInitException);
                }
            }
            --n3;
        }
    }

    private void showErrorDialog(IStatus iStatus) {
        ErrorDialog errorDialog = new ErrorDialog(this.editor.getSite().getShell(), Local.getString((String)"Convert Failed"), null, iStatus, 7);
        errorDialog.setBlockOnOpen(true);
        errorDialog.open();
    }

    private String getOutputName() {
        return XMLConvertToAction.getName(this.getOutputUri());
    }

    private String getOutputUri() {
        return XMLConvertToAction.deriveUri(this.editor.getUrl(), XMLConstants.kindToExtension(this.toKind));
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String deriveUri(String string, String string2) {
        if (string.startsWith("memory:")) {
            string = string.substring("memory:".length());
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && n2 > n) {
            return String.valueOf(string.substring(0, n2 + 1)) + string2;
        }
        return String.valueOf(string) + '.' + string2;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        iAction.setEnabled(this.isEnabled());
    }
}

