/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.util.Local;
import com.objfac.xml.parsers.IErrorHandler;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.actions.XMLGenerateDTDAction;
import com.objfac.xmleditor.generators.XMLDTDGenerator;
import com.objfac.xmleditor.xmltree.XMLNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class XMLGenerateXsdAction
implements IEditorActionDelegate,
IErrorHandler {
    private XMLEditor fEditor;
    private ISelection fSelection;
    private String fError;
    private static final String XSD_EXTENSION = ".xsd";
    private static XMLGenerateDTDAction fDelegate;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.fEditor = iEditorPart instanceof XMLEditor ? (XMLEditor)iEditorPart : null;
    }

    public void run(IAction iAction) {
        if (this.fSelection instanceof ITextSelection && this.fEditor != null) {
            IDocument iDocument;
            String string;
            IEditorInput iEditorInput = this.fEditor.getEditorInput();
            String string2 = string = iEditorInput.getName();
            int n = string.lastIndexOf(46);
            string = n > 0 ? String.valueOf(string.substring(0, n)) + XSD_EXTENSION : String.valueOf(string) + XSD_EXTENSION;
            XMLDTDGenerator xMLDTDGenerator = new XMLDTDGenerator(this);
            this.fError = null;
            XMLNode xMLNode = this.fEditor.getXMLTree().getRoot();
            String string3 = xMLDTDGenerator.parseRoot(xMLNode);
            if (this.fError != null) {
                ErrorDialog.openError((Shell)this.fEditor.getViewer().getTextWidget().getShell(), (String)Local.getString((String)"Generate XML Schema"), (String)Local.getString((String)"Error detected in XML document"), (IStatus)new Status(4, "com.objfac.xmleditor", 2, this.fError, null));
            }
            if ((iDocument = this.fEditor.getDocument()) != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                    outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    String[] stringArray = iDocument.getLegalLineDelimiters();
                    String string4 = stringArray[stringArray.length - 1];
                    outputStreamWriter.write(string4);
                    outputStreamWriter.write("<!-- Generated from " + string2 + " by XMLBuddy -->" + string4);
                    if (xMLDTDGenerator.printSchema(outputStreamWriter, string4, string3)) {
                        ((Writer)outputStreamWriter).close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        Storage storage = new Storage(byArray, string, string2);
                        IWorkbenchPage iWorkbenchPage = XMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (iWorkbenchPage != null) {
                            try {
                                iWorkbenchPage.openEditor((IEditorInput)storage, "com.objfac.xmleditor.XMLEditor.xsd");
                            }
                            catch (PartInitException partInitException) {
                                XMLPlugin.log(partInitException);
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    XMLPlugin.log(unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    XMLPlugin.log(iOException);
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fSelection = iSelection;
        boolean bl = false;
        if (iSelection instanceof ITextSelection && this.fEditor != null) {
            bl = this.fEditor.getEditorKind() == 0 && this.fEditor.isXml();
        }
        iAction.setEnabled(Config.pro() && bl);
    }

    public boolean error(String string) {
        this.fError = string;
        return false;
    }

    public static XMLGenerateDTDAction getDelegate() {
        if (fDelegate == null) {
            fDelegate = new XMLGenerateDTDAction();
        }
        return fDelegate;
    }

    private static class Storage
    implements IStorage,
    IStorageEditorInput {
        private byte[] fBytes;
        private String fName;
        private String fOldName;

        public Storage(byte[] byArray, String string, String string2) {
            this.fBytes = byArray;
            this.fName = string;
            this.fOldName = string2;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.fBytes);
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return Local.format((String)"Generated from {0}", (Object)this.fOldName);
        }

        public IStorage getStorage() throws CoreException {
            return this;
        }
    }
}

