/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.actions;

import com.objfac.xml.Util;
import com.objfac.xmleditor.XSDEditor;
import com.objfac.xmleditor.actions.DefinitionLocation;
import com.objfac.xmleditor.actions.DefinitionTarget;
import com.objfac.xmleditor.actions.DefinitionTargetNamespace;
import com.objfac.xmleditor.actions.XMLDefinitionFinder;
import com.objfac.xmleditor.xmltree.XMLNode;
import org.eclipse.swt.graphics.Point;

public class XSDDefinitionFinder
extends XMLDefinitionFinder {
    private String targetNamespace;
    private static final String[] qname = new String[2];

    public XSDDefinitionFinder(XSDEditor xSDEditor) {
        super(xSDEditor);
    }

    protected DefinitionTarget getDefinitionTarget(Point point, XMLNode xMLNode) {
        String string;
        DefinitionTargetNamespace definitionTargetNamespace = null;
        String string2 = xMLNode.getType();
        int n = xMLNode.getOffset();
        int n2 = point.x - n;
        if ((string2 == "com.objfac.xmlstarttag" || string2 == "com.objfac.xmlemptytag") && (string = xMLNode.getNamespace()) != null && string.equals("http://www.w3.org/2001/XMLSchema")) {
            XMLNode.AttributeData attributeData;
            String string3 = xMLNode.getLocalname();
            if ("element".equals(string3)) {
                XMLNode.AttributeData attributeData2 = xMLNode.findAttributeValue(n2);
                if (attributeData2 != null) {
                    if ("ref".equals(attributeData2.name) || "substitutionGroup".equals(attributeData2.name)) {
                        this.resolve(xMLNode, attributeData2.value.trim(), qname);
                        definitionTargetNamespace = new DefinitionTargetNamespace("xsd.element", qname[0], qname[1]);
                    } else if ("type".equals(attributeData2.name)) {
                        this.resolve(xMLNode, attributeData2.value.trim(), qname);
                        definitionTargetNamespace = new DefinitionTargetNamespace("xsd.type", qname[0], qname[1]);
                    }
                }
            } else if ("attribute".equals(string3)) {
                XMLNode.AttributeData attributeData3 = xMLNode.findAttributeValue(n2);
                if (attributeData3 != null) {
                    if ("ref".equals(attributeData3.name)) {
                        this.resolve(xMLNode, attributeData3.value.trim(), qname);
                        definitionTargetNamespace = new DefinitionTargetNamespace("xsd.attribute", qname[0], qname[1]);
                    } else if ("type".equals(attributeData3.name)) {
                        this.resolve(xMLNode, attributeData3.value.trim(), qname);
                        definitionTargetNamespace = new DefinitionTargetNamespace("xsd.simple", qname[0], qname[1]);
                    }
                }
            } else if ("restriction".equals(string3)) {
                XMLNode.AttributeData attributeData4 = xMLNode.findAttributeValue(n2);
                if (attributeData4 != null && "base".equals(attributeData4.name)) {
                    String string4;
                    boolean bl = true;
                    boolean bl2 = true;
                    XMLNode xMLNode2 = xMLNode.getParent();
                    if (xMLNode2 != null && xMLNode2.getType() == "com.objfac.xmlstarttag" && (string4 = xMLNode2.getNamespace()) != null && string4.equals("http://www.w3.org/2001/XMLSchema")) {
                        String string5 = xMLNode2.getLocalname();
                        if ("simpleContent".equals(string5) || "simpleType".equals(string5)) {
                            bl = true;
                            bl2 = false;
                        } else if ("complexContent".equals(string5) || "complexType".equals(string5)) {
                            bl = false;
                            bl2 = false;
                        }
                    }
                    this.resolve(xMLNode, attributeData4.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace(bl2 ? "xsd.type" : (bl ? "xsd.simple" : "xsd.complex"), qname[0], qname[1]);
                }
            } else if ("extension".equals(string3)) {
                XMLNode.AttributeData attributeData5 = xMLNode.findAttributeValue(n2);
                if (attributeData5 != null && "base".equals(attributeData5.name)) {
                    this.resolve(xMLNode, attributeData5.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace("xsd.complex", qname[0], qname[1]);
                }
            } else if ("list".equals(string3)) {
                XMLNode.AttributeData attributeData6 = xMLNode.findAttributeValue(n2);
                if (attributeData6 != null && "itemType".equals(attributeData6.name)) {
                    this.resolve(xMLNode, attributeData6.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace("xsd.simple", qname[0], qname[1]);
                }
            } else if ("union".equals(string3)) {
                XMLNode.AttributeData attributeData7 = xMLNode.findAttributeValue(n2);
                if (attributeData7 != null && "memberTypes".equals(attributeData7.name) && this.narrow(xMLNode, attributeData7, point)) {
                    this.resolve(xMLNode, attributeData7.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace("xsd.simple", qname[0], qname[1]);
                }
            } else if ("attributeGroup".equals(string3)) {
                XMLNode.AttributeData attributeData8 = xMLNode.findAttributeValue(n2);
                if (attributeData8 != null && "ref".equals(attributeData8.name)) {
                    this.resolve(xMLNode, attributeData8.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace("xsd.attrgroup", qname[0], qname[1]);
                }
            } else if ("group".equals(string3)) {
                XMLNode.AttributeData attributeData9 = xMLNode.findAttributeValue(n2);
                if (attributeData9 != null && "ref".equals(attributeData9.name)) {
                    this.resolve(xMLNode, attributeData9.value.trim(), qname);
                    definitionTargetNamespace = new DefinitionTargetNamespace("xsd.group", qname[0], qname[1]);
                }
            } else if ("keyRef".equals(string3) && (attributeData = xMLNode.findAttributeValue(n2)) != null && "refer".equals(attributeData.name)) {
                this.resolve(xMLNode, attributeData.value.trim(), qname);
                definitionTargetNamespace = new DefinitionTargetNamespace("xsd.identity", qname[0], qname[1]);
            }
        }
        return definitionTargetNamespace;
    }

    private boolean narrow(XMLNode xMLNode, XMLNode.AttributeData attributeData, Point point) {
        String string = attributeData.value;
        int n = point.x - xMLNode.getOffset();
        int n2 = 0;
        int n3 = string.length();
        while (Util.isIdStart((String)string, (int)(n2 = Util.skipWhitespace((String)string, (int)n2, (int)n3)), (int)n3)) {
            if (n < n2) {
                return false;
            }
            int n4 = n2;
            if (n >= (n2 = Util.skipId((String)string, (int)n2, (int)n3))) continue;
            if (n + point.y > n2) break;
            attributeData.value = string.substring(n4, n2);
            return true;
        }
        return false;
    }

    private void resolve(XMLNode xMLNode, String string, String[] stringArray) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = xMLNode.getNamespace(string2);
            stringArray[0] = string3 == null ? "" : string3;
            stringArray[1] = string.substring(n + 1);
        } else {
            String string4;
            stringArray[0] = string4 = xMLNode.getNamespace("");
            stringArray[1] = string;
        }
    }

    protected DefinitionLocation findDefinitionInTree(XMLNode xMLNode, DefinitionTarget definitionTarget, String string) {
        String string2;
        XMLNode xMLNode2;
        if (definitionTarget.getType() == "xsd.identity") {
            return super.findDefinitionInTree(xMLNode, definitionTarget, string);
        }
        DefinitionLocation definitionLocation = null;
        XMLNode xMLNode3 = xMLNode2 = xMLNode != null ? xMLNode.getSiblingElement() : null;
        if (xMLNode2 != null && (string2 = xMLNode2.getNamespace()) != null && string2.equals("http://www.w3.org/2001/XMLSchema") && "schema".equals(xMLNode2.getLocalname())) {
            if (string == null && (string = xMLNode2.getAttributeValue("targetNamespace")) == null) {
                string = "";
            }
            if (definitionTarget instanceof DefinitionTargetNamespace && ((DefinitionTargetNamespace)definitionTarget).getNamespace().equals(string)) {
                definitionLocation = this.findInSiblings(xMLNode2.getFirstElementChild(), definitionTarget, string);
            }
        }
        return definitionLocation;
    }

    private DefinitionLocation findInSiblings(XMLNode xMLNode, DefinitionTarget definitionTarget, String string) {
        DefinitionLocation definitionLocation = null;
        while (xMLNode != null) {
            if (xMLNode.getLocalname().equals("redefine")) {
                String string2 = xMLNode.getNamespace();
                if (string2 != null && string2.equals("http://www.w3.org/2001/XMLSchema")) {
                    definitionLocation = this.findInSiblings(xMLNode.getFirstElementChild(), definitionTarget, string);
                }
            } else {
                definitionLocation = this.findDefinition(definitionTarget, xMLNode, string);
            }
            if (definitionLocation != null) break;
            xMLNode = xMLNode.getNextElementSibling();
        }
        return definitionLocation;
    }

    protected DefinitionLocation findDefinition(DefinitionTarget definitionTarget, XMLNode xMLNode, String string) {
        String string2;
        DefinitionLocation definitionLocation = null;
        String string3 = xMLNode.getType();
        if ((string3 == "com.objfac.xmlstarttag" || string3 == "com.objfac.xmlemptytag") && (string2 = xMLNode.getNamespace()) != null && string2.equals("http://www.w3.org/2001/XMLSchema")) {
            String string4 = xMLNode.getLocalname();
            String string5 = definitionTarget.getType();
            if ("element".equals(string4)) {
                if (string5 == "xsd.element") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if ("attribute".equals(string4)) {
                if (string5 == "xsd.attribute") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if ("simpleType".equals(string4)) {
                if (string5 == "xsd.simple" || string5 == "xsd.type") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if ("complexType".equals(string4)) {
                if (string5 == "xsd.complex" || string5 == "xsd.type") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if ("attributeGroup".equals(string4)) {
                if (string5 == "xsd.attrgroup") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if ("group".equals(string4)) {
                if (string5 == "xsd.group") {
                    definitionLocation = this.matchName(definitionTarget, xMLNode);
                }
            } else if (("key".equals(string4) || "keyRef".equals(string4) || "unique".equals(string4)) && string5 == "xsd.identity") {
                definitionLocation = this.matchName(definitionTarget, xMLNode);
            }
        }
        return definitionLocation;
    }

    private DefinitionLocation matchName(DefinitionTarget definitionTarget, XMLNode xMLNode) {
        DefinitionLocation definitionLocation = null;
        String string = xMLNode.getAttributeValue("name");
        if (string != null && string.trim().equals(definitionTarget.getName())) {
            XMLNode.AttributeData attributeData = xMLNode.getAttributeData("name");
            if (attributeData.quoteEnd > 0) {
                int n = attributeData.quoteBeg + 1;
                int n2 = attributeData.quoteEnd - 1;
                definitionLocation = new DefinitionLocation(xMLNode.getOffset() + n, n2 - n);
            }
        }
        return definitionLocation;
    }
}

