/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.contentassist;

import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;

public class Tag {
    private Tag fNext;
    private Tag fParent;
    private Tag fFirstChild;
    private Tag fLastChild;
    private String fName;
    private int fType;
    private int fOffset;
    private int fLength;

    public Tag(Tag tag) {
        this.fNext = tag;
    }

    public Tag next() {
        return this.fNext;
    }

    public Tag free(Tag tag) {
        this.fLastChild = null;
        this.fFirstChild = null;
        this.fParent = null;
        this.fName = null;
        return this.link(tag);
    }

    public Tag link(Tag tag) {
        this.fNext = tag;
        return this;
    }

    public void setNext(Tag tag) {
        this.fNext = tag;
    }

    public void setPos(TypedPosition typedPosition) {
        this.fOffset = typedPosition.getOffset();
        this.fLength = typedPosition.getLength();
    }

    public void setPos(int n, int n2) {
        this.fOffset = n;
        this.fLength = n2;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public Tag getParent() {
        return this.fParent;
    }

    public void setParent(Tag tag) {
        this.fParent = tag;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int n) {
        this.fType = n;
    }

    public Tag getFirstChild() {
        return this.fFirstChild;
    }

    public Tag getLastChild() {
        return this.fLastChild;
    }

    public void appendChild(Tag tag) {
        if (this.fFirstChild == null) {
            this.fFirstChild = this.fLastChild = tag;
        } else {
            this.fLastChild.setNext(tag);
            this.fLastChild = tag;
        }
        tag.setParent(this);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public String getName(IDocument iDocument) {
        if (this.fName != null) {
            return this.fName;
        }
        String string = "";
        try {
            int n;
            String string2 = iDocument.get(this.getOffset(), this.getLength());
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n = this.getType() == 4 ? 2 : 1;
            int n3 = string2.length();
            while (n2 < n3) {
                char c = string2.charAt(n2);
                if (!(n2 == n ? XMLCharacter.isIDStart((char)c) : XMLCharacter.isIDPart((char)c))) break;
                stringBuffer.append(c);
                ++n2;
            }
            if (stringBuffer.length() > 0) {
                string = stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        this.setName(string);
        return string;
    }
}

