/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.contentassist;

import com.objfac.util.TabCalculator;
import com.objfac.xml.XMLCharacter;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.template.CursorVariable;
import com.objfac.xmleditor.template.IVariable;
import com.objfac.xmleditor.template.Template;
import com.objfac.xmleditor.template.TemplateContext;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class XMLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String fDisplay;
    private String fReplace;
    private int fOffset;
    private Image fImage;
    private IContextInformation fContextInfo;
    private String fProposalInfo;
    private char[] fTrigger;
    private Point fSelection;
    private IVariable[] fVariables;
    public static final char[] TAG_TRIGGER = new char[]{'\\', '<', ','};
    public static final char[] TDT_TRIGGER = new char[]{'\n', '\t'};
    public static final char[] ATT_TRIGGER = new char[]{'\n', '\t'};
    public static final char[] VAL_TRIGGER = new char[]{'\n', '\t'};
    public static final char[] ENT_TRIGGER = new char[]{'\n', '\t'};
    public static final IVariable[] BUILTINVARIABLES = new IVariable[]{CursorVariable.CURSOR_VARIABLE};

    public XMLCompletionProposal(String string, String string2, int n, char[] cArray, IVariable[] iVariableArray) {
        this(string, string2, n, cArray, iVariableArray, null, null, null);
    }

    public XMLCompletionProposal(String string, String string2, int n, char[] cArray, IVariable[] iVariableArray, Image image, IContextInformation iContextInformation, String string3) {
        this.fDisplay = string;
        this.fReplace = string2;
        this.fTrigger = cArray;
        this.fOffset = n;
        this.fVariables = iVariableArray;
        this.fImage = image;
        this.fContextInfo = iContextInformation;
        this.fProposalInfo = string3;
    }

    public void apply(IDocument iDocument) {
        throw new IllegalStateException("ICompletionProposal#apply(IDocument) should not be called");
    }

    public Point getSelection(IDocument iDocument) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return this.fProposalInfo;
    }

    public String getDisplayString() {
        return this.fDisplay;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInfo;
    }

    public void apply(IDocument iDocument, char c, int n) {
        int n2;
        Assert.isTrue((this.fOffset <= n ? 1 : 0) != 0);
        String string = this.fReplace;
        int n3 = string.length();
        if (n3 > 0 && string.charAt(n3 - 1) == ',') {
            if (c != '<' && c != ',' && c != '\\') {
                c = (char)44;
            }
            string = string.substring(0, n3 - 1);
        }
        XMLEditor xMLEditor = (XMLEditor)XMLEditor.getEditorForDocument(iDocument);
        string = this.adjustCursor(iDocument, c, n, string);
        Template template = Template.REUSABLE_TEMPLATE;
        template.setPattern(string);
        Point point = new Point(-1, -1);
        String string2 = template.replace(new TemplateContext(c), this.fVariables, point);
        int n4 = n;
        if (xMLEditor != null && n4 < (n2 = xMLEditor.getWatchPos(-1))) {
            n4 = n2;
        }
        n2 = this.fOffset;
        int n5 = n4 - this.fOffset;
        try {
            iDocument.replace(n2, n5, string2);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
        }
        if (point.x >= 0) {
            point.x += this.fOffset;
        } else {
            point.x = n2 + string2.length();
            point.y = 0;
        }
        this.fSelection = point;
    }

    private String adjustCursor(IDocument iDocument, char c, int n, String string) {
        XMLEditor xMLEditor = (XMLEditor)XMLEditor.getEditorForDocument(iDocument);
        TabCalculator tabCalculator = new TabCalculator(xMLEditor.getTabWidth(), xMLEditor.getSpacesForTabs());
        switch (c) {
            case '\\': {
                ISourceViewer iSourceViewer;
                int n2 = string.indexOf("</");
                if (n2 < 0 || xMLEditor == null || (iSourceViewer = xMLEditor.getViewer()) == null) break;
                StyledText styledText = iSourceViewer.getTextWidget();
                String string2 = string.substring(n2);
                string = string.substring(0, n2);
                Clipboard clipboard = new Clipboard(styledText.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{string2}, new Transfer[]{textTransfer});
                clipboard.dispose();
                string = this.moveCursorToPos(string, n2);
                break;
            }
            case '<': {
                int n3 = string.indexOf(60);
                if (n3 < 0) break;
                string = this.moveCursorToPos(string, n3);
                break;
            }
            case ',': {
                int n4 = string.indexOf(60);
                if (n4 < 0) break;
                try {
                    IRegion iRegion = iDocument.getLineInformationOfOffset(n);
                    String string3 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    char[] cArray = string3.toCharArray();
                    int n5 = 0;
                    int n6 = n - iRegion.getOffset();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (n5 < n6 && XMLCharacter.isWhitespace((char)cArray[n5])) {
                        stringBuffer.append(cArray[n5]);
                        ++n5;
                    }
                    int n7 = 0;
                    while (n5 < n6) {
                        if (cArray[n5] == '<') {
                            ++n7;
                        }
                        ++n5;
                    }
                    if (n7 <= 0) break;
                    String string4 = System.getProperty("line.separator", "\n");
                    String string5 = iDocument.getLineDelimiter(0);
                    if (string5 != null && string5.length() > 0 && !string5.equals(string4)) {
                        string4 = string5;
                    }
                    String string6 = tabCalculator.normalizeLeadingWhitespace(stringBuffer.toString());
                    String string7 = tabCalculator.tabIn(string6);
                    string = n7 == 1 ? String.valueOf(string.substring(0, n4)) + string4 + string7 + string4 + string6 + string.substring(n4) : String.valueOf(string.substring(0, n4)) + string4 + string7 + string.substring(n4);
                    string = this.moveCursorToPos(string, n4 += string4.length() + string7.length());
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
                break;
            }
            default: {
                if (xMLEditor == null) break;
                try {
                    int n8;
                    String string8;
                    XMLTree xMLTree = xMLEditor.getXMLTree();
                    XMLNode xMLNode = xMLTree.findExactNode(n);
                    boolean bl = false;
                    switch (XMLConstants.getIntType(xMLNode.getType())) {
                        case 20: 
                        case 21: {
                            string8 = xMLNode.getContents();
                            int n9 = string8.length();
                            if (n9 <= 0 || string8.charAt(n9 - 1) != ';') break;
                            bl = true;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 19: {
                            string8 = xMLNode.getContents();
                            int n9 = string8.length();
                            if (n9 <= 0 || string8.charAt(n9 - 1) != '>') break;
                            bl = true;
                        }
                    }
                    if (!bl) break;
                    string8 = iDocument.getLineInformationOfOffset(n);
                    String string9 = iDocument.get(string8.getOffset(), string8.getLength());
                    int n10 = n - string8.getOffset();
                    if (n10 < 0 || n10 >= string9.length() || !XMLCharacter.isIDPart((char)string9.charAt(n10)) || (n8 = string.length()) <= 0 || !XMLCharacter.isIDPart((char)string.charAt(0))) break;
                    int n11 = 1;
                    while (n11 < n8 && XMLCharacter.isIDPart((char)string.charAt(n11))) {
                        ++n11;
                    }
                    string = String.valueOf(string.substring(0, n11)) + "${cursor}";
                    ++n10;
                    while (n10 < string8.getLength() && XMLCharacter.isIDPart((char)string9.charAt(n10))) {
                        ++n10;
                    }
                    xMLEditor.setWatchPos(n10 + string8.getOffset());
                    break;
                }
                catch (BadLocationException badLocationException) {
                    XMLPlugin.log(badLocationException);
                }
            }
        }
        return string;
    }

    private String moveCursorToPos(String string, int n) {
        int n2 = string.indexOf("${cursor}");
        if (n2 >= 0) {
            int n3 = "${cursor}".length();
            if (n > 0 && string.charAt(n - 1) != '>') {
                return string;
            }
            if (n > n2) {
                n -= n3;
            }
            string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + n3);
        }
        string = String.valueOf(string.substring(0, n)) + "${cursor}" + string.substring(n);
        return string;
    }

    public boolean isValidFor(IDocument iDocument, int n) {
        String string;
        if (n < this.fOffset) {
            return false;
        }
        try {
            string = iDocument.get(this.fOffset, n - this.fOffset);
        }
        catch (BadLocationException badLocationException) {
            XMLPlugin.log(badLocationException);
            return false;
        }
        String string2 = this.fDisplay.substring(0, Math.min(this.fDisplay.length(), string.length()));
        return string2.equalsIgnoreCase(string);
    }

    public char[] getTriggerCharacters() {
        return this.fTrigger;
    }

    public int getContextInformationPosition() {
        return -1;
    }
}

