/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition;

import com.objfac.xmleditor.partition.IAbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class CharArrayWrapper
implements IAbstractDocument {
    private char[] fBuf;

    public CharArrayWrapper(char[] cArray) {
        this.fBuf = cArray;
    }

    public int getLength() {
        return this.fBuf.length;
    }

    public String get(int n, int n2) throws BadLocationException {
        if (n < 0 || n + n2 < n || n + n2 > this.getLength()) {
            throw new BadLocationException("offset " + n + " length " + n2);
        }
        return new String(this.fBuf, n, n2);
    }

    public int getLineOfOffset(int n) throws BadLocationException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fBuf.length) {
            if (n3 == n) {
                return n2;
            }
            char c = this.fBuf[n3];
            if (c == '\r') {
                ++n2;
                if (n3 + 1 < this.fBuf.length && this.fBuf[n3 + 1] == '\n') {
                    ++n3;
                }
            } else if (c == '\n') {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public IRegion getLineInformationOfOffset(int n) throws BadLocationException {
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.fBuf.length) {
            char c;
            if (n3 == n) {
                bl = true;
            }
            if ((c = this.fBuf[n3]) == '\r') {
                if (n3 + 1 < this.fBuf.length && this.fBuf[n3 + 1] == '\n') {
                    ++n3;
                }
                if (bl) {
                    return new Region(n2, n3 - n2 + 1);
                }
                n2 = n3 + 1;
            } else if (c == '\n') {
                if (bl) {
                    return new Region(n2, n3 - n2 + 1);
                }
                n2 = n3 + 1;
            }
            ++n3;
        }
        return new Region(n2, this.fBuf.length - n2);
    }
}

