/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition.scanner;

import com.objfac.xmleditor.partition.scanner.IOptimizedRule;
import com.objfac.xmleditor.partition.scanner.IPartitionScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

public class PartionScanner
extends BufferedRuleBasedScanner
implements IPartitionScanner {
    protected String fContentType;
    protected int fPartitionOffset;
    protected int fLineOffset;
    protected boolean fOptimizedRules = false;
    protected boolean fPredicateRules = false;
    protected int fLongRangeEnd;
    protected int fShortRangeEnd;

    public PartionScanner() {
    }

    public PartionScanner(int n) {
        super(n);
    }

    public void setRules(IRule[] iRuleArray) {
        super.setRules(iRuleArray);
    }

    public void setPredicateRules(IPredicateRule[] iPredicateRuleArray) {
        super.setRules((IRule[])iPredicateRuleArray);
        this.fPredicateRules = true;
    }

    public void setPartitionRules(IOptimizedRule[] iOptimizedRuleArray) {
        super.setRules((IRule[])iOptimizedRuleArray);
        this.fOptimizedRules = true;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.setPartialRange(iDocument, n, n2, null, n2);
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.setPartialRange(iDocument, n, n2, string, n3, n2);
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3, int n4) {
        this.fContentType = string;
        this.fPartitionOffset = n3;
        this.fLineOffset = n;
        this.fLongRangeEnd = Math.min(iDocument.getLength(), n + n2);
        this.fShortRangeEnd = n + n4;
        super.setRange(iDocument, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextToken() {
        if (this.fContentType == null || this.fRules == null) {
            return super.nextToken();
        }
        this.fContentType = null;
        this.fTokenOffset = this.fPartitionOffset;
        this.fColumn = -1;
        v0 = var1_1 = this.fPartitionOffset < this.fLineOffset;
        if (this.fOptimizedRules) {
            var2_2 = 0;
            while (var2_2 < this.fRules.length) {
                var3_5 = this.rescan((IOptimizedRule)this.fRules[var2_2], var1_1);
                if (var3_5 != null) {
                    return var3_5;
                }
                ++var2_2;
            }
        } else if (this.fPredicateRules) {
            var2_3 = 0;
            while (var2_3 < this.fRules.length) {
                var3_6 = this.rescan((IPredicateRule)this.fRules[var2_3], var1_1);
                if (var3_6 != null) {
                    return var3_6;
                }
                ++var2_3;
            }
        } else {
            var2_4 = 0;
            while (var2_4 < this.fRules.length) {
                var3_7 = this.fRules[var2_4];
                if (var3_7 instanceof IOptimizedRule) {
                    var4_8 = this.rescan((IOptimizedRule)var3_7, var1_1);
                    if (var4_8 != null) {
                        return var4_8;
                    }
                } else {
                    if (var3_7 instanceof IPredicateRule) {
                        var4_8 = this.rescan((IPredicateRule)var3_7, var1_1);
                        if (var4_8 != null) {
                            return var4_8;
                        } else {
                            ** GOTO lbl38
                        }
                    }
                    break;
                }
lbl38:
                // 3 sources

                ++var2_4;
            }
        }
        this.fOffset = this.fPartitionOffset;
        this.fRangeEnd = this.fLongRangeEnd;
        return super.nextToken();
    }

    protected IToken rescan(IOptimizedRule iOptimizedRule, boolean bl) {
        if (iOptimizedRule.canReturnTokenData(this.fContentType)) {
            if (iOptimizedRule.canOptimize()) {
                this.fOffset = this.fLineOffset;
                this.fRangeEnd = this.fShortRangeEnd;
            } else {
                this.fOffset = this.fPartitionOffset;
                this.fRangeEnd = this.fLongRangeEnd;
            }
            IToken iToken = iOptimizedRule.evaluate((ICharacterScanner)this, bl ? this.fContentType : null);
            if (!iToken.isUndefined()) {
                this.fRangeEnd = this.fLongRangeEnd;
                return iToken;
            }
        }
        return null;
    }

    protected IToken rescan(IPredicateRule iPredicateRule, boolean bl) {
        IToken iToken;
        if (this.fContentType.equals(iPredicateRule.getSuccessToken().getData()) && !(iToken = iPredicateRule.evaluate((ICharacterScanner)this, bl)).isUndefined()) {
            return iToken;
        }
        return null;
    }
}

