/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.partition.scanner;

import com.objfac.xmleditor.partition.CharArrayWrapper;
import com.objfac.xmleditor.partition.scanner.BufferPartitionScanner;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.util.LinkedList;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IToken;

public class XMLParser {
    private int fOffset;
    private int fLength;
    private BufferPartitionScanner fScanner;

    public XMLTree parse(char[] cArray) {
        IToken iToken;
        LinkedList<XMLNode> linkedList = new LinkedList<XMLNode>();
        CharArrayWrapper charArrayWrapper = new CharArrayWrapper(cArray);
        BufferPartitionScanner bufferPartitionScanner = new BufferPartitionScanner();
        bufferPartitionScanner.setRange(cArray);
        while (!(iToken = bufferPartitionScanner.nextToken()).isEOF()) {
            int n = bufferPartitionScanner.getTokenOffset();
            int n2 = bufferPartitionScanner.getTokenLength();
            String string = (String)iToken.getData();
            if (string == null) {
                throw new ParseException("Partition failed at line " + bufferPartitionScanner.getLine() + " col " + bufferPartitionScanner.getColumn());
            }
            XMLNode xMLNode = new XMLNode(n, n2, string, charArrayWrapper);
            linkedList.add(xMLNode);
        }
        XMLTree xMLTree = new XMLTree();
        Position[] positionArray = linkedList.toArray(new Position[linkedList.size()]);
        xMLTree.updateTree(charArrayWrapper, positionArray, 0);
        return xMLTree;
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String string) {
            super(string);
        }
    }
}

