/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xml.io.DocumentCache;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CachePreferencePage
extends ValidatingPreferencePage {
    private boolean fInitialShowText;
    private Button fEnableButton;
    private Button fClearButton;
    private Label fClearLabel;
    private boolean fInitialEnable;
    private boolean fClearCache;
    private DocumentCache fDocumentCache;
    private Composite fOuter;

    protected Control createContents(Composite composite) {
        Composite composite2;
        this.fDocumentCache = DocumentCache.getCache();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fOuter = composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fEnableButton = new Button(composite2, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 1;
        this.fEnableButton.setLayoutData((Object)gridData);
        this.fEnableButton.setText(Local.getString((String)"Enable network document cache"));
        this.fInitialEnable = iPreferenceStore.getBoolean("com.objfac.xmleditor.cacheon");
        this.fEnableButton.setSelection(this.fInitialEnable);
        CachePreferencePage.insertSpacer(composite2, 2);
        this.fClearButton = new Button(composite2, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 1;
        this.fClearButton.setLayoutData((Object)gridData);
        this.fClearButton.setText(Local.getString((String)"Clear Cache"));
        this.fClearLabel = new Label(composite2, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 1;
        gridData.horizontalIndent = 18;
        this.fClearLabel.setLayoutData((Object)gridData);
        this.fClearLabel.setText("");
        composite2.setTabList(new Control[]{this.fEnableButton, this.fClearButton});
        this.fClearButton.addSelectionListener((SelectionListener)new ClearButtonListener());
        return composite2;
    }

    protected void validate() {
        this.setMessages(null, null);
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = this.fEnableButton.getSelection();
        iPreferenceStore.setValue("com.objfac.xmleditor.cacheon", bl);
        this.fDocumentCache.enableCache(bl);
        if (this.fClearCache) {
            try {
                this.fDocumentCache.clearCache();
            }
            catch (IOException iOException) {
                XMLPlugin.log("IOException attempting to clear cache - operation failed");
                XMLPlugin.log(iOException);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fEnableButton.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.cacheon"));
        if (this.fClearCache) {
            this.fClearButton.setEnabled(true);
            this.fClearCache = false;
        }
        super.performDefaults();
    }

    public boolean performCancel() {
        this.fEnableButton.setSelection(this.fInitialEnable);
        return super.performCancel();
    }

    protected void performApply() {
    }

    private class ClearButtonListener
    implements SelectionListener {
        ClearButtonListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            boolean bl = CachePreferencePage.this.fClearButton.getSelection();
            CachePreferencePage.this.fClearCache = bl;
            if (bl) {
                CachePreferencePage.this.fClearLabel.setText(Local.getString((String)"Cache will be cleared when preferences OKed"));
            } else {
                CachePreferencePage.this.fClearLabel.setText("");
            }
            CachePreferencePage.this.fOuter.layout();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }
}

