/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import com.objfac.xmleditor.preferences.XMLDTDSettings;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class XMLDTDPreferencePage
extends ValidatingPreferencePage {
    private Button fMatch;
    private Button fAuto;
    private Table fTable;
    private int fTableRows;
    private boolean fEditing = false;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private String fRoot;
    private String fPub;
    private String fSys;

    public XMLDTDPreferencePage() {
    }

    public XMLDTDPreferencePage(String string) {
        super(string);
    }

    public XMLDTDPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        gridLayout = new Label(composite2, 16384);
        gridLayout.setText(Local.getString((String)"If no DTD specified..."));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridLayout.setLayoutData((Object)gridData);
        XMLDTDPreferencePage.insertSpacer(composite2, 1);
        this.fMatch = new Button(composite2, 16416);
        this.fMatch.setText(Local.getString((String)"Assume DTD if root matches"));
        this.fMatch.setSelection(XMLDTDSettings.isMatch());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.fMatch.setLayoutData((Object)gridData);
        gridData = new Composite(composite2, 16384);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData.setLayoutData((Object)gridData2);
        Object object = new GridLayout();
        object.numColumns = 2;
        gridData.setLayout((Layout)object);
        this.fTable = new Table((Composite)gridData, 84740);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        gridData2 = new GridData(1040);
        gridData2.horizontalAlignment = 1;
        gridData2.verticalAlignment = 1;
        gridData2.horizontalIndent = 10;
        gridData2.heightHint = 300;
        gridData2.widthHint = 300;
        this.fTable.setLayoutData((Object)gridData2);
        object = new TableLayout();
        ColumnWeightData columnWeightData = new ColumnWeightData(1, 50);
        object.addColumnData((ColumnLayoutData)columnWeightData);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(2, 100);
        object.addColumnData((ColumnLayoutData)columnWeightData2);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(2, 100);
        object.addColumnData((ColumnLayoutData)columnWeightData3);
        this.fTable.setLayout((Layout)object);
        TableColumn tableColumn = new TableColumn(this.fTable, 0);
        tableColumn.setText(Local.getString((String)"Root"));
        TableColumn tableColumn2 = new TableColumn(this.fTable, 0);
        tableColumn2.setText(Local.getString((String)"PUBLIC Id"));
        TableColumn tableColumn3 = new TableColumn(this.fTable, 0);
        tableColumn3.setText(Local.getString((String)"SYSTEM Id"));
        ArrayList arrayList = XMLDTDSettings.getMatchRows();
        this.fillTable(arrayList);
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        gridData2 = new Composite((Composite)gridData, 16384);
        object = new GridData();
        object.horizontalAlignment = 1;
        object.verticalAlignment = 1;
        object.horizontalIndent = 10;
        gridData2.setLayoutData(object);
        columnWeightData = new RowLayout(512);
        columnWeightData.marginTop = 0;
        columnWeightData.marginBottom = 6;
        columnWeightData.pack = false;
        gridData2.setLayout((Layout)columnWeightData);
        this.fNewButton = new Button((Composite)gridData2, 0x1000000);
        this.fNewButton.setText(Local.getString((String)"New..."));
        this.fEditButton = new Button((Composite)gridData2, 0x1000000);
        this.fEditButton.setText(Local.getString((String)"Edit..."));
        this.fRemoveButton = new Button((Composite)gridData2, 0x1000000);
        this.fRemoveButton.setText(Local.getString((String)"Remove"));
        this.fAuto = new Button(composite2, 16416);
        this.fAuto.setText(Local.getString((String)"Automatically generate DTD"));
        this.fAuto.setSelection(XMLDTDSettings.isAuto());
        object = new GridData();
        object.horizontalAlignment = 1;
        this.fAuto.setLayoutData(object);
        this.fMatch.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fTable.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fAuto.addSelectionListener((SelectionListener)this.getMultiplexListener());
        object = new ButtonListener();
        this.fNewButton.addSelectionListener((SelectionListener)object);
        this.fEditButton.addSelectionListener((SelectionListener)object);
        this.fRemoveButton.addSelectionListener((SelectionListener)object);
        this.validate();
        return composite2;
    }

    private void fillTable(ArrayList arrayList) {
        this.fTableRows = arrayList.size();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            String[] stringArray = (String[])iterator.next();
            int n = 0;
            while (n < stringArray.length) {
                tableItem.setText(n, stringArray[n]);
                ++n;
            }
        }
    }

    private void buttonClicked(Button button) {
        block4: {
            block5: {
                block3: {
                    if (button != this.fNewButton) break block3;
                    RowDialog rowDialog = new RowDialog(this.getShell(), "", "", "");
                    if (rowDialog.open() == 0) {
                        TableItem tableItem = new TableItem(this.fTable, 0);
                        tableItem.setText(0, this.fRoot);
                        tableItem.setText(1, this.fPub);
                        tableItem.setText(2, this.fSys);
                    }
                    break block4;
                }
                if (button != this.fEditButton) break block5;
                TableItem[] tableItemArray = this.fTable.getSelection();
                if (tableItemArray.length <= 0) break block4;
                TableItem tableItem = tableItemArray[0];
                RowDialog rowDialog = new RowDialog(this.getShell(), tableItem.getText(0), tableItem.getText(1), tableItem.getText(2));
                if (rowDialog.open() != 0) break block4;
                tableItem.setText(0, this.fRoot);
                tableItem.setText(1, this.fPub);
                tableItem.setText(2, this.fSys);
                break block4;
            }
            if (button == this.fRemoveButton) {
                TableItem[] tableItemArray = this.fTable.getSelection();
                int n = 0;
                while (n < tableItemArray.length) {
                    tableItemArray[n].dispose();
                    ++n;
                }
            }
        }
    }

    protected void validate() {
        boolean bl = this.fMatch.getSelection();
        boolean bl2 = bl && this.fTable.getSelectionCount() > 0;
        this.fTable.setEnabled(bl);
        this.fNewButton.setEnabled(bl);
        this.fEditButton.setEnabled(bl && bl2);
        this.fRemoveButton.setEnabled(bl && bl2);
        if (bl) {
            this.fAuto.setText(Local.getString((String)"Automatically generate DTD if no match"));
        } else {
            this.fAuto.setText(Local.getString((String)"Automatically generate DTD"));
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        this.fMatch.setSelection(XMLDTDSettings.getDefaultMatch());
        this.fAuto.setSelection(XMLDTDSettings.getDefaultAuto());
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].dispose();
            ++n;
        }
        ArrayList arrayList = XMLDTDSettings.getDefaultMatchRows();
        this.fillTable(arrayList);
        super.performDefaults();
    }

    public boolean performOk() {
        XMLDTDSettings.setMatch(this.fMatch.getSelection());
        XMLDTDSettings.setAuto(this.fAuto.getSelection());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            String[] stringArray = new String[3];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = tableItem.getText(n2);
                ++n2;
            }
            arrayList.add(stringArray);
            ++n;
        }
        XMLDTDSettings.setMatchRows(arrayList);
        return super.performOk();
    }

    protected void performApply() {
    }

    private class ButtonListener
    implements SelectionListener {
        ButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            XMLDTDPreferencePage.this.buttonClicked((Button)selectionEvent.widget);
        }
    }

    private class RowDialog
    extends Dialog {
        private Text fRootText;
        private Text fPubText;
        private Text fSysText;
        private String fMsg = "";
        private Label fMsgLabel;

        public RowDialog(Shell shell, String string, String string2, String string3) {
            super(shell);
            XMLDTDPreferencePage.this.fRoot = string;
            XMLDTDPreferencePage.this.fPub = string2;
            XMLDTDPreferencePage.this.fSys = string3;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            String string = XMLDTDPreferencePage.this.fRoot.length() == 0 ? Local.getString((String)"New Default DTD") : Local.getString((String)"Edit Default DTD");
            composite.getShell().setText(string);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            this.fMsgLabel = new Label(composite3, 16384);
            GridData gridData = new GridData(769);
            gridData.horizontalSpan = 2;
            gridData.widthHint = 300;
            this.fMsgLabel.setLayoutData((Object)gridData);
            XMLDTDPreferencePage.insertSpacer(composite3, 2);
            gridData = new Label(composite3, 16384);
            gridData.setText(Local.getString((String)"Root name:"));
            this.fRootText = new Text(composite3, 18436);
            this.fRootText.setText(XMLDTDPreferencePage.this.fRoot);
            GridData gridData2 = new GridData(1);
            gridData2.widthHint = 100;
            this.fRootText.setLayoutData((Object)gridData2);
            gridData2 = new Label(composite3, 16384);
            gridData2.setText(Local.getString((String)"PUBLIC id:"));
            this.fPubText = new Text(composite3, 18436);
            this.fPubText.setText(XMLDTDPreferencePage.this.fPub);
            GridData gridData3 = new GridData(769);
            gridData3.widthHint = 200;
            this.fPubText.setLayoutData((Object)gridData3);
            gridData3 = new Label(composite3, 16384);
            gridData3.setText(Local.getString((String)"SYSTEM id:"));
            this.fSysText = new Text(composite3, 18436);
            this.fSysText.setText(XMLDTDPreferencePage.this.fSys);
            Object object = new GridData(769);
            object.widthHint = 200;
            this.fSysText.setLayoutData(object);
            object = new LocalModifyListener();
            this.fRootText.addModifyListener((ModifyListener)object);
            this.fPubText.addModifyListener((ModifyListener)object);
            this.fSysText.addModifyListener((ModifyListener)object);
            return composite2;
        }

        private void validate() {
            String string = this.fMsg;
            this.fMsg = "";
            XMLDTDPreferencePage.this.fRoot = this.fRootText.getText();
            XMLDTDPreferencePage.this.fPub = this.fPubText.getText();
            XMLDTDPreferencePage.this.fSys = this.fSysText.getText();
            if (this.isEmpty(XMLDTDPreferencePage.this.fRoot)) {
                this.fMsg = Local.getString((String)"Root element name must be specified");
            } else if (this.isEmpty(XMLDTDPreferencePage.this.fPub) && this.isEmpty(XMLDTDPreferencePage.this.fSys)) {
                this.fMsg = Local.getString((String)"At least one of PUBLIC or SYSTEM id must be specified");
            }
            Button button = this.getButton(0);
            button.setEnabled(this.fMsg.length() == 0);
            if (!string.equals(this.fMsg)) {
                this.fMsgLabel.setText(this.fMsg);
            }
        }

        private boolean isEmpty(String string) {
            int n = string.length();
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c > ' ') {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private class LocalModifyListener
        implements ModifyListener {
            LocalModifyListener() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                RowDialog.this.validate();
            }
        }
    }
}

