/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.preferences;

import com.objfac.util.Local;
import com.objfac.xmleditor.preferences.ValidatingPreferencePage;
import com.objfac.xmleditor.resources.XMLConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XMLValidationPreferencePage
extends ValidatingPreferencePage {
    private Label fDelayLabel;
    private int fInitialDelay;
    private Text fValidateDelay;
    private boolean fInitialValidateChange;
    private Button fValidateChangeButton;
    private Button fValidateButton;
    private boolean fInitialValidate;

    protected Control createContents(Composite composite) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fValidateButton = new Button(composite2, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 1;
        this.fValidateButton.setLayoutData((Object)gridData);
        this.fValidateButton.setText(Local.getString((String)"pref_Validate_on_save_3"));
        this.fInitialValidate = iPreferenceStore.getBoolean("com.objfac.xmleditor.validateonsave");
        this.fValidateButton.setSelection(this.fInitialValidate);
        XMLValidationPreferencePage.insertSpacer(composite2, 2);
        this.fValidateChangeButton = new Button(composite2, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 1;
        this.fValidateChangeButton.setLayoutData((Object)gridData);
        this.fValidateChangeButton.setText(Local.getString((String)"Validate in background while editing"));
        this.fInitialValidateChange = iPreferenceStore.getBoolean("com.objfac.xmleditor.validateonchange");
        this.fValidateChangeButton.setSelection(this.fInitialValidateChange);
        this.fValidateChangeButton.addSelectionListener((SelectionListener)this.getMultiplexListener());
        this.fDelayLabel = new Label(composite2, 16384);
        this.fDelayLabel.setText(Local.getString((String)"Delay (ms):"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        this.fDelayLabel.setLayoutData((Object)gridData);
        this.fValidateDelay = new Text(composite2, 18436);
        gridData = new GridData();
        gridData.widthHint = 50;
        gridData.horizontalAlignment = 1;
        this.fValidateDelay.setLayoutData((Object)gridData);
        this.fInitialDelay = this.getPreferenceStore().getInt(XMLConstants.ID_VALIDATE_DELAY);
        this.setDelay(this.fInitialDelay);
        this.fValidateDelay.addModifyListener((ModifyListener)this.getModifyListener());
        composite2.setTabList(new Control[]{this.fValidateButton, this.fValidateChangeButton, this.fValidateDelay});
        return composite2;
    }

    private void setDelay(int n) {
        this.fValidateDelay.setText(Integer.toString(n));
        this.fValidateDelay.setSelection(0, this.fValidateDelay.getText().length());
    }

    protected void validate() {
        boolean bl = this.fValidateChangeButton.getSelection();
        this.fDelayLabel.setEnabled(bl);
        this.fValidateDelay.setEnabled(bl);
        if (bl) {
            String string = this.fValidateDelay.getText();
            if (!this.isDigits(string)) {
                this.setMessages(Local.getString((String)"Delay must contain only digits"), null);
            } else if (this.getInt(string) >= 0) {
                this.setMessages(null, null);
            } else {
                this.setMessages(Local.getString((String)"Delay too large (>2^31)"), null);
            }
        } else {
            this.setMessages(null, null);
        }
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("com.objfac.xmleditor.validateonsave", this.fValidateButton.getSelection());
        iPreferenceStore.setValue("com.objfac.xmleditor.validateonchange", this.fValidateChangeButton.getSelection());
        iPreferenceStore.setValue(XMLConstants.ID_VALIDATE_DELAY, this.getInt(this.fValidateDelay.getText()));
        return super.performOk();
    }

    protected void performApply() {
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.fValidateButton.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.validateonsave"));
        this.fValidateChangeButton.setSelection(iPreferenceStore.getDefaultBoolean("com.objfac.xmleditor.validateonchange"));
        this.setDelay(iPreferenceStore.getDefaultInt(XMLConstants.ID_VALIDATE_DELAY));
        super.performDefaults();
    }

    public boolean performCancel() {
        this.fValidateButton.setSelection(this.fInitialValidate);
        this.fValidateChangeButton.setSelection(this.fInitialValidateChange);
        this.setDelay(this.fInitialDelay);
        return super.performCancel();
    }
}

