/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.rewrite;

import com.objfac.walker.IWalker;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;

public class XMLTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        IDocument iDocument;
        XMLEditor xMLEditor;
        if (iRegion != null && (xMLEditor = (XMLEditor)XMLEditor.getEditorForDocument(iDocument = iTextViewer.getDocument())) != null) {
            String string;
            IWalker iWalker = xMLEditor.getWalker();
            XMLTree xMLTree = xMLEditor.getXMLTree();
            XMLNode xMLNode = xMLTree.findNode(iRegion.getOffset());
            Object object = null;
            if (xMLNode.getType() == "com.objfac.xmlpentityref") {
                string = xMLNode.getQName();
                object = iWalker.getPE(string);
            } else if (xMLNode.getType() == "com.objfac.xmlgentityref") {
                string = xMLNode.getQName();
                object = iWalker.getGE(string);
            }
            if (object != null) {
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof IExternalEntity) {
                    string = (IExternalEntity)object;
                    String string2 = string.getSystemId();
                    if (string2 != null && string2.length() > 0) {
                        return "SYSTEM " + string2;
                    }
                    String string3 = string.getPublicId();
                    if (string3 != null && string3.length() > 0) {
                        return "PUBLIC " + string3;
                    }
                }
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.y > 0 && point.x <= n && n <= point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return null;
    }
}

