/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileLabelProvider
extends LabelProvider {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    public static final int SHOW_PATH = 4;
    private static final String fgSeparatorFormat = Local.getString((String)" {0} - {1}");
    private WorkbenchLabelProvider fLabelProvider;
    private ILabelDecorator fDecorator;
    private int fOrder;
    private String[] fArgs = new String[2];

    public FileLabelProvider(int n) {
        this.fDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.fLabelProvider = new WorkbenchLabelProvider();
        this.fOrder = n;
    }

    public void setOrder(int n) {
        this.fOrder = n;
    }

    public String getText(Object object) {
        Object object2;
        if (!(object instanceof ISearchResultViewEntry)) {
            return "";
        }
        IResource iResource = ((ISearchResultViewEntry)object).getResource();
        String string = null;
        if (iResource == null || !iResource.exists()) {
            string = Local.getString((String)" <removed resource>");
        } else {
            object2 = iResource.getFullPath().removeLastSegments(1);
            if (object2.getDevice() == null) {
                object2 = object2.makeRelative();
            }
            if (this.fOrder == 1 || this.fOrder == 2) {
                string = this.fLabelProvider.getText((Object)iResource);
                if (object2 != null && this.fOrder == 2) {
                    this.fArgs[0] = string;
                    this.fArgs[1] = object2.toString();
                    string = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            } else {
                string = object2 != null ? object2.toString() : "";
                if (this.fOrder == 3) {
                    this.fArgs[0] = string;
                    this.fArgs[1] = this.fLabelProvider.getText((Object)iResource);
                    string = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            }
        }
        if (this.fDecorator != null && (object2 = this.fDecorator.decorateText(string, (Object)iResource)) != null) {
            return object2;
        }
        return string;
    }

    public Image getImage(Object object) {
        Image image;
        if (!(object instanceof ISearchResultViewEntry)) {
            return null;
        }
        IResource iResource = ((ISearchResultViewEntry)object).getResource();
        Image image2 = this.fLabelProvider.getImage((Object)iResource);
        if (this.fDecorator != null && (image = this.fDecorator.decorateImage(image2, (Object)iResource)) != null) {
            return image;
        }
        return image2;
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object object, String string) {
        return this.fLabelProvider.isLabelProperty(object, string);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        super.removeListener(iLabelProviderListener);
        this.fLabelProvider.removeListener(iLabelProviderListener);
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        super.addListener(iLabelProviderListener);
        this.fLabelProvider.addListener(iLabelProviderListener);
    }
}

