/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import com.objfac.xmleditor.search.IScope;
import com.objfac.xmleditor.search.ScopedVisitor;
import com.objfac.xmleditor.search.SearchUtils;
import com.objfac.xmleditor.search.XPathSearchMatch;
import com.objfac.xmleditor.search.XPathSearchScope;
import com.objfac.xmleditor.search.XPathSearchVisitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class XPathSearchOperation
extends WorkspaceModifyOperation {
    private String plural;
    private String singular;
    private ISearchResultView view;
    private XPathSearchMatch match;
    private MultiStatus status;
    private WorkCalculator calculator;
    private XPathSearchScope scope;

    public XPathSearchOperation(ISearchResultView iSearchResultView, XPathSearchScope xPathSearchScope, XPathSearchMatch xPathSearchMatch, MultiStatus multiStatus, String string, String string2) {
        this.view = iSearchResultView;
        this.scope = xPathSearchScope;
        this.match = xPathSearchMatch;
        this.status = multiStatus;
        this.singular = string;
        this.plural = string2;
        this.calculator = new WorkCalculator(xPathSearchScope);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        Object object;
        IProject[] iProjectArray = SearchUtils.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(10);
        int n = 0;
        while (n < iProjectArray.length) {
            object = iProjectArray[n];
            if (object.isOpen()) {
                arrayList.add((IProject)object);
            }
            ++n;
        }
        n = this.calculator.calculate(arrayList);
        iProgressMonitor.beginTask("", n);
        if (n > 0) {
            iProgressMonitor.setTaskName(Local.format((String)"Scanning {0} of {1} files", (int)1, (int)n));
            object = new XPathSearchVisitor(this.view, this, this.scope, this.match, iProgressMonitor, this.status, this.singular, this.plural);
            try {
                ((XPathSearchVisitor)object).visitAll(arrayList, n);
            }
            catch (CoreException coreException) {
                this.status.add(coreException.getStatus());
            }
        }
    }

    private class WorkCalculator
    extends ScopedVisitor {
        private int count;

        public WorkCalculator(IScope iScope) {
            super(iScope);
        }

        public int calculate(ArrayList arrayList) {
            this.count = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IProject iProject = (IProject)iterator.next();
                int n = this.count;
                try {
                    iProject.accept((IResourceProxyVisitor)this, 0);
                }
                catch (CoreException coreException) {
                    XPathSearchOperation.this.status.add(coreException.getStatus());
                }
                if (n != this.count) continue;
                iterator.remove();
            }
            return this.count;
        }

        protected boolean visitFile(IResourceProxy iResourceProxy) throws CoreException {
            if (super.visitFile(iResourceProxy)) {
                ++this.count;
                return true;
            }
            return false;
        }
    }
}

