/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import com.objfac.xmleditor.Messages;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.search.SearchUtils;
import com.objfac.xmleditor.search.Wildcard;
import com.objfac.xmleditor.search.XPathSearchMatch;
import com.objfac.xmleditor.search.XPathSearchOperation;
import com.objfac.xmleditor.search.XPathSearchScope;
import com.objfac.xmleditor.xpath.ParseXPath;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;

public class XPathSearchPage
extends DialogPage
implements ISearchPage {
    public static final String PAGE_ID = "com.objfac.xmleditor.xpathsearch";
    private Text fPats;
    private Color black;
    private Color red;
    private Label fMsg;
    private ParseXPath parser;
    private Text fExpr;
    private ISearchPageContainer container;
    private Wildcard wild = new Wildcard();

    public XPathSearchPage() {
        this.parser = new ParseXPath();
        this.red = XMLPlugin.getDefault().getEnvironment().getColor(255, 85, 0);
        this.black = XMLPlugin.getDefault().getEnvironment().getColor(0, 0, 0);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        this.fMsg = new Label(composite2, 16384);
        gridLayout = new GridData(768);
        this.fMsg.setLayoutData((Object)gridLayout);
        gridLayout = new Label(composite2, 16384);
        gridLayout.setText(Local.getString((String)"XPath expression:"));
        GridData gridData = new GridData(768);
        gridLayout.setLayoutData((Object)gridData);
        gridData = XMLPlugin.getDefault().getDialogSettings();
        this.fExpr = new Text(composite2, 2052);
        String string = gridData.get("com.objfac.xpathexpr");
        if (string != null) {
            this.fExpr.setText(string);
            this.fExpr.setSelection(0, string.length());
        }
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 460;
        this.fExpr.setLayoutData((Object)gridData2);
        this.fExpr.addModifyListener((ModifyListener)new ExprListener());
        gridData2 = new Label(composite2, 256);
        Object object = new GridData(768);
        gridData2.setLayoutData(object);
        gridData2 = new Label(composite2, 16384);
        gridData2.setText(Local.getString((String)"File name patterns:"));
        object = new GridData(768);
        gridData2.setLayoutData(object);
        this.fPats = new Text(composite2, 2052);
        object = gridData.get("com.objfac.xpathpats");
        if (object != null) {
            this.fPats.setText((String)object);
            this.fPats.setSelection(0, ((String)object).length());
        }
        GridData gridData3 = new GridData(768);
        this.fPats.setLayoutData((Object)gridData3);
        this.fPats.addModifyListener((ModifyListener)new PatsListener());
        gridData3 = new Label(composite2, 16384);
        gridData3.setText(Local.getString((String)"The patterns are separated by comma (*=any string, ?=any character)"));
        GridData gridData4 = new GridData(768);
        gridData3.setLayoutData((Object)gridData4);
        composite2.setTabList(new Control[]{this.fExpr, this.fPats});
        this.setControl((Control)composite2);
    }

    private boolean validateExpr() {
        String string = this.fExpr.getText();
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = Local.getString((String)"Specify an XPath expression that identifies a nodeset");
            this.setMessages(null, string2);
        } else {
            string2 = this.parser.parseForSyntax(string);
            this.setMessages(string2, null);
        }
        return string2 == null;
    }

    private boolean validatePats() {
        String string = null;
        String string2 = this.fPats.getText();
        string = this.wild.parse(string2);
        this.setMessages(string, null);
        return string == null;
    }

    private void setMessages(String string, String string2) {
        this.setErrorMessage(string);
        this.setMessage(string2);
        if (string == null && string2 == null) {
            this.fMsg.setText("");
            this.fMsg.getParent().layout();
        } else if (string != null) {
            this.fMsg.setForeground(this.red);
            this.fMsg.setText(string);
            this.fMsg.getParent().layout();
        } else {
            this.fMsg.setForeground(this.black);
            this.fMsg.setText(string2);
            this.fMsg.getParent().layout();
        }
        this.container.setPerformActionEnabled(string == null && string2 == null);
    }

    public boolean performAction() {
        String string;
        Object object;
        String string2;
        String string3;
        SearchUI.activateSearchResultView();
        ISearchResultView iSearchResultView = SearchUI.getSearchResultView();
        String string4 = this.fExpr.getText();
        IDialogSettings iDialogSettings = XMLPlugin.getDefault().getDialogSettings();
        iDialogSettings.put("com.objfac.xpathexpr", string4);
        iDialogSettings.put("com.objfac.xpathpats", this.fPats.getText());
        XPathSearchScope xPathSearchScope = null;
        switch (this.container.getSelectedScope()) {
            case 0: {
                xPathSearchScope = XPathSearchScope.getWorkspaceScope(this.wild);
                string3 = Local.format((String)"\"{0}\" - 1 Occurrence in Workspace", (Object)string4, (Object)"{0}");
                string2 = Local.format((String)"\"{0}\" - {1} Occurrences in Workspace", (Object)string4, (Object)"{0}");
                break;
            }
            case 1: {
                xPathSearchScope = new XPathSearchScope(this.wild, this.container.getSelection());
                string3 = Local.format((String)"\"{0}\" - 1 Occurrence in Selection", (Object)string4, (Object)"{0}");
                string2 = Local.format((String)"\"{0}\" - {1} Occurrences in Selection", (Object)string4, (Object)"{0}");
                break;
            }
            case 2: {
                object = this.container.getSelectedWorkingSets();
                xPathSearchScope = new XPathSearchScope(this.wild, (IWorkingSet[])object);
                string = SearchUtils.workingSetList(object);
                string3 = Local.format((String)"\"{0}\" - 1 Occurrence in Working Set - {2}", (Object)string4, (Object)"{0}", (Object)string);
                string2 = Local.format((String)"\"{0}\" - {1} Occurrences in Working Set - {2}", (Object)string4, (Object)"{0}", (Object)string);
                break;
            }
            default: {
                return false;
            }
        }
        object = new XPathSearchMatch(iSearchResultView, string4);
        string = new MultiStatus(XMLPlugin.getPluginId(), 0, Local.getString((String)"Status message"), null);
        XPathSearchOperation xPathSearchOperation = new XPathSearchOperation(iSearchResultView, xPathSearchScope, (XPathSearchMatch)object, (MultiStatus)string, string3, string2);
        IRunnableContext iRunnableContext = null;
        iRunnableContext = this.container.getRunnableContext();
        Shell shell = this.fPats.getShell();
        if (iRunnableContext == null) {
            iRunnableContext = new ProgressMonitorDialog(shell);
        }
        try {
            iRunnableContext.run(true, true, (IRunnableWithProgress)xPathSearchOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)invocationTargetException, (String)Local.getString((String)"Search error(s)"), (String)Messages.xpathSearchError);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (string != null && !string.isOK()) {
            String string5 = Messages.searchErrorTitle;
            ErrorDialog.openError((Shell)this.getShell(), (String)string5, null, (IStatus)string);
        }
        return true;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.container = iSearchPageContainer;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.fExpr != null) {
            if (!this.validateExpr() || this.validatePats()) {
                String string = this.fExpr.getText();
                this.fExpr.setSelection(0, string.length());
                this.fExpr.setFocus();
            } else {
                String string = this.fPats.getText();
                this.fPats.setSelection(0, string.length());
                this.fPats.setFocus();
            }
        }
    }

    private class ExprListener
    implements ModifyListener {
        ExprListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (XPathSearchPage.this.validateExpr()) {
                XPathSearchPage.this.validatePats();
            }
        }
    }

    private class PatsListener
    implements ModifyListener {
        PatsListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (XPathSearchPage.this.validatePats()) {
                XPathSearchPage.this.validateExpr();
            }
        }
    }
}

