/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.search;

import com.objfac.util.Local;
import com.objfac.xmleditor.search.Computer;
import com.objfac.xmleditor.search.FileLabelProvider;
import com.objfac.xmleditor.search.IResultCollector;
import com.objfac.xmleditor.search.NullActionGroupFactory;
import com.objfac.xmleditor.search.ScopedVisitor;
import com.objfac.xmleditor.search.XPathSearchMatch;
import com.objfac.xmleditor.search.XPathSearchOperation;
import com.objfac.xmleditor.search.XPathSearchScope;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.moved.GotoMarkerAction;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;

public class XPathSearchVisitor
extends ScopedVisitor
implements IResultCollector {
    private static final String MATCH = Local.getString((String)"{0} match");
    private static final String MATCHES = Local.getString((String)"{0} matches");
    private static final String DONE = Local.getString((String)"Search done: {0}.");
    private Object[] messageFormatArgs;
    private int matchCount;
    private XPathSearchOperation operation;
    private ISearchResultView view;
    private String plural;
    private String singular;
    private MultiStatus status;
    private XPathSearchMatch match;
    private IProgressMonitor monitor;
    private int filesToScan;
    private int filesScanned;
    private long lastUpdateTime;

    public XPathSearchVisitor(ISearchResultView iSearchResultView, XPathSearchOperation xPathSearchOperation, XPathSearchScope xPathSearchScope, XPathSearchMatch xPathSearchMatch, IProgressMonitor iProgressMonitor, MultiStatus multiStatus, String string, String string2) {
        super(xPathSearchScope);
        this.view = iSearchResultView;
        this.operation = xPathSearchOperation;
        this.match = xPathSearchMatch;
        this.monitor = iProgressMonitor;
        this.status = multiStatus;
        this.singular = string;
        this.plural = string2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitAll(ArrayList arrayList, int n) throws CoreException {
        this.filesToScan = n;
        this.filesScanned = 0;
        this.lastUpdateTime = 0L;
        try {
            this.view.searchStarted((IActionGroupFactory)new NullActionGroupFactory(), this.singular, this.plural, null, "com.objfac.xmleditor.xpathsearch", (ILabelProvider)new FileLabelProvider(2), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new Computer(), (IRunnableWithProgress)this.operation);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                IProject iProject = (IProject)arrayList.get(n2);
                iProject.accept((IResourceProxyVisitor)this, 0);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.view.searchFinished();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.view.searchFinished();
    }

    public void done() {
        if (!this.monitor.isCanceled()) {
            String string = this.getMatchesString(this.matchCount);
            this.monitor.setTaskName(Local.format((String)"Search done: {0}.", (Object)string));
        }
        if (this.view != null) {
            this.view.searchFinished();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean visitFile(IResourceProxy iResourceProxy) throws CoreException {
        if (!super.visitFile(iResourceProxy)) {
            return false;
        }
        IFile iFile = (IFile)iResourceProxy.requestResource();
        try {
            this.match.match(iFile, this.status, this);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.updateProgressMonitor();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.updateProgressMonitor();
            return true;
        }
    }

    private void updateProgressMonitor() {
        ++this.filesScanned;
        if (this.filesScanned < this.filesToScan && System.currentTimeMillis() - this.lastUpdateTime > 1000L) {
            this.monitor.setTaskName(Local.format((String)"Scanning {0} of {1} files", (int)this.filesScanned, (int)this.filesToScan));
            this.lastUpdateTime = System.currentTimeMillis();
        }
        this.monitor.worked(1);
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException(Local.getString((String)"XPath search canceled"));
        }
    }

    public void accept(final IResource iResource, String string, int n, int n2, int n3) throws CoreException {
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("line", string);
        hashMap.put("charStart", new Integer(n));
        hashMap.put("charEnd", new Integer(n + n2));
        hashMap.put("lineNumber", new Integer(n3));
        final IMarker[] iMarkerArray = new IMarker[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource.createMarker("org.eclipse.search.searchmarker");
                iMarker.setAttributes((Map)hashMap);
                iMarkerArray[0] = iMarker;
            }
        };
        iResource.getWorkspace().run(iWorkspaceRunnable, null);
        String string2 = iResource.getFullPath().lastSegment();
        if (string2 == null) {
            string2 = "";
        }
        this.view.addMatch(string2, (Object)iResource, iResource, iMarkerArray[0]);
        ++this.matchCount;
        if (!this.monitor.isCanceled() && System.currentTimeMillis() - this.lastUpdateTime > 1000L) {
            this.monitor.subTask(this.getMatchesString(this.matchCount));
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    private String getMatchesString(int n) {
        if (this.matchCount == 1) {
            return MATCH;
        }
        this.messageFormatArgs[0] = new Integer(n);
        return MessageFormat.format(MATCHES, this.messageFormatArgs);
    }
}

