/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.validate;

import com.objfac.rnceditor.RNCEditor;
import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.walker.EmptyWalker;
import com.objfac.walker.IWalker;
import com.objfac.xml.DefaultLocatorInfo;
import com.objfac.xml.LocatorInfo;
import com.objfac.xml.Util;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xmleditor.BaseEditor;
import com.objfac.xmleditor.DTDParams;
import com.objfac.xmleditor.IOutlineTree;
import com.objfac.xmleditor.XMLEditor;
import com.objfac.xmleditor.XMLPlugin;
import com.objfac.xmleditor.preferences.XMLSchemaSettings;
import com.objfac.xmleditor.resources.PluginFactoryExtension;
import com.objfac.xmleditor.resources.ResourceWatcherCallback;
import com.objfac.xmleditor.resources.XMLConstants;
import com.objfac.xmleditor.validate.ErrorCollector;
import com.objfac.xmleditor.validate.ErrorTuple;
import com.objfac.xmleditor.validate.JingValidator;
import com.objfac.xmleditor.validate.ParserContext;
import com.objfac.xmleditor.validate.SchemaValidator;
import com.objfac.xmleditor.validate.XMLSchemaReaderShell;
import com.objfac.xmleditor.validate.XercesValidator;
import com.objfac.xmleditor.xmltree.XMLNode;
import com.objfac.xmleditor.xmltree.XMLTree;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class XMLValidationShell {
    private IWalker fWalker;
    public static final String XERCES_VALIDATOR_CLASS = "com.objfac.xmleditor.xerces.DTDValidator";
    public static final String JING_VALIDATOR_CLASS = "com.objfac.xmleditor.xerces.RelaxNGValidator";
    public static final String XERCES_SCHEMA_VALIDATOR_CLASS = "com.objfac.xmleditor.xerces.XercesSchemaValidator";
    private ErrorCollector fCleanErrors;
    private boolean fBackground;
    private XMLEditor fXMLEditor;
    private BaseEditor fEditor;
    private RNCEditor fRNCEditor;
    private IFile fFile;
    private static final int RNC_DOC = 0;
    private static final int RNC_SCH = 1;
    private static final int RNG_DOC = 2;
    private static final int RNG_SCH = 3;
    private static final int XSD_DOC = 4;
    private static final int XSD_SCH = 5;
    private static final int NRL_DOC = 6;
    private static final int NRL_SCH = 7;
    private static final int DTD_DOC = 8;
    private static final int DTD_SCH = 9;
    private static final int XSE_DOC = 10;
    private static final int NON_DOC = 11;
    private static final int XSL_DOC = 12;
    private static final int UNK_DOC = 13;
    private static final int[] jingKinds;

    static {
        int[] nArray = new int[14];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 3;
        nArray[8] = 10;
        nArray[9] = 10;
        nArray[10] = 10;
        nArray[11] = 10;
        nArray[13] = 10;
        jingKinds = nArray;
    }

    private XMLValidationShell(BaseEditor baseEditor, boolean bl) {
        this.fBackground = bl;
        this.fEditor = baseEditor;
    }

    public XMLValidationShell() {
        this(null, true);
    }

    public XMLValidationShell(BaseEditor baseEditor) {
        this(baseEditor, false);
    }

    public void validate() {
        this.backgroundValidate(this.fEditor);
        this.showValidateErrors(this.fEditor);
    }

    private void backgroundValidate(BaseEditor baseEditor) {
        IOutlineTree iOutlineTree = baseEditor.getOutlineTree();
        this.backgroundValidate(baseEditor.getEditorKind(), baseEditor.getDTDParams(), baseEditor.getUrl(), baseEditor.getDocument().get(), baseEditor.getEncoding(), iOutlineTree, iOutlineTree.getDoctypeContents(true), baseEditor.getResourceWatcherCallback());
    }

    private int convertToKind(int n, DTDParams dTDParams) {
        switch (n) {
            case 3: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 4: {
                return 5;
            }
            case 0: {
                if (dTDParams.auto) {
                    return 11;
                }
                if (dTDParams.trnc) {
                    return 0;
                }
                if (dTDParams.trng) {
                    return 2;
                }
                boolean cfr_ignored_0 = dTDParams.exsd;
                if (dTDParams.txsd) {
                    return 4;
                }
                return 8;
            }
            case 6: {
                return 12;
            }
        }
        return 13;
    }

    public void backgroundValidate(int n, DTDParams dTDParams, String string, String string2, String string3, IOutlineTree iOutlineTree, String string4, ResourceWatcherCallback resourceWatcherCallback) {
        int n2 = this.convertToKind(n, dTDParams);
        this.fCleanErrors = new ErrorCollector();
        switch (n2) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.xercesValidate(n2, dTDParams, string, string2, string3, iOutlineTree, string4, resourceWatcherCallback);
                break;
            }
            case 4: {
                this.xercesParseAndValidate(n2, dTDParams, string, string2, string3, iOutlineTree, string4, resourceWatcherCallback);
                break;
            }
            case 5: {
                this.xercesParseAndValidateSchema(n2, dTDParams, string, string2, string3, iOutlineTree, string4, resourceWatcherCallback);
                XMLSchemaReaderShell xMLSchemaReaderShell = new XMLSchemaReaderShell();
                ErrorCollector errorCollector = new ErrorCollector();
                IWalker iWalker = xMLSchemaReaderShell.getXsdSchemaWalker(errorCollector, resourceWatcherCallback);
                if (this.fWalker == null) {
                    this.fWalker = iWalker;
                    break;
                }
                if (iWalker == null || iWalker instanceof EmptyWalker) break;
                this.fWalker.addWalker("http://www.w3.org/2001/XMLSchema", iWalker);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                this.jingValidate(n2, dTDParams, string, string2, string3, resourceWatcherCallback);
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jingValidate(int n, DTDParams dTDParams, String string, String string2, String string3, ResourceWatcherCallback resourceWatcherCallback) {
        IExternalEntity iExternalEntity;
        ParserContext parserContext;
        Object object;
        String string4;
        StringReader stringReader;
        String string5;
        String string6;
        Reader reader;
        Object object2;
        int n2;
        block11: {
            char[] cArray;
            IDocumentReaderFactory iDocumentReaderFactory;
            block12: {
                block10: {
                    iDocumentReaderFactory = PluginFactoryExtension.getFactory();
                    n2 = jingKinds[n];
                    if (n != 1) break block10;
                    if (!dTDParams.prim) {
                        n2 = 4;
                    }
                    object2 = string;
                    reader = new StringReader(string2);
                    string6 = string3;
                    string5 = null;
                    stringReader = null;
                    string4 = null;
                    break block11;
                }
                if (n != 3 && n != 5 && n != 12) break block12;
                if (n != 12 && dTDParams.prim) {
                    object2 = string;
                    reader = new StringReader(string2);
                    string6 = string3;
                    string5 = null;
                    stringReader = null;
                    string4 = null;
                    break block11;
                } else {
                    object = this.getClass().getResource(n == 3 ? "relaxng.rng" : (n == 12 ? "xslt.rnc" : "xsd.rng"));
                    object2 = ((URL)object).toExternalForm();
                    try {
                        reader = new InputStreamReader(((URL)object).openStream());
                    }
                    catch (IOException iOException) {
                        this.cantReadSchemaError(string, iOException);
                        return;
                    }
                    string6 = "UTF-8";
                    string5 = string;
                    stringReader = new StringReader(string2);
                    string4 = string3;
                    n2 = n == 12 ? 1 : 0;
                }
                break block11;
            }
            object = Util.xmlListToArray((String)dTDParams.url);
            object2 = ((String[])object).length == 1 ? object[0] : (((Object)object).length > 1 ? object[1] : dTDParams.url);
            parserContext = new ExternalEntity(null, null, string, iDocumentReaderFactory);
            iExternalEntity = parserContext.getEntity(null, (String)object2);
            try {
                cArray = iExternalEntity.getContents();
            }
            catch (IOException iOException) {
                this.cantReadSchemaError(string, iOException);
                return;
            }
            object2 = Misc.getAbsUrl((String)string, (String)object2);
            reader = new CharArrayReader(cArray);
            string6 = null;
            string5 = string;
            stringReader = new StringReader(string2);
            string4 = string3;
        }
        object = (JingValidator)XMLPlugin.getDefault().getValidator(JING_VALIDATOR_CLASS);
        parserContext = new ParserContext();
        try {
            object.validate((String)object2, reader, string6, n2, string5, stringReader, string4, this.fCleanErrors, resourceWatcherCallback);
        }
        catch (Throwable throwable) {
            iExternalEntity = null;
            parserContext.restore();
            throw throwable;
        }
        {
            iExternalEntity = null;
            parserContext.restore();
            return;
        }
    }

    private void cantReadSchemaError(String string, IOException iOException) {
        DefaultLocatorInfo defaultLocatorInfo = new DefaultLocatorInfo(null, string, 1, 0);
        this.fCleanErrors.error(3, Local.format((String)"Can''t read schema: {0} - {1}", (Object)string, (Object)iOException.toString()), (LocatorInfo)defaultLocatorInfo);
    }

    private void xercesParseAndValidate(int n, DTDParams dTDParams, String string, String string2, String string3, IOutlineTree iOutlineTree, String string4, ResourceWatcherCallback resourceWatcherCallback) {
        StringReader stringReader = new StringReader(string2);
        String[] stringArray = this.getNsMap();
        String string5 = dTDParams.nxsd ? dTDParams.url : null;
        SchemaValidator schemaValidator = (SchemaValidator)XMLPlugin.getDefault().loadInternalClass(XERCES_SCHEMA_VALIDATOR_CLASS);
        this.fWalker = schemaValidator.validate(string, stringReader, stringArray, string5, this.fCleanErrors, dTDParams.exsd | dTDParams.nxsd | dTDParams.txsd, resourceWatcherCallback);
    }

    private void xercesParseAndValidateSchema(int n, DTDParams dTDParams, String string, String string2, String string3, IOutlineTree iOutlineTree, String string4, ResourceWatcherCallback resourceWatcherCallback) {
        StringReader stringReader = new StringReader(string2);
        String[] stringArray = this.getNsMap();
        String string5 = dTDParams.nxsd ? dTDParams.url : null;
        SchemaValidator schemaValidator = (SchemaValidator)XMLPlugin.getDefault().loadInternalClass(XERCES_SCHEMA_VALIDATOR_CLASS);
        this.fWalker = schemaValidator.validateSchema(string, stringReader, stringArray, string5, this.fCleanErrors, resourceWatcherCallback);
    }

    private String[] getNsMap() {
        XMLSchemaSettings xMLSchemaSettings = new XMLSchemaSettings("com.objfac.xmleditor.xsd");
        ArrayList arrayList = xMLSchemaSettings.getMatchRows();
        String[] stringArray = new String[arrayList.size() * 3];
        int n = 0;
        String[] stringArray2 = arrayList.iterator();
        while (stringArray2.hasNext()) {
            String[] stringArray3 = (String[])stringArray2.next();
            boolean bl = stringArray3[0].startsWith("$");
            if (stringArray3[0].length() != 0 && !bl || stringArray3[1].length() == 0 || stringArray3[2].length() == 0) continue;
            stringArray[n++] = stringArray3[1];
            stringArray[n++] = stringArray3[2];
            stringArray[n++] = bl ? stringArray3[0].substring(1) : "";
        }
        stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void xercesValidate(int n, DTDParams dTDParams, String string, String object, String string2, IOutlineTree iOutlineTree, String string3, ResourceWatcherCallback resourceWatcherCallback) {
        String string4;
        String string5;
        StringReader stringReader;
        Object object2;
        if (n == 9) {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("<!DOCTYPE z-x_k-v PUBLIC \"\" \"");
            ((StringBuffer)object2).append(string);
            ((StringBuffer)object2).append("\" [<!ELEMENT z-x_k-v EMPTY>]><z-x_k-v/>");
            stringReader = new StringReader(((StringBuffer)object2).toString());
            string5 = "";
            string4 = string;
        } else {
            object2 = new String[]{object};
            if (dTDParams.tdtd) {
                if (!this.replacePubSys(dTDParams, string3, (String[])object2)) {
                    string5 = null;
                    string4 = null;
                } else {
                    object = object2[0];
                    string5 = dTDParams.pub;
                    string4 = dTDParams.sys;
                }
            } else {
                string5 = dTDParams.epub;
                string4 = dTDParams.esys;
            }
            stringReader = new StringReader((String)object);
        }
        object2 = (XercesValidator)XMLPlugin.getDefault().getValidator(XERCES_VALIDATOR_CLASS);
        ParserContext parserContext = new ParserContext();
        try {
            object2.validate(stringReader, this.fCleanErrors, string5, string4, string, string2, string3, dTDParams.exsd, resourceWatcherCallback);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            parserContext.restore();
            throw throwable;
        }
        {
            Object var14_16 = null;
            parserContext.restore();
            return;
        }
    }

    public void showValidateErrors(final BaseEditor baseEditor) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    XMLValidationShell.this.doShowValidateErrors(baseEditor);
                }
            };
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }

    public IWalker getWalker() {
        return this.fWalker;
    }

    private void doShowValidateErrors(BaseEditor baseEditor) {
        Object object;
        boolean bl;
        this.fEditor = baseEditor;
        this.fFile = this.getFile(this.fEditor);
        if (this.fFile == null) {
            return;
        }
        this.doClear(false);
        boolean bl2 = bl = baseEditor.getEditorKind() == 3;
        if (bl) {
            this.fRNCEditor = (RNCEditor)baseEditor;
        } else {
            this.fXMLEditor = (XMLEditor)baseEditor;
        }
        LinkedList linkedList = this.fCleanErrors.getErrors();
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (ErrorTuple)iterator.next();
            if (bl) {
                this.addRncError(object.level, object.message, object.info);
            } else {
                this.addXmlError(object.level, object.message, object.info);
            }
            if (n++ <= 500) continue;
            this.addXmlError(2, Local.getString((String)"More than 500 errors"), object.info);
            break;
        }
        object = baseEditor.getViewer();
        object.invalidateTextPresentation();
        object.showAnnotations(true);
    }

    private IFile getFile(BaseEditor baseEditor) {
        IEditorInput iEditorInput = baseEditor.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean replacePubSys(DTDParams var1_1, String var2_2, String[] var3_3) {
        block14: {
            block13: {
                if (var2_2 == null || var2_2.length() <= 0) break block13;
                var4_4 = var3_3[0].indexOf(var2_2);
                if (var4_4 < 0) {
                    return false;
                }
                var5_6 = var2_2.length();
                if (!var2_2.startsWith("<!DOCTYPE")) break block14;
                var6_8 = "<!DOCTYPE".length();
                if ((var6_8 = this.skipWS(var2_2, var6_8, var5_6)) != var5_6) ** GOTO lbl11
                return false;
lbl-1000:
                // 1 sources

                {
                    ++var6_8;
lbl11:
                    // 2 sources

                    ** while (var6_8 < var5_6 && XMLCharacter.isIDPart((char)var2_2.charAt((int)var6_8)))
                }
lbl12:
                // 1 sources

                if ((var6_8 = this.skipWS(var2_2, var6_8, var5_6)) == var5_6) {
                    return false;
                }
                var7_10 = var2_2.charAt(var6_8);
                var8_12 = var6_8;
                if (var7_10 == 'P' || var7_10 == 'S') {
                    var9_13 = this.collectId(var2_2, var6_8, var5_6);
                    var6_8 += var9_13.length();
                    if ("PUBLIC".equals(var9_13)) {
                        if ((var6_8 = this.skipWS(var2_2, var6_8, var5_6)) == var5_6) {
                            return false;
                        }
                        if ((var6_8 = this.skipString(var2_2, var6_8, var5_6)) == var5_6) {
                            return false;
                        }
                    } else if (!"SYSTEM".equals(var9_13)) {
                        return false;
                    }
                    if ((var6_8 = this.skipWS(var2_2, var6_8, var5_6)) == var5_6) {
                        return false;
                    }
                    if ((var6_8 = this.skipString(var2_2, var6_8, var5_6)) == var5_6) {
                        return false;
                    }
                }
                var3_3[0] = String.valueOf(var3_3[0].substring(0, var4_4 + var8_12)) + " PUBLIC \"" + var1_1.pub + "\" \"" + var1_1.sys + "\" " + var3_3[0].substring(var4_4 + var6_8);
                break block14;
            }
            var4_5 = this.findRootNoDoctype(var3_3[0]);
            if (var4_5 < 0) {
                return false;
            }
            var5_7 = new StringBuffer();
            var6_9 = var4_5 + 1;
            var7_11 = var3_3[0].length();
            while (var6_9 < var7_11 && XMLCharacter.isIDPart((char)var3_3[0].charAt(var6_9))) {
                var5_7.append(var3_3[0].charAt(var6_9));
                ++var6_9;
            }
            var3_3[0] = String.valueOf(var3_3[0].substring(0, var4_5)) + "<!DOCTYPE " + var5_7.toString() + " PUBLIC \"" + var1_1.pub + "\" \"" + var1_1.sys + "\">" + var3_3[0].substring(var4_5);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int findRootNoDoctype(String var1_1) {
        var2_2 = 0;
        var3_3 = var1_1.length();
        block0: while (true) {
            if (var2_2 < var3_3 && var1_1.charAt(var2_2) != '<') {
                ++var2_2;
                continue;
            }
            if (++var2_2 >= var3_3) {
                return -1;
            }
            var4_4 = var1_1.charAt(var2_2);
            if (XMLCharacter.isIDStart((char)var4_4)) {
                return var2_2 - 1;
            }
            if (var4_4 == '?') {
                do {
                    if (++var2_2 >= var3_3) continue block0;
                } while (var1_1.charAt(var2_2) != '?' || var2_2 + 1 >= var3_3 || var1_1.charAt(var2_2 + 1) != '>');
                var2_2 += 2;
                continue;
            }
            if (var4_4 != '!') continue;
            if (++var2_2 < var3_3 && var1_1.charAt(var2_2) == '-' && ++var2_2 < var3_3 && var1_1.charAt(var2_2) == '-') ** GOTO lbl29
            return -1;
lbl-1000:
            // 1 sources

            {
                if (var1_1.charAt(var2_2) != '-') continue;
                if (++var2_2 >= var3_3) {
                    return -1;
                }
                if (var1_1.charAt(var2_2) != '-') continue;
                if (++var2_2 >= var3_3 || var1_1.charAt(var2_2) != '>') {
                    return -1;
                }
                ++var2_2;
                continue block0;
lbl29:
                // 3 sources

                ** while (++var2_2 < var3_3)
            }
lbl30:
            // 1 sources

        }
    }

    private boolean replacePubSys(DTDParams dTDParams, XMLTree xMLTree) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int skipString(String var1_1, int var2_2, int var3_3) {
        if (var2_2 == var3_3) {
            return var3_3;
        }
        if ((var4_4 = var1_1.charAt(var2_2++)) == '\"' || var4_4 == '\'') ** GOTO lbl6
        return var3_3;
lbl-1000:
        // 1 sources

        {
            ++var2_2;
lbl6:
            // 2 sources

            ** while (var2_2 < var3_3 && var1_1.charAt((int)var2_2) != var4_4)
        }
lbl7:
        // 1 sources

        if (var2_2 < var3_3) {
            ++var2_2;
        }
        return var2_2;
    }

    private String collectId(String string, int n, int n2) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2 && XMLCharacter.isIDPart((char)(c = string.charAt(n)))) {
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private int skipWS(String string, int n, int n2) {
        while (n < n2 && XMLCharacter.isWhitespace((char)string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public void clear(final boolean bl) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    XMLValidationShell.this.doClear(bl);
                }
            };
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }

    private void doCleanClear(BaseEditor baseEditor, boolean bl) {
        IEditorInput iEditorInput = baseEditor.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            try {
                if (!bl) {
                    iFile.deleteMarkers("com.objfac.xmleditor.xmlproblem", false, 0);
                }
                iFile.deleteMarkers("com.objfac.xmleditor.xmlcheck", false, 0);
            }
            catch (CoreException coreException) {
                XMLPlugin.log(coreException);
            }
        }
    }

    private void doClear(boolean bl) {
        this.doCleanClear(this.fEditor, bl);
    }

    private void addRncError(int n, String string, LocatorInfo locatorInfo) {
        int n2 = Math.max(locatorInfo.getLineNo() - 1, 0);
        int n3 = Math.max(locatorInfo.getBegOffset() - 1, 0);
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
            hashMap.put("message", string);
            hashMap.put("lineNumber", new Integer(n2 + 1));
            this.setSeverity(n, hashMap);
            IDocument iDocument = this.fEditor.getDocument();
            try {
                IRegion iRegion = iDocument.getLineInformation(n2);
                int n4 = iRegion.getOffset();
                int n5 = iRegion.getLength();
                int n6 = Math.min(n4 + n3, n4 + n5 - 1);
                int n7 = n6 + 1;
                String string2 = iDocument.get(n4, iRegion.getLength());
                int n8 = 0;
                int n9 = 0;
                while (n8 < n5) {
                    char c = string2.charAt(n8);
                    n9 = c == '\t' ? (n9 / 8 + 1) * 8 : ++n9;
                    if (n9 > n3) {
                        n6 = n8 + n4;
                        while (n8 < n5 && !XMLCharacter.isWhitespace((char)(c = string2.charAt(n8)))) {
                            ++n8;
                        }
                        n7 = n8 + n4;
                        break;
                    }
                    ++n8;
                }
                hashMap.put("charStart", new Integer(Math.max(n6, 0)));
                hashMap.put("charEnd", new Integer(Math.max(n7, 0)));
                MarkerUtilities.createMarker((IResource)this.fFile, hashMap, (String)(this.fBackground ? "com.objfac.xmleditor.xmlcheck" : "com.objfac.xmleditor.xmlproblem"));
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }

    private void setSeverity(int n, HashMap hashMap) {
        if (this.fBackground && !"e3.1.0".startsWith("e3")) {
            hashMap.put("severity", new Integer(0));
        } else {
            switch (n) {
                case 2: 
                case 3: {
                    hashMap.put("severity", new Integer(2));
                    break;
                }
                case 1: {
                    hashMap.put("severity", new Integer(1));
                    break;
                }
                default: {
                    hashMap.put("severity", new Integer(0));
                }
            }
        }
    }

    public void addXmlError(int n, String string, LocatorInfo locatorInfo) {
        int n2 = Math.max(locatorInfo.getLineNo(), 1);
        int n3 = locatorInfo.getBegOffset() - 1;
        String string2 = this.fFile.getName();
        String string3 = locatorInfo.getSystemId();
        if (string3 == null) {
            string3 = string2;
        }
        String string4 = string3;
        int n4 = string3.lastIndexOf(47);
        if (n4 >= 0) {
            string4 = string3.substring(n4 + 1);
        }
        if (!string2.equals(string4)) {
            string = Local.format((String)"{0} in file {1}", (Object)string, (Object)string3);
            n2 = 1;
            n3 = 0;
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
            hashMap.put("message", string);
            hashMap.put("lineNumber", new Integer(n2));
            this.setSeverity(n, hashMap);
            try {
                IDocument iDocument = this.fEditor.getDocument();
                IRegion iRegion = iDocument.getLineInformation(n2 - 1);
                int n5 = iRegion.getOffset();
                int n6 = n5 + n3 - 1;
                n6 = Math.min(n6, iRegion.getOffset() + iRegion.getLength() - 1);
                int n7 = n6 + 1;
                if (n6 >= 0) {
                    int n8;
                    XMLTree xMLTree = this.fXMLEditor.getXMLTree();
                    XMLNode xMLNode = xMLTree.findExactNode(n6);
                    boolean bl = false;
                    block2 : switch (XMLConstants.getIntType(xMLNode.getType())) {
                        case 2: 
                        case 3: 
                        case 6: {
                            n6 = xMLNode.getOffset();
                            n7 = n6 + xMLNode.getLength();
                            int n9 = string.indexOf(34);
                            if (n9 < 0 || (n8 = string.indexOf(34, n9 + 1)) <= n9 + 1) break;
                            String string5 = string.substring(n9 + 1, n8);
                            String string6 = xMLNode.getQName();
                            if (string6.equals(string5)) {
                                n7 = n6 + string6.length() + 1;
                                break;
                            }
                            List list = xMLNode.getAttributeList();
                            List list2 = xMLNode.getAttributeOffsets();
                            Iterator iterator = list.iterator();
                            Iterator iterator2 = list2.iterator();
                            while (iterator.hasNext()) {
                                String string7 = (String)iterator.next();
                                String cfr_ignored_0 = (String)iterator.next();
                                Integer n10 = (Integer)iterator2.next();
                                if (!string7.equals(string5)) continue;
                                n7 = (n6 += n10.intValue()) + string7.length();
                                break block2;
                            }
                            break;
                        }
                        case 1: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            n6 = xMLNode.getOffset();
                            String string8 = xMLNode.getContents();
                            n8 = 0;
                            int n11 = string8.length();
                            while (n8 < n11) {
                                char c = string8.charAt(n8);
                                if (XMLCharacter.isWhitespace((char)c)) break;
                                ++n8;
                            }
                            n7 = n6 + n8;
                            break;
                        }
                        case 4: 
                        case 20: 
                        case 21: {
                            n6 = xMLNode.getOffset();
                            n7 = n6 + xMLNode.getLength();
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        String string9 = xMLNode.getContents();
                        n8 = n6 - xMLNode.getOffset();
                        while (n8 >= 0 && !XMLCharacter.isWhitespace((char)string9.charAt(n8))) {
                            --n8;
                        }
                        n7 = n6 + 1;
                        n6 = xMLNode.getOffset() + n8 + 1;
                    }
                }
                hashMap.put("charStart", new Integer(Math.max(n6, 0)));
                hashMap.put("charEnd", new Integer(Math.max(n7, 0)));
            }
            catch (BadLocationException badLocationException) {
                XMLPlugin.log(badLocationException);
            }
            MarkerUtilities.createMarker((IResource)this.fFile, hashMap, (String)(this.fBackground ? "com.objfac.xmleditor.xmlcheck" : "com.objfac.xmleditor.xmlproblem"));
        }
        catch (CoreException coreException) {
            XMLPlugin.log(coreException);
        }
    }
}

