/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.xmleditor.Config;
import com.objfac.xmleditor.wizards.FileCreationWizard;
import com.objfac.xmleditor.wizards.FileParametersPage;
import com.objfac.xmleditor.wizards.NewXMLWizard;
import com.objfac.xmleditor.wizards.SelectRootDialog;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewXMLFileParametersPage1
extends FileParametersPage {
    private Button fRootButton;
    private Button fFileBrowse;
    private String fNSDefault;
    private Text fNS;
    private Label fNSLabel;
    private Label fRootLabel;
    private Text fRoot;
    private Map fVariables;
    private Button fUseFile;
    private Label fFileLabel;
    private Text fFile;
    private String fFileDefault;
    private Button fUseDefault;

    public NewXMLFileParametersPage1(FileCreationWizard fileCreationWizard, String string, Map map) {
        super(fileCreationWizard, string);
        this.fVariables = map;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        this.fUseDefault = new Button(composite2, 16);
        this.fUseDefault.setText(Local.getString((String)"Use default template"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.horizontalSpan = 3;
        this.fUseDefault.setLayoutData((Object)gridLayout);
        this.fRootLabel = new Label(composite2, 16384);
        this.fRootLabel.setText(Local.getString((String)"Root element:"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.horizontalIndent = 18;
        this.fRootLabel.setLayoutData((Object)gridLayout);
        this.fRoot = new Text(composite2, 2052);
        gridLayout = new GridData(768);
        this.fRoot.setLayoutData((Object)gridLayout);
        this.fRoot.addModifyListener((ModifyListener)new RootListener());
        this.fRootButton = new Button(composite2, 8);
        this.fRootButton.setText(Local.getString((String)(!Config.pro() ? "Select From DTD" : "Select From Schema")));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 3;
        this.fRootButton.setLayoutData((Object)gridLayout);
        this.fRootButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewXMLFileParametersPage1.this.rootButtonPressed();
            }
        });
        this.fNSLabel = new Label(composite2, 16384);
        this.fNSLabel.setText(Local.getString((String)"Namespace:"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.horizontalIndent = 18;
        this.fNSLabel.setLayoutData((Object)gridLayout);
        this.fNS = new Text(composite2, 2052);
        gridLayout = new GridData(768);
        gridLayout.horizontalSpan = 2;
        this.fNS.setLayoutData((Object)gridLayout);
        this.fNS.addModifyListener((ModifyListener)new NSListener());
        NewXMLFileParametersPage1.insertSpacer(composite2, 3);
        this.fUseFile = new Button(composite2, 16);
        this.fUseFile.setText(Local.getString((String)"Use file as template"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.horizontalSpan = 3;
        this.fUseFile.setLayoutData((Object)gridLayout);
        this.fUseFile.addSelectionListener((SelectionListener)new UseFileListener());
        this.fFileLabel = new Label(composite2, 16384);
        this.fFileLabel.setText(Local.getString((String)"File path:"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 1;
        gridLayout.horizontalIndent = 18;
        this.fFileLabel.setLayoutData((Object)gridLayout);
        this.fFile = new Text(composite2, 2052);
        this.fFileDefault = (String)this.fVariables.get("file");
        this.fFile.setText(this.fFileDefault);
        this.fFile.setSelection(0, this.fFileDefault.length());
        gridLayout = new GridData(768);
        this.fFile.setLayoutData((Object)gridLayout);
        this.fFile.addModifyListener((ModifyListener)new FileListener());
        this.fFileBrowse = new Button(composite2, 8);
        this.fFileBrowse.setText(Local.getString((String)"Browse"));
        gridLayout = new GridData();
        gridLayout.horizontalAlignment = 3;
        this.fFileBrowse.setLayoutData((Object)gridLayout);
        this.fFileBrowse.addSelectionListener(this.getBrowseButtonListener(this.fFile, true));
        composite2.setTabList(new Control[]{this.fRoot, this.fNS, this.fFile});
        this.setControl((Control)composite2);
    }

    protected void rootButtonPressed() {
        NewXMLWizard newXMLWizard = (NewXMLWizard)this.getWizard();
        IFile iFile = newXMLWizard.getNewFile();
        SelectRootDialog selectRootDialog = new SelectRootDialog(this.getShell(), iFile);
        SelectRootDialog.SelectRootResult selectRootResult = selectRootDialog.show();
        if (selectRootResult != null) {
            this.fVariables.put("root", selectRootResult.rootName);
            this.fVariables.put("ns", selectRootResult.namespace);
            this.fVariables.put("noschema", Boolean.FALSE);
            this.fVariables.put("extdtd", Boolean.FALSE);
            this.fVariables.put("extxsd", Boolean.FALSE);
            this.fVariables.put("intdtd", selectRootResult.schemaKind == 1 ? Boolean.TRUE : Boolean.FALSE);
            this.fVariables.put("intxsd", selectRootResult.schemaKind == 4 ? Boolean.TRUE : Boolean.FALSE);
            this.fVariables.put("extrng", selectRootResult.schemaKind == 2 ? Boolean.TRUE : Boolean.FALSE);
            this.fVariables.put("extrnc", selectRootResult.schemaKind == 3 ? Boolean.TRUE : Boolean.FALSE);
            if (selectRootResult.schemaKind == 1) {
                this.fVariables.put("pubid", "");
                this.fVariables.put("sysid", selectRootResult.schemaUri);
                this.fVariables.put("loc", "");
                this.fVariables.put("locon", Boolean.FALSE);
            } else {
                this.fVariables.put("pubid", "");
                this.fVariables.put("sysid", "");
                this.fVariables.put("loc", selectRootResult.schemaUri);
                this.fVariables.put("locon", Boolean.TRUE);
            }
            this.fRoot.setText(selectRootResult.rootName);
            this.fNS.setText(selectRootResult.namespace);
            this.validate();
        }
    }

    private boolean noError() {
        return this.getErrorMessage() == null;
    }

    public IWizardPage getNextPage() {
        if (this.fUseFile.getSelection()) {
            return null;
        }
        return super.getNextPage();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.fUseFile.getSelection()) {
            this.fFile.setSelection(0, this.fFile.getText().length());
            if (!this.fFile.isFocusControl()) {
                this.fFile.setFocus();
            }
        } else {
            this.fRoot.setSelection(0, this.fRoot.getText().length());
            if (!this.fRoot.isFocusControl()) {
                this.fRoot.setFocus();
            }
        }
    }

    private void rootModified() {
        String string = this.fRoot.getText();
        int n = string.indexOf(58);
        this.fVariables.put("prefix", n > 0 ? string.substring(0, n) : "");
        this.fVariables.put("root", string);
        this.validate();
    }

    private void nsModified() {
        String string = this.fNS.getText();
        this.fVariables.put("ns", string);
        this.validate();
    }

    protected void doSetFromVariables() {
        Boolean bl = (Boolean)this.fVariables.get("usefile");
        this.fUseDefault.setSelection(bl == false);
        this.fUseFile.setSelection(bl.booleanValue());
        String string = (String)this.fVariables.get("root");
        this.fRoot.setText(string);
        this.fRoot.setSelection(0, string.length());
        String string2 = (String)this.fVariables.get("ns");
        this.fNS.setText(string2);
        this.fNS.setSelection(0, string2.length());
        String string3 = (String)this.fVariables.get("file");
        this.fFile.setText(string3);
        this.fFile.setSelection(0, string3.length());
    }

    protected void doValidate() {
        boolean bl = this.fUseFile.getSelection();
        String string = this.fRoot.getText();
        String string2 = this.fNS.getText();
        String string3 = this.fFile.getText();
        this.fVariables.put("usefile", bl ? Boolean.TRUE : Boolean.FALSE);
        this.fVariables.put("root", string);
        this.fVariables.put("ns", string2);
        this.fVariables.put("file", string3);
        this.fFileLabel.setEnabled(bl);
        this.fFile.setEnabled(bl);
        this.fFileBrowse.setEnabled(bl);
        this.fRoot.setEnabled(!bl);
        this.fRootLabel.setEnabled(!bl);
        this.fNS.setEnabled(!bl);
        this.fNSLabel.setEnabled(!bl);
        if (bl) {
            this.validateFile(string3);
        } else {
            this.setMessages(null, null);
        }
        this.setPageComplete(this.noError());
    }

    private class NSListener
    implements ModifyListener {
        NSListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            NewXMLFileParametersPage1.this.nsModified();
        }
    }

    private class RootListener
    implements ModifyListener {
        RootListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            NewXMLFileParametersPage1.this.rootModified();
        }
    }

    private class UseFileListener
    implements SelectionListener {
        UseFileListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            NewXMLFileParametersPage1.this.fUseFile.setSelection(false);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            NewXMLFileParametersPage1.this.validate();
        }
    }

    private class FileListener
    implements ModifyListener {
        FileListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string = NewXMLFileParametersPage1.this.fFile.getText();
            NewXMLFileParametersPage1.this.fVariables.put("file", string);
            NewXMLFileParametersPage1.this.validate();
        }
    }
}

