/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xmleditor.wizards;

import com.objfac.util.Local;
import com.objfac.xml.io.Encoding;
import com.objfac.xmleditor.properties.EncodingCombo;
import com.objfac.xmleditor.wizards.FileCreationWizard;
import com.objfac.xmleditor.wizards.FileParametersPage;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewXSLFileParametersPage3
extends FileParametersPage {
    private Label fEncodingLabel;
    private Button fStandalone;
    private Combo fEncoding;
    private EncodingCombo fEncodingCombo;
    private Button fXmlon;
    private Map fVariables;

    public NewXSLFileParametersPage3(FileCreationWizard fileCreationWizard, String string, Map map) {
        super(fileCreationWizard, string);
        this.fVariables = map;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Object object = new GridLayout(3, false);
        object.marginHeight = 5;
        object.marginWidth = 5;
        composite2.setLayout((Layout)object);
        this.fXmlon = new Button(composite2, 32);
        this.fXmlon.setText(Local.getString((String)"Generate <?xml declaration"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalSpan = 3;
        object.horizontalIndent = 5;
        this.fXmlon.setLayoutData(object);
        this.fXmlon.addSelectionListener((SelectionListener)new XmlonListener());
        this.fEncodingLabel = new Label(composite2, 16384);
        this.fEncodingLabel.setText(Local.getString((String)"Encoding:"));
        object = new GridData();
        object.horizontalAlignment = 1;
        object.horizontalIndent = 18;
        this.fEncodingLabel.setLayoutData(object);
        object = (String)this.fVariables.get("encoding");
        this.fEncodingCombo = new EncodingCombo(composite2, new EncodingListener(), (String)object);
        this.fEncoding = this.fEncodingCombo.getCombo();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        this.fEncoding.setLayoutData((Object)gridData);
        this.fStandalone = new Button(composite2, 32);
        this.fStandalone.setText(Local.getString((String)"Standalone"));
        gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 18;
        this.fStandalone.setLayoutData((Object)gridData);
        this.fStandalone.addSelectionListener((SelectionListener)new StandaloneListener());
        NewXSLFileParametersPage3.insertSpacer(composite2, 3);
        composite2.setTabList(new Control[]{this.fXmlon, this.fEncoding, this.fStandalone});
        this.setControl((Control)composite2);
    }

    private boolean noError() {
        return this.getErrorMessage() == null;
    }

    private void encodingModified() {
        this.validate();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    protected void doSetFromVariables() {
        Boolean bl = (Boolean)this.fVariables.get("xmlon");
        Boolean bl2 = (Boolean)this.fVariables.get("standalone");
        String string = (String)this.fVariables.get("encoding");
        this.fXmlon.setSelection(bl.booleanValue());
        this.fStandalone.setSelection(bl2.booleanValue());
        this.fEncoding.setText(string);
    }

    protected void doValidate() {
        boolean bl = this.fXmlon.getSelection();
        String string = this.fEncoding.getText();
        String string2 = Encoding.getStandardEquivalent((String)string);
        if (string2 != null) {
            string = string2;
        }
        boolean bl2 = this.fStandalone.getSelection();
        this.fVariables.put("xmlon", bl ? Boolean.TRUE : Boolean.FALSE);
        this.fVariables.put("encoding", string);
        this.fVariables.put("standalone", bl2 ? Boolean.TRUE : Boolean.FALSE);
        this.fEncodingLabel.setEnabled(bl);
        this.fEncoding.setEnabled(bl);
        this.fStandalone.setEnabled(bl);
        this.setMessages(null, null);
        this.setPageComplete(this.noError());
    }

    private class StandaloneListener
    implements SelectionListener {
        StandaloneListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            NewXSLFileParametersPage3.this.fStandalone.setSelection(false);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            NewXSLFileParametersPage3.this.validate();
        }
    }

    private class EncodingListener
    implements EncodingCombo.EncodingComboListener {
        EncodingListener() {
        }

        public void encodingChanged() {
            NewXSLFileParametersPage3.this.encodingModified();
        }
    }

    private class XmlonListener
    implements SelectionListener {
        XmlonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            NewXSLFileParametersPage3.this.fXmlon.setSelection(true);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            NewXSLFileParametersPage3.this.validate();
        }
    }
}

